/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.http.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.RequestPermissionException;
import com.google.gwt.http.client.StringValidator;
import com.google.gwt.http.client.XMLHTTPRequest;
import com.google.gwt.user.client.impl.HTTPRequestImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RequestBuilder {
    public static final Method GET = new Method("GET");
    public static final Method POST = new Method("POST");
    private static final HTTPRequestImpl httpRequest = (HTTPRequestImpl)GWT.create(HTTPRequestImpl.class);
    private Map headers;
    private String httpMethod;
    private String password;
    private int timeoutMillis;
    private String url;
    private String user;

    public RequestBuilder(Method httpMethod, String url) {
        this(httpMethod == null ? null : httpMethod.toString(), url);
    }

    protected RequestBuilder(String httpMethod, String url) {
        StringValidator.throwIfEmptyOrNull("httpMethod", httpMethod);
        StringValidator.throwIfEmptyOrNull("url", url);
        this.httpMethod = httpMethod;
        this.url = url;
    }

    public Request sendRequest(String requestData, RequestCallback callback) throws RequestException {
        if (this.user == null && this.password != null) {
            throw new IllegalStateException("A password is set, but no user is set");
        }
        JavaScriptObject xmlHttpRequest = httpRequest.createXmlHTTPRequest();
        String openError = this.password != null ? XMLHTTPRequest.open(xmlHttpRequest, this.httpMethod, this.url, true, this.user, this.password) : (this.user != null ? XMLHTTPRequest.open(xmlHttpRequest, this.httpMethod, this.url, true, this.user) : XMLHTTPRequest.open(xmlHttpRequest, this.httpMethod, this.url, true));
        if (openError != null) {
            RequestPermissionException requestPermissionException = new RequestPermissionException(this.url);
            requestPermissionException.initCause(new RequestException(openError));
            throw requestPermissionException;
        }
        this.setHeaders(xmlHttpRequest);
        Request request = new Request(xmlHttpRequest, this.timeoutMillis, callback);
        String sendError = XMLHTTPRequest.send(xmlHttpRequest, request, requestData, callback);
        if (sendError != null) {
            throw new RequestException(sendError);
        }
        return request;
    }

    public void setHeader(String header, String value) {
        StringValidator.throwIfEmptyOrNull("header", header);
        StringValidator.throwIfEmptyOrNull("value", value);
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        this.headers.put(header, value);
    }

    public void setPassword(String password) {
        StringValidator.throwIfEmptyOrNull("password", password);
        this.password = password;
    }

    public void setTimeoutMillis(int timeoutMillis) {
        if (timeoutMillis < 0) {
            throw new IllegalArgumentException("Timeouts cannot be negative");
        }
        this.timeoutMillis = timeoutMillis;
    }

    public void setUser(String user) {
        StringValidator.throwIfEmptyOrNull("user", user);
        this.user = user;
    }

    private void setHeaders(JavaScriptObject xmlHttpRequest) throws RequestException {
        if (this.headers != null && this.headers.size() > 0) {
            Set entrySet = this.headers.entrySet();
            Iterator iter = entrySet.iterator();
            while (iter.hasNext()) {
                Map.Entry header = iter.next();
                String errorMessage = XMLHTTPRequest.setRequestHeader(xmlHttpRequest, (String)header.getKey(), (String)header.getValue());
                if (errorMessage == null) continue;
                throw new RequestException(errorMessage);
            }
        } else {
            XMLHTTPRequest.setRequestHeader(xmlHttpRequest, "Content-Type", "text/plain; charset=utf-8");
        }
    }

    public static final class Method {
        private final String name;

        private Method(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

