/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;

public abstract class UIObject {
    private static final String EMPTY_STYLENAME_MSG = "Style names cannot be empty";
    private static final String NULL_HANDLE_MSG = "Null widget handle. If you are creating a composite, ensure that initWidget() has been called.";
    private Element element;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static native boolean isVisible(Element var0);

    public static native void setVisible(Element var0, boolean var1);

    protected static String getStyleName(Element elem) {
        return DOM.getElementProperty(elem, "className");
    }

    protected static String getStylePrimaryName(Element elem) {
        String fullClassName = UIObject.getStyleName(elem);
        int spaceIdx = fullClassName.indexOf(32);
        if (spaceIdx >= 0) {
            return fullClassName.substring(0, spaceIdx);
        }
        return fullClassName;
    }

    protected static void setStyleName(Element elem, String styleName) {
        DOM.setElementProperty(elem, "className", styleName);
    }

    protected static void setStyleName(Element elem, String style, boolean add) {
        int lastPos;
        int last;
        if (elem == null) {
            throw new RuntimeException(NULL_HANDLE_MSG);
        }
        if ((style = style.trim()).length() == 0) {
            throw new IllegalArgumentException(EMPTY_STYLENAME_MSG);
        }
        String oldStyle = UIObject.getStyleName(elem);
        int idx = oldStyle.indexOf(style);
        while (idx != -1 && (idx != 0 && oldStyle.charAt(idx - 1) != ' ' || (last = idx + style.length()) != (lastPos = oldStyle.length()) && (last >= lastPos || oldStyle.charAt(last) != ' '))) {
            idx = oldStyle.indexOf(style, idx + 1);
        }
        if (add) {
            if (idx == -1) {
                if (oldStyle.length() > 0) {
                    oldStyle = oldStyle + " ";
                }
                DOM.setElementProperty(elem, "className", oldStyle + style);
            }
        } else if (idx != -1) {
            String begin = oldStyle.substring(0, idx).trim();
            String end = oldStyle.substring(idx + style.length()).trim();
            String newClassName = begin.length() == 0 ? end : (end.length() == 0 ? begin : begin + " " + end);
            DOM.setElementProperty(elem, "className", newClassName);
        }
    }

    protected static void setStylePrimaryName(Element elem, String style) {
        if (elem == null) {
            throw new RuntimeException(NULL_HANDLE_MSG);
        }
        if ((style = style.trim()).length() == 0) {
            throw new IllegalArgumentException(EMPTY_STYLENAME_MSG);
        }
        UIObject.updatePrimaryAndDependentStyleNames(elem, style);
    }

    private static native void updatePrimaryAndDependentStyleNames(Element var0, String var1);

    public void addStyleDependentName(String styleSuffix) {
        this.addStyleName(this.getStylePrimaryName() + '-' + styleSuffix);
    }

    public void addStyleName(String style) {
        UIObject.setStyleName(this.getStyleElement(), style, true);
    }

    public int getAbsoluteLeft() {
        return DOM.getAbsoluteLeft(this.getElement());
    }

    public int getAbsoluteTop() {
        return DOM.getAbsoluteTop(this.getElement());
    }

    public Element getElement() {
        return this.element;
    }

    public int getOffsetHeight() {
        return DOM.getElementPropertyInt(this.element, "offsetHeight");
    }

    public int getOffsetWidth() {
        return DOM.getElementPropertyInt(this.element, "offsetWidth");
    }

    public String getStyleName() {
        return UIObject.getStyleName(this.getStyleElement());
    }

    public String getStylePrimaryName() {
        return UIObject.getStylePrimaryName(this.getStyleElement());
    }

    public String getTitle() {
        return DOM.getElementProperty(this.element, "title");
    }

    public boolean isVisible() {
        return UIObject.isVisible(this.element);
    }

    public void removeStyleDependentName(String styleSuffix) {
        this.removeStyleName(this.getStylePrimaryName() + '-' + styleSuffix);
    }

    public void removeStyleName(String style) {
        UIObject.setStyleName(this.getStyleElement(), style, false);
    }

    public void setHeight(String height) {
        if (!$assertionsDisabled && !(this.extractLengthValue(height.trim().toLowerCase()) >= 0.0)) {
            throw new AssertionError((Object)"CSS heights should not be negative");
        }
        DOM.setStyleAttribute(this.element, "height", height);
    }

    public void setPixelSize(int width, int height) {
        if (width >= 0) {
            this.setWidth(width + "px");
        }
        if (height >= 0) {
            this.setHeight(height + "px");
        }
    }

    public void setSize(String width, String height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public void setStyleName(String style) {
        UIObject.setStyleName(this.getStyleElement(), style);
    }

    public void setStylePrimaryName(String style) {
        UIObject.setStylePrimaryName(this.getStyleElement(), style);
    }

    public void setTitle(String title) {
        if (title == null || title.length() == 0) {
            DOM.removeElementAttribute(this.element, "title");
        } else {
            DOM.setElementAttribute(this.element, "title", title);
        }
    }

    public void setVisible(boolean visible) {
        UIObject.setVisible(this.element, visible);
    }

    public void setWidth(String width) {
        if (!$assertionsDisabled && !(this.extractLengthValue(width.trim().toLowerCase()) >= 0.0)) {
            throw new AssertionError((Object)"CSS widths should not be negative");
        }
        DOM.setStyleAttribute(this.element, "width", width);
    }

    public void sinkEvents(int eventBitsToAdd) {
        DOM.sinkEvents(this.getElement(), eventBitsToAdd | DOM.getEventsSunk(this.getElement()));
    }

    public String toString() {
        if (this.element == null) {
            return "(null handle)";
        }
        return DOM.toString(this.element);
    }

    public void unsinkEvents(int eventBitsToRemove) {
        DOM.sinkEvents(this.getElement(), DOM.getEventsSunk(this.getElement()) & ~eventBitsToRemove);
    }

    protected Element getStyleElement() {
        return this.element;
    }

    protected void setElement(Element elem) {
        if (this.element != null) {
            this.replaceNode(this.element, elem);
        }
        this.element = elem;
    }

    private native double extractLengthValue(String var1);

    private native void replaceNode(Element var1, Element var2);

    static {
        $assertionsDisabled = !UIObject.class.desiredAssertionStatus();
    }
}

