/*
 * Decompiled with CFR 0.152.
 */
package openxdas;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.TimeZone;
import openxdas.XDasException;
import openxdas.XDasRecord;

public class XDasSession {
    private static final int iOriginatorLocationName = 0;
    private static final int iOriginatorLocationAddress = 1;
    private static final int iOriginatorServiceType = 2;
    private static final int iOriginatorAuthAuthority = 3;
    private static final int iOriginatorPrincipalName = 4;
    private static final int iOriginatorPrincipalIdentity = 5;
    private static final int iOriginatorFieldCount = 6;
    private static final int XDASD_RESERVED_PORT = 7629;
    private String[] m_sOriginatorFields;
    private int m_iSecurity = 31;
    private Socket m_socket = null;
    public InputStream m_inputStream = null;
    public OutputStream m_outputStream = null;
    private TimeZone m_timeZone;
    private String m_sTimeSource;
    private String m_sTimeZone;
    private int m_iTimeUncertInterval;
    private int m_iTimeUncertIndicator;

    public XDasSession(String string) throws XDasException, SocketException, IOException {
        this.m_sOriginatorFields = XDasSession.parseSubStrings(string, 6, 16);
        this.setupSession();
    }

    public XDasSession(String string, String string2, String string3, String string4, String string5, String string6) throws XDasException, SocketException, IOException {
        this.m_sOriginatorFields = new String[6];
        this.m_sOriginatorFields[0] = XDasSession.formatString(string);
        this.m_sOriginatorFields[1] = XDasSession.formatString(string2);
        this.m_sOriginatorFields[2] = XDasSession.formatString(string3);
        this.m_sOriginatorFields[3] = XDasSession.formatString(string4);
        this.m_sOriginatorFields[4] = XDasSession.formatString(string5);
        this.m_sOriginatorFields[5] = XDasSession.formatString(string6);
        this.setupSession();
    }

    public XDasRecord XDasStartRecord(int n, int n2, String string, String string2, String string3) throws XDasException {
        return new XDasRecord(this, n, n2, string, string2, string3);
    }

    private void setupSession() throws SocketException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.m_sTimeSource = "";
        this.m_timeZone = TimeZone.getDefault();
        int n = -(this.m_timeZone.getRawOffset() / 1000);
        int n2 = n / 3600;
        int n3 = n % 3600 / 60;
        stringBuffer.append(this.m_timeZone.getDisplayName(false, 0));
        stringBuffer.append(n2);
        if (n3 != 0) {
            stringBuffer.append("%:");
            stringBuffer.append(n3);
        }
        if (this.m_timeZone.useDaylightTime()) {
            stringBuffer.append(this.m_timeZone.getDisplayName(true, 0));
        }
        this.m_sTimeZone = stringBuffer.toString();
        this.m_iTimeUncertInterval = 0;
        this.m_iTimeUncertIndicator = 0;
        this.m_socket = new Socket("localhost", 7629);
        this.m_inputStream = this.m_socket.getInputStream();
        this.m_outputStream = this.m_socket.getOutputStream();
    }

    protected void finalize() throws SocketException, IOException {
        if (this.m_inputStream != null) {
            this.m_inputStream.close();
        }
        if (this.m_outputStream != null) {
            this.m_outputStream.close();
        }
        if (this.m_socket != null) {
            this.m_socket.close();
        }
    }

    boolean hasRights(int n) {
        return (this.m_iSecurity & n) == n;
    }

    static String[] parseSubStrings(String string, int n, int n2) throws XDasException {
        int n3;
        int n4 = string.length();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        char[] cArray = string.toCharArray();
        String[] stringArray = new String[n];
        for (n3 = 0; n3 < n; ++n3) {
            stringArray[n3] = null;
        }
        n3 = 0;
        block5: while (n3 < n4) {
            if (n5 == n) {
                throw new XDasException(n2);
            }
            switch (cArray[n3]) {
                case '%': {
                    ++n7;
                    if (++n3 >= n4) continue block5;
                    ++n3;
                    ++n7;
                    continue block5;
                }
                case ':': {
                    if (n7 > 0) {
                        stringArray[n5] = new String(cArray, n6, n7);
                    }
                    ++n5;
                    n7 = 0;
                    n6 = n3 + 1;
                    ++n3;
                    continue block5;
                }
            }
            ++n3;
            ++n7;
        }
        if (n7 > 0) {
            stringArray[n5] = new String(cArray, n6, n7);
        }
        return stringArray;
    }

    static String formatString(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ':' || c == '%') {
                stringBuffer.append('%');
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    String[] getOriginatorFields() {
        return this.m_sOriginatorFields;
    }

    String getTimeSource() {
        return this.m_sTimeSource;
    }

    String getTimeZone() {
        return this.m_sTimeZone;
    }

    int getUncertInterval() {
        return this.m_iTimeUncertInterval;
    }

    int getUncertIndicator() {
        return this.m_iTimeUncertIndicator;
    }
}

