/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites.optimizer;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.ProbabilityFactory;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityDataModel;
import com.hp.hpl.jena.sparql.suites.optimizer.Util;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestData
extends TestCase {
    private static Model graphM = null;
    private static ProbabilityDataModel probability = null;
    private static final String testDataFileName = "testing/Optimizer/Test-data.n3";

    public TestData(String title) {
        super(title);
    }

    public static void oneTimeSetUp() {
        graphM = Util.readModel(testDataFileName);
        probability = (ProbabilityDataModel)ProbabilityFactory.loadDataModel(Util.readModel(testDataFileName), null);
    }

    public static void oneTimeTearDown() {
        graphM.close();
    }

    public void testDataGraphSize() {
        TestData.assertEquals((long)probability.getDataGraphSize(), (long)37L);
    }

    public void testMinProbability() {
        TestData.assertEquals((double)probability.getMinProbability(), (double)0.02702702702702703, (double)0.0);
    }

    public void testSquaredDataGraphSize() {
        TestData.assertEquals((double)probability.getSquaredDataGraphSize(), (double)1369.0, (double)0.0);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite("TestData");
        ts.addTest((Test)new TestData("testDataGraphSize"));
        ts.addTest((Test)new TestData("testMinProbability"));
        ts.addTest((Test)new TestData("testSquaredDataGraphSize"));
        TestSetup wrapper = new TestSetup((Test)ts){

            protected void setUp() {
                TestData.oneTimeSetUp();
            }

            protected void tearDown() {
                TestData.oneTimeTearDown();
            }
        };
        return wrapper;
    }
}

