/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPTLSSocketFactory;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.ietf.ldap.LDAPSocketFactory;

public class LDAPJSSEStartTLSFactory
implements LDAPTLSSocketFactory,
LDAPSocketFactory {
    private SSLSocketFactory factory;
    private boolean pauseForHandShake = false;

    public LDAPJSSEStartTLSFactory() {
        this.factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    public LDAPJSSEStartTLSFactory(SSLSocketFactory sSLSocketFactory) {
        this.factory = sSLSocketFactory;
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return new Socket(string, n);
    }

    public Socket createSocket(Socket socket) throws IOException, UnknownHostException {
        SSLSocket sSLSocket = (SSLSocket)this.factory.createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), false);
        sSLSocket.addHandshakeCompletedListener(new HandShakeFinished(this));
        this.pauseForHandShake = true;
        sSLSocket.startHandshake();
        try {
            while (this.pauseForHandShake) {
                Thread.currentThread();
                Thread.sleep(5L);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Internal error: Could not pause main thread while waiting for TLS handshake to complete");
        }
        return sSLSocket;
    }

    private class HandShakeFinished
    implements HandshakeCompletedListener {
        private LDAPJSSEStartTLSFactory ssf;

        public HandShakeFinished(LDAPJSSEStartTLSFactory lDAPJSSEStartTLSFactory2) {
            this.ssf = lDAPJSSEStartTLSFactory2;
        }

        public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
            this.ssf.pauseForHandShake = false;
        }
    }
}

