/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPModification
implements Externalizable {
    private int op;
    private LDAPAttribute attr;
    public static final int ADD = 0;
    public static final int DELETE = 1;
    public static final int REPLACE = 2;

    public LDAPModification() {
    }

    public LDAPModification(int n, LDAPAttribute lDAPAttribute) {
        this.op = n;
        this.attr = lDAPAttribute;
    }

    public LDAPAttribute getAttribute() {
        return this.attr;
    }

    public int getOp() {
        return this.op;
    }

    void newLine(int n, Writer writer) throws IOException {
        String string = "    ";
        writer.write("\n");
        for (int i = 0; i < n; ++i) {
            writer.write(string);
        }
    }

    public void writeDSML(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        outputStreamWriter.write("<modification name=\"");
        outputStreamWriter.write(this.attr.getName());
        outputStreamWriter.write("\" operation=\"");
        switch (this.getOp()) {
            case 0: {
                outputStreamWriter.write("add");
                break;
            }
            case 1: {
                outputStreamWriter.write("delete");
                break;
            }
            case 2: {
                outputStreamWriter.write("replace");
            }
        }
        outputStreamWriter.write("\">");
        LDAPAttribute lDAPAttribute = this.getAttribute();
        String[] stringArray = lDAPAttribute.getStringValueArray();
        byte[][] byArray = lDAPAttribute.getByteValueArray();
        for (int i = 0; i < stringArray.length; ++i) {
            this.newLine(1, outputStreamWriter);
            if (Base64.isValidUTF8(byArray[i], false)) {
                outputStreamWriter.write("<value>");
                outputStreamWriter.write(stringArray[i]);
                outputStreamWriter.write("</value>");
                continue;
            }
            outputStreamWriter.write("<value xsi:type=\"xsd:base64Binary\">");
            outputStreamWriter.write(Base64.encode(byArray[i]));
            outputStreamWriter.write("</value>");
        }
        this.newLine(0, outputStreamWriter);
        outputStreamWriter.write("</modification>");
        ((Writer)outputStreamWriter).close();
    }

    public static Object readDSML(InputStream inputStream) throws IOException {
        SAXEventMultiplexer sAXEventMultiplexer = new SAXEventMultiplexer();
        sAXEventMultiplexer.setLDAPXMLHandler(LDAPModification.getXMLHandler("modification", null));
        return (LDAPModification)sAXEventMultiplexer.parseXML(inputStream);
    }

    static LDAPXMLHandler getXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            String attrName;
            int operation;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler(this));
            }

            protected void endElement() {
                Object object;
                LDAPAttribute lDAPAttribute = new LDAPAttribute(this.attrName);
                if (!this.valuelist.isEmpty()) {
                    object = this.valuelist.iterator();
                    while (object.hasNext()) {
                        lDAPAttribute.addValue((byte[])object.next());
                    }
                }
                object = new LDAPModification(this.operation, lDAPAttribute);
                this.setObject(object);
            }

            protected void addValue(String string, Object object) {
                if (string.equals("value")) {
                    this.valuelist.add(object);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.attrName = attributes.getValue("name");
                String string = attributes.getValue("operation");
                if (string == null || this.attrName == null) {
                    throw new SAXException("Required attribute missing from tag <modification> (operation or name are required)");
                }
                if (string.equals("add")) {
                    this.operation = 0;
                } else if (string.equals("replace")) {
                    this.operation = 2;
                } else if (string.equals("delete")) {
                    this.operation = 1;
                } else {
                    throw new SAXException("Invalid value for attribute 'operation': " + string);
                }
            }
        };
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LDAPModification: (operation=");
        switch (this.getOp()) {
            case 0: {
                stringBuffer.append("add");
                break;
            }
            case 1: {
                stringBuffer.append("delete");
                break;
            }
            case 2: {
                stringBuffer.append("replace");
            }
        }
        stringBuffer.append(",(" + this.getAttribute() + "))");
        return stringBuffer.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append(ValueXMLhandler.newLine(0));
        String string = "";
        string = string + "*************************************************************************\n";
        string = string + "** The encrypted data above and below is the Class definition and  ******\n";
        string = string + "** other data specific to Java Serialization Protocol. The data  ********\n";
        string = string + "** which is of most application specific interest is as follows... ******\n";
        string = string + "*************************************************************************\n";
        string = string + "****************** Start of application data ****************************\n";
        string = string + "*************************************************************************\n";
        stringBuffer.append(string);
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append("<modification name=\"");
        stringBuffer.append(this.attr.getName());
        stringBuffer.append("\" operation=\"");
        switch (this.getOp()) {
            case 0: {
                stringBuffer.append("add");
                break;
            }
            case 1: {
                stringBuffer.append("delete");
                break;
            }
            case 2: {
                stringBuffer.append("replace");
            }
        }
        stringBuffer.append("\">");
        LDAPAttribute lDAPAttribute = this.getAttribute();
        String[] stringArray = lDAPAttribute.getStringValueArray();
        byte[][] byArray = lDAPAttribute.getByteValueArray();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(ValueXMLhandler.newLine(1));
            if (Base64.isValidUTF8(byArray[i], false)) {
                stringBuffer.append("<value>");
                stringBuffer.append(stringArray[i]);
                stringBuffer.append("</value>");
                continue;
            }
            stringBuffer.append("<value xsi:type=\"xsd:base64Binary\">");
            stringBuffer.append(Base64.encode(byArray[i]));
            stringBuffer.append("</value>");
        }
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append("</modification>");
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append(ValueXMLhandler.newLine(0));
        String string2 = "";
        string2 = string2 + "*************************************************************************\n";
        string2 = string2 + "****************** End of application data ******************************\n";
        string2 = string2 + "*************************************************************************\n";
        stringBuffer.append(string2);
        stringBuffer.append(ValueXMLhandler.newLine(0));
        objectOutput.writeUTF(stringBuffer.toString());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = objectInput.readUTF();
        String string2 = string.substring(string.indexOf(60), string.lastIndexOf(62) + 1);
        StringBuffer stringBuffer = new StringBuffer();
        ValueXMLhandler.parseInput(string2, stringBuffer);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(stringBuffer.toString().getBytes()));
        LDAPModification lDAPModification = (LDAPModification)LDAPModification.readDSML(bufferedInputStream);
        this.op = lDAPModification.getOp();
        this.attr = lDAPModification.getAttribute();
        lDAPModification = null;
    }
}

