/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSchema;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPDITContentRuleSchema;
import com.novell.ldap.LDAPDITStructureRuleSchema;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPMatchingRuleSchema;
import com.novell.ldap.LDAPMatchingRuleUseSchema;
import com.novell.ldap.LDAPNameFormSchema;
import com.novell.ldap.LDAPObjectClassSchema;
import com.novell.ldap.LDAPSchemaElement;
import com.novell.ldap.LDAPSyntaxSchema;
import com.novell.ldap.client.EnumeratedIterator;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPSchema
extends LDAPEntry {
    private HashMap[] idTable = new HashMap[8];
    private HashMap[] nameTable = new HashMap[8];
    static final String[] schemaTypeNames = new String[]{"attributeTypes", "objectClasses", "ldapSyntaxes", "nameForms", "dITContentRules", "dITStructureRules", "matchingRules", "matchingRuleUse"};
    static final int ATTRIBUTE = 0;
    static final int OBJECT_CLASS = 1;
    static final int SYNTAX = 2;
    static final int NAME_FORM = 3;
    static final int DITCONTENT = 4;
    static final int DITSTRUCTURE = 5;
    static final int MATCHING = 6;
    static final int MATCHING_USE = 7;

    public LDAPSchema() {
    }

    public LDAPSchema(LDAPEntry lDAPEntry) {
        super(lDAPEntry.getDN(), lDAPEntry.getAttributeSet());
        for (int i = 0; i < schemaTypeNames.length; ++i) {
            this.idTable[i] = new HashMap();
            this.nameTable[i] = new HashMap();
        }
        Iterator iterator = super.getAttributeSet().iterator();
        while (iterator.hasNext()) {
            LDAPSchemaElement lDAPSchemaElement;
            String string;
            LDAPAttribute lDAPAttribute = (LDAPAttribute)iterator.next();
            String string2 = lDAPAttribute.getName();
            Enumeration enumeration = lDAPAttribute.getStringValues();
            if (string2.equalsIgnoreCase(schemaTypeNames[1])) {
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    try {
                        lDAPSchemaElement = new LDAPObjectClassSchema(string);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    this.addElement(1, lDAPSchemaElement);
                }
                continue;
            }
            if (string2.equalsIgnoreCase(schemaTypeNames[0])) {
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    try {
                        lDAPSchemaElement = new LDAPAttributeSchema(string);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    this.addElement(0, lDAPSchemaElement);
                }
                continue;
            }
            if (string2.equalsIgnoreCase(schemaTypeNames[2])) {
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    lDAPSchemaElement = new LDAPSyntaxSchema(string);
                    this.addElement(2, lDAPSchemaElement);
                }
                continue;
            }
            if (string2.equalsIgnoreCase(schemaTypeNames[6])) {
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    lDAPSchemaElement = new LDAPMatchingRuleSchema(string, null);
                    this.addElement(6, lDAPSchemaElement);
                }
                continue;
            }
            if (string2.equalsIgnoreCase(schemaTypeNames[7])) {
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    lDAPSchemaElement = new LDAPMatchingRuleUseSchema(string);
                    this.addElement(7, lDAPSchemaElement);
                }
                continue;
            }
            if (string2.equalsIgnoreCase(schemaTypeNames[4])) {
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    lDAPSchemaElement = new LDAPDITContentRuleSchema(string);
                    this.addElement(4, lDAPSchemaElement);
                }
                continue;
            }
            if (string2.equalsIgnoreCase(schemaTypeNames[5])) {
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    lDAPSchemaElement = new LDAPDITStructureRuleSchema(string);
                    this.addElement(5, lDAPSchemaElement);
                }
                continue;
            }
            if (!string2.equalsIgnoreCase(schemaTypeNames[3])) continue;
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                lDAPSchemaElement = new LDAPNameFormSchema(string);
                this.addElement(3, lDAPSchemaElement);
            }
        }
    }

    private void addElement(int n, LDAPSchemaElement lDAPSchemaElement) {
        this.idTable[n].put(lDAPSchemaElement.getID(), lDAPSchemaElement);
        String[] stringArray = lDAPSchemaElement.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.nameTable[n].put(stringArray[i].toUpperCase(), lDAPSchemaElement);
        }
    }

    private LDAPSchemaElement getSchemaElement(int n, String string) {
        if (string == null || string.equalsIgnoreCase("")) {
            return null;
        }
        char c = string.charAt(0);
        if (c >= '0' && c <= '9') {
            return (LDAPSchemaElement)this.idTable[n].get(string);
        }
        return (LDAPSchemaElement)this.nameTable[n].get(string.toUpperCase());
    }

    public LDAPAttributeSchema getAttributeSchema(String string) {
        return (LDAPAttributeSchema)this.getSchemaElement(0, string);
    }

    public LDAPDITContentRuleSchema getDITContentRuleSchema(String string) {
        return (LDAPDITContentRuleSchema)this.getSchemaElement(4, string);
    }

    public LDAPDITStructureRuleSchema getDITStructureRuleSchema(String string) {
        return (LDAPDITStructureRuleSchema)this.getSchemaElement(5, string);
    }

    public LDAPDITStructureRuleSchema getDITStructureRuleSchema(int n) {
        Integer n2 = new Integer(n);
        return (LDAPDITStructureRuleSchema)this.idTable[5].get(n2);
    }

    public LDAPMatchingRuleSchema getMatchingRuleSchema(String string) {
        return (LDAPMatchingRuleSchema)this.getSchemaElement(6, string);
    }

    public LDAPMatchingRuleUseSchema getMatchingRuleUseSchema(String string) {
        return (LDAPMatchingRuleUseSchema)this.getSchemaElement(7, string);
    }

    public LDAPNameFormSchema getNameFormSchema(String string) {
        return (LDAPNameFormSchema)this.getSchemaElement(3, string);
    }

    public LDAPObjectClassSchema getObjectClassSchema(String string) {
        return (LDAPObjectClassSchema)this.getSchemaElement(1, string);
    }

    public LDAPSyntaxSchema getSyntaxSchema(String string) {
        return (LDAPSyntaxSchema)this.getSchemaElement(2, string);
    }

    public Enumeration getAttributeSchemas() {
        return new EnumeratedIterator(this.idTable[0].values().iterator());
    }

    public Enumeration getDITContentRuleSchemas() {
        return new EnumeratedIterator(this.idTable[4].values().iterator());
    }

    public Enumeration getDITStructureRuleSchemas() {
        return new EnumeratedIterator(this.idTable[5].values().iterator());
    }

    public Enumeration getMatchingRuleSchemas() {
        return new EnumeratedIterator(this.idTable[6].values().iterator());
    }

    public Enumeration getMatchingRuleUseSchemas() {
        return new EnumeratedIterator(this.idTable[7].values().iterator());
    }

    public Enumeration getNameFormSchemas() {
        return new EnumeratedIterator(this.idTable[3].values().iterator());
    }

    public Enumeration getObjectClassSchemas() {
        return new EnumeratedIterator(this.idTable[1].values().iterator());
    }

    public Enumeration getSyntaxSchemas() {
        return new EnumeratedIterator(this.idTable[2].values().iterator());
    }

    public Enumeration getAttributeNames() {
        return new EnumeratedIterator(this.nameTable[0].keySet().iterator());
    }

    public Enumeration getDITContentRuleNames() {
        return new EnumeratedIterator(this.nameTable[4].keySet().iterator());
    }

    public Enumeration getDITStructureRuleNames() {
        return new EnumeratedIterator(this.nameTable[5].keySet().iterator());
    }

    public Enumeration getMatchingRuleNames() {
        return new EnumeratedIterator(this.nameTable[6].keySet().iterator());
    }

    public Enumeration getMatchingRuleUseNames() {
        return new EnumeratedIterator(this.nameTable[7].keySet().iterator());
    }

    public Enumeration getNameFormNames() {
        return new EnumeratedIterator(this.nameTable[3].keySet().iterator());
    }

    public Enumeration getObjectClassNames() {
        return new EnumeratedIterator(this.nameTable[1].keySet().iterator());
    }

    private int getType(LDAPSchemaElement lDAPSchemaElement) {
        if (lDAPSchemaElement instanceof LDAPAttributeSchema) {
            return 0;
        }
        if (lDAPSchemaElement instanceof LDAPObjectClassSchema) {
            return 1;
        }
        if (lDAPSchemaElement instanceof LDAPSyntaxSchema) {
            return 2;
        }
        if (lDAPSchemaElement instanceof LDAPNameFormSchema) {
            return 3;
        }
        if (lDAPSchemaElement instanceof LDAPMatchingRuleSchema) {
            return 6;
        }
        if (lDAPSchemaElement instanceof LDAPMatchingRuleUseSchema) {
            return 7;
        }
        if (lDAPSchemaElement instanceof LDAPDITContentRuleSchema) {
            return 4;
        }
        if (lDAPSchemaElement instanceof LDAPDITStructureRuleSchema) {
            return 5;
        }
        throw new IllegalArgumentException("The specified schema element type is not recognized");
    }

    public static Object readDSML(InputStream inputStream) throws IOException {
        SAXEventMultiplexer sAXEventMultiplexer = new SAXEventMultiplexer();
        sAXEventMultiplexer.setLDAPXMLHandler(LDAPSchema.getXMLHandler("LDAPEntry", null));
        return (LDAPSchema)sAXEventMultiplexer.parseXML(inputStream);
    }

    static LDAPXMLHandler getXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            String dn;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPAttribute.getXMLHandler("attr", this));
            }

            protected void endElement() {
                LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                lDAPAttributeSet.addAll((Collection)this.valuelist);
                LDAPEntry lDAPEntry = new LDAPEntry(this.dn, lDAPAttributeSet);
                LDAPSchema lDAPSchema = new LDAPSchema(lDAPEntry);
                this.setObject(lDAPSchema);
            }

            protected void addValue(String string, Object object) {
                if (string.equals("attr")) {
                    this.valuelist.add(object);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.dn = attributes.getValue("dn");
                if (this.dn == null) {
                    throw new SAXException("invalid entry Tag, dn is mandatory element: ");
                }
            }
        };
    }
}

