/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.ac.ws;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.servlet.http.HttpServletRequest;
import javax.xml.ws.WebServiceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.impl.dv.util.Base64;
import org.eclipse.higgins.ac.ws.model.bean.AuditService;
import org.eclipse.higgins.ac.ws.model.entity.ICMUsageEntity;
import org.eclipse.higgins.ac.ws.model.entity.UserProfileEntity;
import org.eclipse.higgins.ac.ws.model.to.CardTO;
import org.eclipse.higgins.ac.ws.model.to.ICMUsageTO;
import org.eclipse.higgins.ac.ws.model.to.QueryStateTO;
import org.eclipse.higgins.ac.ws.model.to.ServerInfoTO;
import org.eclipse.higgins.ac.ws.model.to.UserProfileAudtitTO;
import org.eclipse.higgins.ac.ws.model.to.UserProfileTO;
import org.eclipse.higgins.ac.ws.util.AuditServiseStatus;
import org.eclipse.higgins.ac.ws.util.ConvertHelper;
import org.eclipse.higgins.ac.ws.util.HibernateUtil;
import org.eclipse.higgins.cache.CacheProviderFactory;
import org.eclipse.higgins.cache.api.ICache;
import org.eclipse.higgins.cache.api.ICacheKey;
import org.eclipse.higgins.cache.api.key.UserCacheKey;
import org.eclipse.higgins.rpps.core.impl.RppsService;
import org.eclipse.higgins.rpps.core.tobj.ICardResponseTO;
import org.eclipse.higgins.rpps.core.tobj.ICardTO;
import org.eclipse.higgins.rpps.core.tobj.ResponseMessage;
import org.eclipse.higgins.user.login.UserAccount;
import org.hibernate.Query;
import org.hibernate.classic.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(name="AdminConsoleWS", serviceName="AdminWS")
public class AdminWS {
    private static ICache userProfileCache = null;
    private static final Log LOG = LogFactory.getLog(AdminWS.class);
    private AuditService auditService = new AuditService();
    private final ConvertHelper convertHelper = new ConvertHelper();
    @Resource
    WebServiceContext wsContext;

    private String getUserName() {
        HttpServletRequest request = (HttpServletRequest)this.wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.request");
        return request.getRemoteUser();
    }

    @WebMethod
    public ServerInfoTO getServerInfo() throws RemoteException {
        LOG.debug((Object)"start getServerInfo ");
        try {
            ServerInfoTO info = new ServerInfoTO();
            info.setRPPSEndpoint("/rpps-axis/");
            LOG.debug((Object)"getServerInfo is sucsessful");
            this.auditService.saveAuditRecord(this.getUserName(), "getServerInfo", new HashMap<String, String>(), AuditServiseStatus.Successful);
            return info;
        }
        catch (RuntimeException e) {
            LOG.error((Object)e, (Throwable)e);
            this.auditService.saveAuditRecord(this.getUserName(), "getServerInfo", new HashMap<String, String>(), AuditServiseStatus.Failed, e.getMessage());
            throw new RemoteException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebMethod
    public Boolean setNewPassword(UserProfileTO userProfile, String password) throws RemoteException {
        Boolean res = new Boolean(false);
        LOG.debug((Object)("start setNewPassword, id = " + userProfile.getId()));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userProfile", userProfile.toString());
        parameters.put("password", password);
        try {
            Session session = HibernateUtil.getUserProfileAuditSF().openSession();
            try {
                session.getTransaction().begin();
                Query updateUserProfileQuery = session.getNamedQuery("updateUserProfileHash");
                updateUserProfileQuery.setLong("id", userProfile.getId().longValue());
                updateUserProfileQuery.setString("passwordHash", this.getPasswordHash(password));
                updateUserProfileQuery.executeUpdate();
                LOG.debug((Object)("UserProfile password  was updated, id = " + userProfile.getId()));
                this.auditService.saveAuditRecord(this.getUserName(), "setNewPassword", parameters, AuditServiseStatus.Successful);
                AdminWS.getUserProfileCache().remove((ICacheKey)new UserCacheKey(userProfile.getLogin()));
                session.getTransaction().commit();
                res = new Boolean(true);
            }
            catch (Exception e) {
                session.getTransaction().rollback();
                LOG.error((Object)"getUserProfileList failed", (Throwable)e);
                this.auditService.saveAuditRecord(this.getUserName(), "setNewPassword", parameters, AuditServiseStatus.Failed, e.getMessage());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"getUserProfileList failed", (Throwable)e);
            this.auditService.saveAuditRecord(this.getUserName(), "setNewPassword", parameters, AuditServiseStatus.Failed, e.getMessage());
        }
        return res;
    }

    @WebMethod
    public Boolean deleteUserProfile(Long userProfileId, String cardsOwner) throws RemoteException {
        LOG.debug((Object)("start deleteUserProfile, id = " + userProfileId));
        Boolean res = new Boolean(false);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userProfileId", userProfileId.toString());
        parameters.put("cardsOwner", cardsOwner);
        try {
            RppsService rppsService = new RppsService();
            ResponseMessage resMessage = rppsService.deleteUserProfile(new UserAccount().setUserId((Serializable)((Object)("urn:" + cardsOwner))));
            if (resMessage.getCode() == 0) {
                LOG.debug((Object)"deleteUserProfile is sucsessful");
                this.auditService.saveAuditRecord(this.getUserName(), "deleteUserProfile", parameters, AuditServiseStatus.Successful);
                res = new Boolean(true);
            } else {
                LOG.error((Object)("deleteUserProfile failed: " + resMessage.getMessage()));
                this.auditService.saveAuditRecord(this.getUserName(), "deleteUserProfile", parameters, AuditServiseStatus.Failed, resMessage.getMessage());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"deleteUserProfile failed", (Throwable)e);
            this.auditService.saveAuditRecord(this.getUserName(), "deleteUserProfile", parameters, AuditServiseStatus.Failed, e.getMessage());
        }
        return res;
    }

    public String getPasswordHash(String password) {
        if (password != null && password.length() > 0) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                return Base64.encode((byte[])md.digest(password.getBytes("UTF-8"))).trim();
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebMethod
    public List<UserProfileTO> getUserProfileList(QueryStateTO queryStateTO) {
        LOG.debug((Object)"getUserProfileList");
        String user = this.getUserName();
        ArrayList<UserProfileTO> result = new ArrayList<UserProfileTO>();
        try {
            List<UserProfileEntity> listEntity = this.auditService.getUserProfileEntityList(queryStateTO);
            for (UserProfileEntity entity : listEntity) {
                if (entity == null) continue;
                result.add(new UserProfileTO().setCreated(entity.getCreated()).setEmail(entity.getEmail()).setId(entity.getId()).setLogin(entity.getLogin()).setPasswordHash(entity.getPasswordHash()).setSms(entity.getSms()).setSendMeNews(entity.getSendMeNews()).setReferralTracking(entity.getReferralTracking()));
            }
            LOG.debug((Object)"getUserProfileList successful");
        }
        catch (Exception e) {
            LOG.error((Object)"getUserProfileList failed", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebMethod
    public List<CardTO> getUserCardList(Long userProfileId, String cardsOwner) {
        LOG.debug((Object)"getUserCardList");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userProfileId", userProfileId.toString());
        parameters.put("cardsOwner", cardsOwner.toString());
        try {
            RppsService rppsService = new RppsService();
            ICardResponseTO cardResponce = rppsService.getICardsByUser(new UserAccount().setUserId((Serializable)((Object)("urn:" + cardsOwner))));
            CardTO[] cardTO = new CardTO[]{};
            if (cardResponce != null && cardResponce.getICardList() != null) {
                ICardTO[] iCardTO = cardResponce.getICardList();
                cardTO = new CardTO[iCardTO.length];
                for (int i = 0; i < iCardTO.length; ++i) {
                    cardTO[i] = this.convertHelper.convertToCardTO(iCardTO[i]);
                }
            }
            LOG.debug((Object)"getUserCardList is successful");
            this.auditService.saveAuditRecord(this.getUserName(), "getUserCardList", parameters, AuditServiseStatus.Successful);
            List<CardTO> list = Arrays.asList(cardTO);
            return list;
        }
        catch (Exception e) {
            LOG.error((Object)"getUserCardList is failed", (Throwable)e);
            this.auditService.saveAuditRecord(this.getUserName(), "getUserCardList", parameters, AuditServiseStatus.Failed, e.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebMethod
    public Boolean deleteUserCard(Long userProfileId, String cardsOwner, String cuid) throws RemoteException {
        LOG.debug((Object)"deleteUserCard");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userProfileId", userProfileId.toString());
        parameters.put("cardsOwner", cardsOwner.toString());
        parameters.put("cuid", cuid);
        try {
            RppsService rppsService = new RppsService();
            rppsService.deleteICard(new UserAccount().setUserId((Serializable)((Object)("urn:" + cardsOwner))), cuid);
            LOG.debug((Object)"deleteUserCard is successful");
            this.auditService.saveAuditRecord(this.getUserName(), "deleteUserCard", parameters, AuditServiseStatus.Successful);
        }
        catch (Exception e) {
            LOG.error((Object)"deleteUserCard is failed", (Throwable)e);
            this.auditService.saveAuditRecord(this.getUserName(), "deleteUserCard", parameters, AuditServiseStatus.Failed, e.getMessage());
        }
        return new Boolean(true);
    }

    public static ICache getUserProfileCache() {
        if (userProfileCache == null) {
            userProfileCache = CacheProviderFactory.getCacheProvider().getCache("UserProfile.UserProfiles");
        }
        return userProfileCache;
    }

    @WebMethod
    public ICMUsageTO[] getICMUsageReportByRef(Date dt1, Date dt2, String ref) {
        List<ICMUsageEntity> usageReportByRef = this.auditService.getICMUsageReportByRef(dt1, dt2, ref);
        ICMUsageTO[] res = new ICMUsageTO[usageReportByRef.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.convertHelper.ICMUsageEntityToICMUsageTO(usageReportByRef.get(i));
        }
        return res;
    }

    @WebMethod
    public ICMUsageTO[] getICMUsageSumaryReport(Date dt1, Date dt2) {
        List<ICMUsageEntity> usageReportByRef = this.auditService.getICMUsageReports(dt1, dt2);
        ICMUsageTO[] res = new ICMUsageTO[usageReportByRef.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.convertHelper.ICMUsageEntityToICMUsageTO(usageReportByRef.get(i));
        }
        return res;
    }

    @WebMethod
    public UserProfileAudtitTO[] getAccountListByRefferal(Date dt1, Date dt2, String ref) {
        List<UserProfileAudtitTO> usageReportByRef = this.auditService.getAccountListByRefferal(dt1, dt2, ref);
        return usageReportByRef.toArray(new UserProfileAudtitTO[usageReportByRef.size()]);
    }

    @WebMethod
    public void generateICMUsageReport(Date currentDate) throws RemoteException {
        try {
            this.auditService.generateICMUsageReport(currentDate);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }
}

