/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.ac.ws.model.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.ac.ws.model.entity.AuditEntity;
import org.eclipse.higgins.ac.ws.model.entity.ICMUsageEntity;
import org.eclipse.higgins.ac.ws.model.entity.UserActivities;
import org.eclipse.higgins.ac.ws.model.entity.UserProfileEntity;
import org.eclipse.higgins.ac.ws.model.to.FilterConditionTO;
import org.eclipse.higgins.ac.ws.model.to.QueryStateTO;
import org.eclipse.higgins.ac.ws.model.to.UserProfileAudtitTO;
import org.eclipse.higgins.ac.ws.util.AuditServiseStatus;
import org.eclipse.higgins.ac.ws.util.HibernateUtil;
import org.hibernate.Query;
import org.hibernate.classic.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditService {
    private static final int DEFAULT_MINIMAL_YEAR = 1977;
    private static final int DEFAULT_SLOW_PERIOD = 90;
    private static final int DEFAULT_ACTIVE_PERIOD = 7;
    private static final Log LOG = LogFactory.getLog(AuditService.class);

    public void generateICMUsageReport(Date currentDate) throws Exception {
        Session session = null;
        GregorianCalendar calendar = new GregorianCalendar();
        if (null == currentDate) {
            currentDate = calendar.getTime();
        }
        Date priorRunDate = null;
        Date activeEnding = null;
        Date slowEnding = null;
        calendar.add(6, -7);
        activeEnding = calendar.getTime();
        calendar.add(6, -83);
        slowEnding = calendar.getTime();
        try {
            priorRunDate = this.getPreviousICMUsageReportDate();
            if (null == priorRunDate) {
                priorRunDate = calendar.getTime();
            }
            session = HibernateUtil.getUserProfileAuditSF().openSession();
            session.beginTransaction();
            for (Object refItem : this.getReferralTrackingList()) {
                Long added = (Long)session.getNamedQuery("getNewUserCnt").setDate("dt1", priorRunDate).setDate("dt2", currentDate).setString("ref", (String)refItem).uniqueResult();
                Long total = (Long)session.getNamedQuery("getTotalUserCnt").setString("ref", (String)refItem).uniqueResult();
                Long active = (Long)session.getNamedQuery("getActivitiesCnt").setDate("dt1", activeEnding).setDate("dt2", currentDate).setString("ref", (String)refItem).uniqueResult();
                Long slow = (Long)session.getNamedQuery("getActivitiesCnt").setDate("dt1", slowEnding).setDate("dt2", activeEnding).setString("ref", (String)refItem).uniqueResult();
                Long abandoned = new Long(total - active - slow);
                this.saveICMUsageReport(new ICMUsageEntity().setWeekEnding(currentDate).setAdded(added).setActive(active).setSlow(slow).setAbandoned(abandoned).setReferralTracking((String)refItem));
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            if (session != null) {
                session.getTransaction().rollback();
            }
            throw e;
        }
        finally {
            session.close();
        }
    }

    private List<Object> getReferralTrackingList() {
        Session session = null;
        try {
            session = HibernateUtil.getUserProfileAuditSF().getCurrentSession();
            session.beginTransaction();
            List res = session.getNamedQuery("getReferralTrackingList").list();
            session.getTransaction().commit();
            return res;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            if (session != null) {
                session.getTransaction().rollback();
            }
            return null;
        }
    }

    public List<ICMUsageEntity> getICMUsageReports(Date dt1, Date dt2) {
        List usageReports;
        block4: {
            if (null == dt1) {
                Calendar cal = Calendar.getInstance();
                cal.set(5, 1);
                cal.set(2, 0);
                dt1 = cal.getTime();
            }
            if (null == dt2) {
                dt2 = new Date();
            }
            Session session = null;
            usageReports = null;
            try {
                session = HibernateUtil.getUserProfileAuditSF().getCurrentSession();
                session.beginTransaction();
                usageReports = session.getNamedQuery("getIcmUsageReport").setDate("dt1", dt1).setDate("dt2", dt2).list();
                session.getTransaction().commit();
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
                if (session == null) break block4;
                session.getTransaction().rollback();
            }
        }
        return usageReports;
    }

    public List<ICMUsageEntity> getICMUsageReportByRef(Date dt1, Date dt2, String ref) {
        List usageReports;
        block5: {
            if (null == dt1) {
                Calendar cal = Calendar.getInstance();
                cal.set(5, 1);
                cal.set(2, 0);
                dt1 = cal.getTime();
            }
            if (null == dt2) {
                dt2 = new Date();
            }
            if (null == ref || "".equals(ref.trim())) {
                ref = "%";
            }
            Session session = null;
            usageReports = null;
            try {
                session = HibernateUtil.getUserProfileAuditSF().getCurrentSession();
                session.beginTransaction();
                usageReports = session.getNamedQuery("getIcmUsageReportByRef").setDate("dt1", dt1).setDate("dt2", dt2).setString("ref", ref).list();
                session.getTransaction().commit();
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
                if (session == null) break block5;
                session.getTransaction().rollback();
            }
        }
        return usageReports;
    }

    private Date getPreviousICMUsageReportDate() throws Exception {
        Session session = null;
        Date prevDate = null;
        try {
            session = HibernateUtil.getUserProfileAuditSF().getCurrentSession();
            session.beginTransaction();
            Object result = session.getNamedQuery("getPriorRunDt").uniqueResult();
            if (result != null) {
                prevDate = (Date)result;
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            if (session != null) {
                session.getTransaction().rollback();
            }
            throw e;
        }
        return prevDate;
    }

    public void saveAuditRecord(String user, String operation, Map<String, String> parameters, AuditServiseStatus status) {
        this.saveAuditRecord(user, operation, parameters, status, "");
    }

    public void saveAuditRecord(String user, String operation, Map<String, String> parameters, AuditServiseStatus status, String errorMessage) {
        LOG.debug((Object)"saveAuditRecord begin");
        try {
            Session session = HibernateUtil.getUserProfileAuditSF().getCurrentSession();
            try {
                session.beginTransaction();
                session.persist((Object)new AuditEntity(user, operation, parameters, status.toString(), errorMessage));
                session.getTransaction().commit();
                LOG.debug((Object)"saveAuditRecord successful");
            }
            catch (Exception e) {
                LOG.error((Object)"saveAuditRecord failed", (Throwable)e);
                session.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"saveAuditRecord failed", (Throwable)e);
        }
        LOG.debug((Object)"saveAuditRecord finish");
    }

    private void saveICMUsageReport(ICMUsageEntity usageEntity) {
        Session session = null;
        try {
            session = HibernateUtil.getUserProfileAuditSF().getCurrentSession();
            session.beginTransaction();
            session.save((Object)usageEntity);
            session.getTransaction().commit();
        }
        catch (Exception e) {
            if (session != null) {
                session.getTransaction().rollback();
            }
            LOG.error((Object)e, (Throwable)e);
        }
    }

    public void saveUserActivity(Serializable userIdentifier) {
        Session session = null;
        try {
            session = HibernateUtil.getUserProfileAuditSF().getCurrentSession();
            session.beginTransaction();
            session.saveOrUpdate((Object)new UserActivities().setLastUsage(new Date()).setUserIdentifier(userIdentifier.toString()));
            session.getTransaction().commit();
        }
        catch (Exception e) {
            if (session != null) {
                session.getTransaction().rollback();
            }
            LOG.error((Object)e, (Throwable)e);
        }
    }

    public void deleteUserActivity(Serializable userIdentifier) {
        block2: {
            Session session = null;
            try {
                session = HibernateUtil.getUserProfileAuditSF().getCurrentSession();
                session.beginTransaction();
                session.getNamedQuery("deleteActivities").setString("userId", userIdentifier.toString()).executeUpdate();
                session.getTransaction().commit();
            }
            catch (Exception e) {
                LOG.warn((Object)"Couldn't delete user activity record!", (Throwable)e);
                if (session == null) break block2;
                session.getTransaction().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserProfileEntity> getUserProfileEntityList(QueryStateTO queryStateTO) {
        LOG.debug((Object)"getUserProfileListEntity");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("queryStateTO", queryStateTO.toString());
        List result = null;
        try {
            Session session = HibernateUtil.getUserProfileAuditSF().openSession();
            try {
                StringBuffer sql = new StringBuffer(session.getNamedQuery("getUserProfile").getQueryString());
                if (queryStateTO.getFilterList().size() > 0) {
                    sql.append(" where  ");
                    for (Map.Entry<String, FilterConditionTO> entry : queryStateTO.getFilterList().entrySet()) {
                        sql.append(" ").append(entry.getValue().getFieldName()).append(" ").append(entry.getValue().getOperator()).append(" ").append(entry.getValue().getFilterValue());
                    }
                }
                if (null != queryStateTO.getOrderBy() && queryStateTO.getOrderBy().length() > 0) {
                    sql.append(" order by " + queryStateTO.getOrderBy());
                }
                Query query = session.createQuery(sql.toString());
                query.setMaxResults(queryStateTO.getMaxResults().intValue());
                query.setFirstResult(queryStateTO.getStartFrom().intValue());
                query.setReadOnly(true);
                session.beginTransaction();
                result = query.list();
                LOG.debug((Object)"getUserProfileEntityList is successful");
                session.getTransaction().commit();
            }
            catch (Exception e) {
                session.getTransaction().rollback();
                LOG.error((Object)"getUserProfileEntityList is failed", (Throwable)e);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"getUserProfileEntityList is failed", (Throwable)e);
        }
        return result;
    }

    public List<UserProfileAudtitTO> getAccountListByRefferal(Date dt1, Date dt2, String ref) {
        LOG.debug((Object)"getAccountListByRefferal");
        if (null == dt1) {
            Calendar cal = Calendar.getInstance();
            cal.set(5, 1);
            cal.set(2, 0);
            dt1 = cal.getTime();
        }
        if (null == dt2) {
            dt2 = new Date();
        }
        if (null == ref || "".equals(ref.trim())) {
            ref = "%";
        }
        ArrayList<UserProfileAudtitTO> result = new ArrayList<UserProfileAudtitTO>();
        Session session = HibernateUtil.getUserProfileAuditSF().getCurrentSession();
        try {
            session.beginTransaction();
            Query query = session.getNamedQuery("accountListByReferrer");
            query.setReadOnly(true);
            query.setDate("dt1", dt1);
            query.setDate("dt2", dt2);
            query.setString("ref", ref);
            List data = query.list();
            for (Object[] item : data) {
                result.add((UserProfileAudtitTO)new UserProfileAudtitTO().setLastUsage((Date)item[5]).setLogin((String)item[0]).setEmail((String)item[1]).setReferralTracking((String)item[2]).setCreated((Date)item[3]).setSendMeNews((Boolean)item[4]));
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            LOG.error((Object)"getAccountListByRefferalis failed", (Throwable)e);
            session.getTransaction().rollback();
        }
        return result;
    }
}

