/*******************************************************************************
 * Copyright (c) 2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.as;

import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.xdi4j.Graph;
import org.eclipse.higgins.xdi4j.Literal;
import org.eclipse.higgins.xdi4j.Predicate;
import org.eclipse.higgins.xdi4j.Reference;
import org.eclipse.higgins.xdi4j.Subject;
import org.eclipse.higgins.xdi4j.exceptions.MessagingException;
import org.eclipse.higgins.xdi4j.messaging.Message;
import org.eclipse.higgins.xdi4j.messaging.server.EndpointRegistry;
import org.eclipse.higgins.xdi4j.messaging.server.impl.ResourceHandler;
import org.eclipse.higgins.xdi4j.messaging.server.impl.ResourceMessagingTarget;

public class AttributeMessagingTarget extends ResourceMessagingTarget {

	private int deep;

	private IContext context;
	private IAttribute attribute;

	private Object executionContext;

	public AttributeMessagingTarget(int deep, IContext context, IAttribute attribute, Object executionContext) {

		super(false);

		this.deep = deep;
		this.context = context;
		this.attribute = attribute;
		this.executionContext = executionContext;
	}

	@Override
	public void init(EndpointRegistry endpointRegistry) throws Exception {

		super.init(endpointRegistry);
	}

	@Override
	public void shutdown() throws Exception {

		super.shutdown();
	}

	@Override
	public Object getExecutionContext() {
		
		return(this.executionContext);
	}
	
	@Override
	public ResourceHandler getResource(Message message, Subject subject) throws MessagingException {

		return(new AttributeSubjectResourceHandler(message, subject, this.deep, this.context, this.attribute));
	}

	@Override
	public ResourceHandler getResource(Message message, Subject subject, Predicate predicate) throws MessagingException {

		return(new AttributeSubjectPredicateResourceHandler(message, subject, predicate, this.deep, this.context, this.attribute));
	}

	@Override
	public ResourceHandler getResource(Message message, Subject subject, Predicate predicate, Reference reference) throws MessagingException {

		return(new AttributeSubjectPredicateReferenceResourceHandler(message, subject, predicate, reference, this.deep, this.context, this.attribute));
	}

	@Override
	public ResourceHandler getResource(Message message, Subject subject, Predicate predicate, Literal literal) throws MessagingException {

		return(new AttributeSubjectPredicateLiteralResourceHandler(message, subject, predicate, literal, this.deep, this.context, this.attribute));
	}

	@Override
	public ResourceHandler getResource(Message message, Subject subject, Predicate predicate, Graph innerGraph) throws MessagingException {

		return(new AttributeSubjectPredicateInnerGraphResourceHandler(message, subject, predicate, innerGraph, this.deep, this.context, this.attribute));
	}
}
