package org.eclipse.higgins.as.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class SynchronizingUtil {

	private SynchronizingUtil() { }

	public static int getCurrentVersion(String contextUdi) throws IOException {

		File file = new File(getVersionFilenameForContextUdi(contextUdi));
		if (! file.exists()) return 0;

		BufferedReader reader = new BufferedReader(new FileReader(file));
		int version = Integer.parseInt(reader.readLine());
		reader.close();

		return version;
	}

	public static synchronized int incCurrentVersion(String contextUdi) throws IOException {

		int version = getCurrentVersion(contextUdi);
		version++;

		File file = new File(getVersionFilenameForContextUdi(contextUdi));

		FileWriter writer = new FileWriter(file, false);
		writer.write(Integer.toString(version) + "\n");
		writer.close();

		return version;
	}

	private static String getVersionFilenameForContextUdi(String contextUdi) {

		try {

			File file = new File("./pds");
			if (! file.exists()) file.mkdir();
			
			return "./pds/" + URLEncoder.encode(contextUdi, "UTF-8") + ".sync.version";
		} catch (UnsupportedEncodingException ex) {

			throw new RuntimeException(ex);
		}
	}
}
