/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko -  initial API and implementation
 * 
 */
package org.eclipse.higgins.cache.api;

import java.util.Properties;

/**
 * @author Alexander Yuhimenko
 * 
 */

public interface ICacheProvider {

	/**
	 * Property name from CacheConfiguration.xml
	 */
	public static final String CacheProviderClassName = "CacheProviderClassName";

	/**
	 * Property name from CacheConfiguration.xml
	 */
	public static final String CacheProviderConfigurationURL = "CacheProviderConfigurationURL";

	/**
	 * Initial configuration
	 * 
	 * @param properties
	 *            has property need for configure (CacheProviderConfigurationURL etc)
	 */
	public void configure(Properties properties);

	/**
	 * @param name
	 *            cache name, if cache don't found provider must create default cache
	 * @return cache instance
	 */
	public ICache getCache(String name);
}
