/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko -  initial API and implementation
 * 
 */
package org.eclipse.higgins.cache.api.key;

import java.io.Serializable;

import org.eclipse.higgins.cache.CacheException;
import org.eclipse.higgins.cache.api.ICacheKey;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class CacheKey implements ICacheKey {

	/**
	 * 
	 */
	private static final long serialVersionUID = 4390182947667190509L;
	protected final String key;

	/**
	 * @param key
	 * @throws CacheException
	 *             if key is null.
	 */
	public CacheKey(String key) throws CacheException {
		if (null == key) {
			throw new CacheException("Key is null");
		}
		this.key = key;
	}

	public Serializable getKey() {
		return this.key;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((key == null) ? 0 : key.hashCode());
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		CacheKey other = (CacheKey) obj;
		if (key == null) {
			if (other.key != null)
				return false;
		} else
			if (!key.equals(other.key))
				return false;
		return true;
	}

}