/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.blocking;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.BlockingCache;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.LockTimeoutException;
import net.sf.ehcache.constructs.blocking.UpdatingCacheEntryFactory;

public class SelfPopulatingCache
extends BlockingCache {
    private static final Logger LOG = Logger.getLogger(SelfPopulatingCache.class.getName());
    protected final CacheEntryFactory factory;

    public SelfPopulatingCache(Ehcache cache, CacheEntryFactory factory) throws CacheException {
        super(cache);
        this.factory = factory;
    }

    public Element get(Object key) throws LockTimeoutException {
        try {
            Element element = super.get(key);
            if (element == null) {
                Object value = this.factory.createEntry(key);
                element = new Element(key, value);
                this.put(element);
            }
            return element;
        }
        catch (LockTimeoutException e) {
            String message = "Timeout after " + this.timeoutMillis + " waiting on another thread " + "to fetch object for cache entry \"" + key + "\".";
            throw new LockTimeoutException(message, e);
        }
        catch (Throwable throwable) {
            this.put(new Element(key, null));
            throw new CacheException("Could not fetch object for cache entry with key \"" + key + "\".", throwable);
        }
    }

    public void refresh() throws CacheException {
        Throwable exception = null;
        Object keyWithException = null;
        List keys = this.getKeys();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest(this.getName() + ": found " + keys.size() + " keys to refresh");
        }
        for (Object key : keys) {
            try {
                Ehcache backingCache = this.getCache();
                Element element = backingCache.getQuiet(key);
                if (element == null) {
                    if (!LOG.isLoggable(Level.FINEST)) continue;
                    LOG.finest(this.getName() + ": entry with key " + key + " has been removed - skipping it");
                    continue;
                }
                this.refreshElement(element, backingCache);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, this.getName() + "Could not refresh element " + key, e);
                exception = e;
            }
        }
        if (exception != null) {
            throw new CacheException(exception.getMessage() + " on refresh with key " + keyWithException);
        }
    }

    protected void refreshElement(Element element, Ehcache backingCache) throws Exception {
        Element replacementElement;
        Object key = element.getObjectKey();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest(this.getName() + ": refreshing element with key " + key);
        }
        if (this.factory instanceof UpdatingCacheEntryFactory) {
            replacementElement = element;
            ((UpdatingCacheEntryFactory)this.factory).updateEntryValue(key, replacementElement.getValue());
        } else {
            Object value = this.factory.createEntry(key);
            replacementElement = new Element(key, value);
        }
        backingCache.putQuiet(replacementElement);
    }
}

