/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.hibernate;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.hibernate.cache.Cache;
import org.hibernate.cache.Timestamper;

public final class EhCache
implements Cache {
    private static final Logger LOG = Logger.getLogger(EhCache.class.getName());
    private static final int SIXTY_THOUSAND_MS = 60000;
    private final Ehcache cache;

    public EhCache(Ehcache cache) {
        this.cache = cache;
    }

    public final Object get(Object key) throws org.hibernate.cache.CacheException {
        try {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("key: " + key);
            }
            if (key == null) {
                return null;
            }
            Element element = this.cache.get(key);
            if (element == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Element for " + key + " is null");
                }
                return null;
            }
            return element.getObjectValue();
        }
        catch (CacheException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
    }

    public final Object read(Object key) throws org.hibernate.cache.CacheException {
        return this.get(key);
    }

    public final void update(Object key, Object value) throws org.hibernate.cache.CacheException {
        this.put(key, value);
    }

    public final void put(Object key, Object value) throws org.hibernate.cache.CacheException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("key: " + key + " value: " + value);
        }
        try {
            Element element = new Element(key, value);
            this.cache.put(element);
        }
        catch (IllegalArgumentException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
    }

    public final void remove(Object key) throws org.hibernate.cache.CacheException {
        try {
            this.cache.remove(key);
        }
        catch (ClassCastException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
    }

    public final void clear() throws org.hibernate.cache.CacheException {
        try {
            this.cache.removeAll();
        }
        catch (IllegalStateException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
    }

    public final void destroy() throws org.hibernate.cache.CacheException {
        try {
            this.cache.getCacheManager().removeCache(this.cache.getName());
        }
        catch (IllegalStateException e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "This can happen if multiple frameworks both try to shutdown ehcache", e);
            }
        }
        catch (CacheException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
    }

    public final void lock(Object key) throws org.hibernate.cache.CacheException {
    }

    public final void unlock(Object key) throws org.hibernate.cache.CacheException {
    }

    public final long nextTimestamp() {
        return Timestamper.next();
    }

    public final int getTimeout() {
        return 245760000;
    }

    public final String getRegionName() {
        return this.cache.getName();
    }

    public final long getSizeInMemory() {
        try {
            return this.cache.calculateInMemorySize();
        }
        catch (Throwable t) {
            return -1L;
        }
    }

    public final long getElementCountInMemory() {
        try {
            return this.cache.getMemoryStoreSize();
        }
        catch (CacheException ce) {
            throw new org.hibernate.cache.CacheException((Throwable)ce);
        }
    }

    public final long getElementCountOnDisk() {
        return this.cache.getDiskStoreSize();
    }

    public final Map toMap() {
        try {
            HashMap result = new HashMap();
            for (Object key : this.cache.getKeys()) {
                result.put(key, this.cache.get(key).getObjectValue());
            }
            return result;
        }
        catch (Exception e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
    }

    public final String toString() {
        return "EHCache(" + this.getRegionName() + ')';
    }

    final Ehcache getBackingCache() {
        return this.cache;
    }
}

