/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.concurrent.ConcurrentLinkedHashMap;
import net.sf.ehcache.store.MemoryStore;
import net.sf.ehcache.store.Store;

public class LruMemoryStore
extends MemoryStore {
    private static final Logger LOG = Logger.getLogger(LruMemoryStore.class.getName());

    public LruMemoryStore(Ehcache cache, Store diskStore) {
        super(cache, diskStore);
        try {
            this.map = new ConcurrentLinkedHashMap(ConcurrentLinkedHashMap.EvictionPolicy.SECOND_CHANCE, cache.getCacheConfiguration().getMaxElementsInMemory(), new LruEvictionListener());
        }
        catch (CacheException e) {
            LOG.log(Level.SEVERE, cache.getName() + "Cache: Cannot start LruMemoryStore. Initial cause was " + e.getMessage(), e);
        }
    }

    protected void doPut(Element element) throws CacheException {
    }

    public final class LruEvictionListener
    implements ConcurrentLinkedHashMap.EvictionListener {
        public void onEviction(Object key, Object value) {
            Element element = (Element)value;
            if (element.isExpired()) {
                LruMemoryStore.this.notifyExpiry(element);
            } else {
                LruMemoryStore.this.evict(element);
            }
        }
    }
}

