/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko -  initial API and implementation
 * 
 */
package org.eclipse.higgins.cache.ehcache;

import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.cache.CacheException;
import org.eclipse.higgins.cache.api.ICache;
import org.eclipse.higgins.cache.api.ICacheKey;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class EHCache implements ICache {

	private static final Log log = LogFactory.getLog(EHCache.class);

	private final Cache cache;

	/**
	 * @param cache
	 */
	public EHCache(final Cache cache) {
		super();
		this.cache = cache;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.cache.api.ICache#clear()
	 */
	public void clear() throws CacheException {
		log.debug("clear");
		this.cache.removeAll();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.cache.api.ICache#get(org.eclipse.higgins.cache.api.ICacheKey)
	 */
	public Object get(final ICacheKey key) throws CacheException {
		log.debug("get: key= " + key.toString());
		if (key == null) {
			log.error("get: key is null");
			return null;
		}

		final Element element = this.cache.get(key.getKey());
		if (element != null) {
			log.debug("get: successful");
			return element.getObjectValue();
		}
		log.debug("get: element is null");
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.cache.api.ICache#put(org.eclipse.higgins.cache.api.ICacheKey, java.lang.Object)
	 */
	public void put(final ICacheKey key, final Object value) throws CacheException {
		log.debug("put");
		if (key != null) {
			final Element element = new Element(key.getKey(), value);
			this.cache.put(element);
			log.debug("put: successful");
		} else {
			log.error("put: key is null");
			throw new CacheException("Couldn't put element, key is null");
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.cache.api.ICache#remove(org.eclipse.higgins.cache.api.ICacheKey)
	 */
	public void remove(final ICacheKey key) throws CacheException {
		if (key != null) {
			this.cache.remove(key.getKey());
			log.debug("remove: successful");
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.cache.api.ICache#update(org.eclipse.higgins.cache.api.ICacheKey, java.lang.Object)
	 */
	public void update(final ICacheKey key, final Object value) throws CacheException {
		put(key, value);
	}

	/**
	 * @return
	 * @throws IllegalStateException
	 * @throws CacheException
	 * @see net.sf.ehcache.Cache#calculateInMemorySize()
	 */
	public final long calculateInMemorySize() throws IllegalStateException, net.sf.ehcache.CacheException {
		return this.cache.calculateInMemorySize();
	}

	/**
	 * @return
	 * @throws IllegalStateException
	 * @see net.sf.ehcache.Cache#getMemoryStoreSize()
	 */
	public final long getMemoryStoreSize() throws IllegalStateException {
		return this.cache.getMemoryStoreSize();
	}

	/**
	 * @param key
	 * @return
	 * @see net.sf.ehcache.Cache#isKeyInCache(java.lang.Object)
	 */
	public boolean isKeyInCache(ICacheKey key) {
		// return this.cache.isKeyInCache(key);
		return null != this.cache.get(key);
	}

}
