/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko -  initial API and implementation
 * 
 */
package org.eclipse.higgins.cache.ehcache;

import java.util.Properties;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.cache.CacheException;
import org.eclipse.higgins.cache.api.ICache;
import org.eclipse.higgins.cache.api.ICacheProvider;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class EHCacheProvider implements org.eclipse.higgins.cache.api.ICacheProvider {

	private static final Log log = LogFactory.getLog(EHCacheProvider.class);

	private CacheManager cacheManager = null;

	/**
	 * 
	 */
	public EHCacheProvider() {
		log.info("create new " + EHCacheProvider.class.getName());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.cache.api.ICacheProvider#getCache()
	 */
	public ICache getCache(final String name) {
		log.debug("getCache");
		try {
			Cache cache = this.cacheManager.getCache(name);
			if (cache == null) {
				log.debug("getCache: Cache configuration is absent for :" + name);
				this.cacheManager.addCache(name);
				cache = this.cacheManager.getCache(name);
				log.debug("getCache: Create default cache :" + name);
			}
			log.debug("getCache: Cache create sucsessful");
			return new EHCache(cache);
		} catch (final Exception e) {
			log.error("getCache: Errors:", e);
			throw new CacheException(e);
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.cache.api.ICacheProvider#configure(java.util.Properties)
	 */
	public void configure(Properties properties) {
		log.info("configure");
		if (this.cacheManager == null) {
			if (properties == null) {
				log.error("properties is null");
				throw new CacheException("properties is null");
			}

			if (properties.get(ICacheProvider.CacheProviderConfigurationURL) == null) {
				log.error("init: Couldn't get " + ICacheProvider.CacheProviderConfigurationURL + " property");
				throw new CacheException("Couldn't get " + ICacheProvider.CacheProviderConfigurationURL + " property");
			}

			try {
				// final URL url = new URL(properties.get(ICacheProvider.CacheProviderConfigurationURL).toString());
				// log.info("init: URL is " + url.toString());
				// this.cacheManager = CacheManager.create(url);
				this.cacheManager = CacheManager.create(properties.get(ICacheProvider.CacheProviderConfigurationURL)
						.toString());

				log.info("CacheManager create sucsessful");
			} catch (final Exception e) {
				log.error(" Errors:", e);
				throw new CacheException(e);
			}
			log.info("configure successful");
		} else {
			log.debug("already was configured");
		}
	}

}
