/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.util.logging.Logger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.concurrent.ConcurrentLinkedHashMap;
import net.sf.ehcache.store.MemoryStore;
import net.sf.ehcache.store.Store;

public class FifoMemoryStore
extends MemoryStore {
    private static final Logger LOG = Logger.getLogger(FifoMemoryStore.class.getName());

    public FifoMemoryStore(Ehcache cache, Store diskStore) {
        super(cache, diskStore);
        this.map = new ConcurrentLinkedHashMap(ConcurrentLinkedHashMap.EvictionPolicy.FIFO, cache.getCacheConfiguration().getMaxElementsInMemory(), new FifoEvictionListener());
    }

    protected void doPut(Element element) throws CacheException {
    }

    public final class FifoEvictionListener
    implements ConcurrentLinkedHashMap.EvictionListener {
        public void onEviction(Object key, Object value) {
            Element element = (Element)value;
            if (element.isExpired()) {
                FifoMemoryStore.this.notifyExpiry(element);
            } else {
                FifoMemoryStore.this.evict(element);
            }
        }
    }
}

