/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.LfuPolicy;
import net.sf.ehcache.store.MemoryStore;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.Store;

public class LfuMemoryStore
extends MemoryStore {
    private static final Logger LOG = Logger.getLogger(LfuMemoryStore.class.getName());
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int CONCURRENCY_LEVEL = 100;
    private Policy policy = new LfuPolicy();

    protected LfuMemoryStore(Ehcache cache, Store diskStore) {
        super(cache, diskStore);
        this.map = new ConcurrentHashMap(cache.getCacheConfiguration().getMaxElementsInMemory(), 0.75f, 100);
    }

    public final synchronized void doPut(Element elementJustAdded) {
        if (this.isFull()) {
            this.removeLfuElement(elementJustAdded);
        }
    }

    private void removeLfuElement(Element elementJustAdded) {
        Element element;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Cache is full. Removing LFU element ...");
        }
        if ((element = this.findRelativelyUnused(elementJustAdded)) == null) {
            return;
        }
        if (element.isExpired()) {
            this.remove(element.getObjectKey());
            this.notifyExpiry(element);
            return;
        }
        this.evict(element);
        this.remove(element.getObjectKey());
    }

    final Element findRelativelyUnused(Element elementJustAdded) {
        Element[] elements = this.sampleElements(this.map.size());
        return this.policy.selectedBasedOnPolicy(elements, elementJustAdded);
    }

    Element[] sampleElements(int size) {
        int[] offsets = LfuPolicy.generateRandomSample(size);
        Element[] elements = new Element[offsets.length];
        Iterator iterator = this.map.values().iterator();
        for (int i = 0; i < offsets.length; ++i) {
            for (int j = 0; j < offsets[i]; ++j) {
                try {
                    iterator.next();
                    continue;
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
            }
            try {
                elements[i] = (Element)iterator.next();
                continue;
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
        }
        return elements;
    }
}

