/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko -  initial API and implementation
 * 
 */
package org.eclipse.higgins.cache.ehcache;

import java.util.Properties;

import org.eclipse.higgins.cache.api.ICacheKey;
import org.eclipse.higgins.cache.api.ICacheProvider;
import org.eclipse.higgins.cache.api.key.UserCacheKey;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class EHCacheTest {

	private static EHCacheProvider provider;
	private static EHCache cache;

	/**
	 * @throws java.lang.Exception
	 */
	@BeforeClass
	public static void setUp() throws Exception {
		final Properties properties = new Properties();
		properties.put(ICacheProvider.CacheProviderConfigurationURL, EHCacheTest.class.getResource(
				"/org/eclipse/higgins/cache/ehcache/ehcache.xml").toString());
		provider = new EHCacheProvider();
		provider.configure(properties);
		cache = (EHCache) provider.getCache("UserProfile-ICardMetadata");
	}

	private final Object cacheVal0 = new String("Copyright (c) 2007 Parity Communications, Inc.");
	private final Object cacheVal1 = new String("All rights reserved. This program and the accompanying materials");

	private final ICacheKey key = new UserCacheKey("0");

	/**
	 * Test method for
	 * {@link org.eclipse.higgins.cache.ehcache.EHCache#put(org.eclipse.higgins.cache.api.ICacheKey, java.lang.Object)}.
	 */
	@Test
	public final void testPut() {
		EHCacheTest.cache.put(this.key, this.cacheVal0);
	}

	/**
	 * Test method for {@link org.eclipse.higgins.cache.ehcache.EHCache#get(org.eclipse.higgins.cache.api.ICacheKey)}.
	 */
	@Test
	public final void testGet() {
		Assert.assertEquals(EHCacheTest.cache.get(this.key), this.cacheVal0);
	}

	/**
	 * Test method for {@link org.eclipse.higgins.cache.ehcache.EHCache#calculateInMemorySize()}.
	 */
	@Test
	public final void testCalculateInMemorySize() {
		System.out.println(EHCacheTest.cache.calculateInMemorySize());
	}

	/**
	 * Test method for {@link org.eclipse.higgins.cache.ehcache.EHCache#getMemoryStoreSize()}.
	 */
	@Test
	public final void testGetMemoryStoreSize() {
		// fail("Not yet implemented"); // TODO
		System.out.println(EHCacheTest.cache.getMemoryStoreSize());
	}

	/**
	 * Test method for {@link org.eclipse.higgins.cache.ehcache.EHCache#isKeyInCache(java.lang.Object)}.
	 */
	@Test
	public final void testIsKeyInCache() {
		Assert.assertTrue(EHCacheTest.cache.isKeyInCache(this.key));
	}

	/**
	 * Test method for
	 * {@link org.eclipse.higgins.cache.ehcache.EHCache#update(org.eclipse.higgins.cache.api.ICacheKey, java.lang.Object)}.
	 */
	@Test
	public final void testUpdate() {
		EHCacheTest.cache.update(this.key, this.cacheVal1);
		Assert.assertEquals(EHCacheTest.cache.get(this.key), this.cacheVal1);
	}

	/**
	 * Test method for {@link org.eclipse.higgins.cache.ehcache.EHCache#remove(org.eclipse.higgins.cache.api.ICacheKey)}.
	 */
	@Test
	public final void testRemove() {
		EHCacheTest.cache.remove(this.key);
		Assert.assertTrue(!EHCacheTest.cache.isKeyInCache(this.key));
	}

	/**
	 * Test method for {@link org.eclipse.higgins.cache.ehcache.EHCache#clear()}.
	 */
	@Test
	public final void testClear() {
		EHCacheTest.cache.clear();
	}

}
