/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.concurrent;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentLinkedHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    private static final EvictionListener<?, ?> nullListener = new EvictionListener<Object, Object>(){

        @Override
        public void onEviction(Object key, Object value) {
        }
    };
    private static final long serialVersionUID = 8350170357874293408L;
    final ConcurrentMap<K, Node<K, V>> data;
    final EvictionListener<K, V> listener;
    final AtomicInteger capacity;
    final EvictionPolicy policy;
    final AtomicInteger length;
    final Node<K, V> head;
    final Node<K, V> tail;

    public ConcurrentLinkedHashMap(EvictionPolicy policy, int maximumCapacity) {
        this(policy, maximumCapacity, 16, nullListener);
    }

    public ConcurrentLinkedHashMap(EvictionPolicy policy, int maximumCapacity, EvictionListener<K, V> listener) {
        this(policy, maximumCapacity, 16, listener);
    }

    public ConcurrentLinkedHashMap(EvictionPolicy policy, int maximumCapacity, int concurrencyLevel) {
        this(policy, maximumCapacity, 16, nullListener);
    }

    public ConcurrentLinkedHashMap(EvictionPolicy policy, int maximumCapacity, int concurrencyLevel, EvictionListener<K, V> listener) {
        if (policy == null || maximumCapacity < 0 || concurrencyLevel <= 0 || listener == null) {
            throw new IllegalArgumentException();
        }
        this.data = new ConcurrentHashMap<K, Node<K, V>>(maximumCapacity, 0.75f, concurrencyLevel);
        this.capacity = new AtomicInteger(maximumCapacity);
        this.length = new AtomicInteger();
        this.head = Node.newSentinel();
        this.tail = Node.newSentinel();
        this.listener = listener;
        this.policy = policy;
        this.head.setPrev(this.head);
        this.head.setNext(this.tail);
        this.tail.setPrev(this.head);
        this.tail.setNext(this.tail);
    }

    private boolean isOverflow() {
        return this.length.get() > this.capacity();
    }

    public void setCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.capacity.set(capacity);
        while (this.isOverflow()) {
            this.evict();
        }
    }

    public int capacity() {
        return this.capacity.get();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void clear() {
        for (K key : this.keySet()) {
            this.remove(key);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.data.containsValue(Node.newElement(null, value));
    }

    private void evict() {
        while (this.isOverflow()) {
            Node<K, V> node = this.poll();
            if (node == null) {
                return;
            }
            if (this.policy.onEvict(this, node)) {
                V value = node.getValue();
                if (value != null) {
                    K key = node.getKey();
                    this.data.remove(key);
                    this.listener.onEviction(key, value);
                }
                this.length.decrementAndGet();
                return;
            }
            this.offer(node);
        }
    }

    private Node<K, V> poll() {
        Node<K, V> node;
        while (!this.head.casNext(node = this.head.getNext(), node.getNext())) {
        }
        do {
            if (!node.casState(Node.State.LINKED, Node.State.UNLINKING)) continue;
            node.getNext().setPrev(this.head);
            node.setState(Node.State.UNLINKED);
            return node;
        } while (node != this.tail);
        return null;
    }

    private void offer(Node<K, V> node) {
        Node<K, V> prev;
        node.setState(Node.State.LINKING);
        node.setNext(this.tail);
        do {
            prev = this.tail.getPrev();
            node.setPrev(prev);
        } while (!prev.casNext(this.tail, node));
        Node<K, V> next = this.tail;
        while (true) {
            if (next.casPrev(prev, node)) {
                node.setState(Node.State.LINKED);
                return;
            }
            next = next.getPrev();
        }
    }

    private Node<K, V> putIfAbsent(Node<K, V> node) {
        Node<K, V> old = this.data.putIfAbsent(node.getKey(), node);
        if (old == null) {
            this.length.incrementAndGet();
            this.offer(node);
            this.evict();
        }
        return old;
    }

    @Override
    public V get(Object key) {
        Node node = (Node)this.data.get(key);
        if (node != null) {
            Object value = node.getValue();
            this.policy.onGet(this, node);
            return value;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Node<K, V> old = this.putIfAbsent(Node.newElement(key, value));
        return old == null ? null : (V)old.getAndSetValue(value);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Node<K, V> old = this.putIfAbsent(Node.newElement(key, value));
        return old == null ? null : (V)old.getValue();
    }

    @Override
    public V remove(Object key) {
        Node node = (Node)this.data.remove(key);
        if (node != null) {
            Object value = node.getValue();
            this.policy.onRemove(this, node);
            return value;
        }
        return null;
    }

    @Override
    public boolean remove(Object key, Object value) {
        Node node = (Node)this.data.get(key);
        if (node != null && node.value.equals(value) && this.data.remove(key, node)) {
            this.policy.onRemove(this, node);
            return true;
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Node node = (Node)this.data.get(key);
        return node == null ? null : (V)node.getAndSetValue(value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException();
        }
        Node node = (Node)this.data.get(key);
        return node == null ? false : node.casValue(oldValue, newValue);
    }

    @Override
    public Set<K> keySet() {
        return this.data.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySetAdapter();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        public SimpleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return SimpleEntry.eq(this.key, entry.getKey()) && SimpleEntry.eq(this.value, entry.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryIteratorAdapter
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, Node<K, V>>> iterator;
        private Map.Entry<K, V> current;
        private Map.Entry<K, V> next;

        public EntryIteratorAdapter(Iterator<Map.Entry<K, Node<K, V>>> iterator) {
            this.iterator = iterator;
            this.next = this.findNext();
        }

        private Map.Entry<K, V> findNext() {
            while (this.iterator.hasNext()) {
                Object value;
                Map.Entry entry = this.iterator.next();
                Node node = entry.getValue();
                if (node == null || (value = node.getValue()) == null) continue;
                return new SimpleEntry(node.getKey(), value);
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.next == null) {
                throw new IllegalStateException();
            }
            this.current = this.next;
            this.next = this.findNext();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            ConcurrentLinkedHashMap.this.remove(this.current.getKey(), this.current.getValue());
            this.current = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntrySetAdapter
    extends AbstractSet<Map.Entry<K, V>> {
        private final ConcurrentLinkedHashMap<K, V> map;

        private EntrySetAdapter() {
            this.map = ConcurrentLinkedHashMap.this;
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIteratorAdapter(this.map.data.entrySet().iterator());
        }

        @Override
        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Node node = (Node)this.map.data.get(entry.getKey());
            return node != null && node.value.equals(entry.getValue());
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            return this.map.putIfAbsent(entry.getKey(), entry.getValue()) == null;
        }

        @Override
        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return this.map.remove(entry.getKey(), entry.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Node<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1461281468985304519L;
        private static final AtomicReferenceFieldUpdater<Node, Object> valueUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Object.class, "value");
        private static final AtomicReferenceFieldUpdater<Node, State> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, State.class, "state");
        private static final AtomicReferenceFieldUpdater<Node, Node> prevUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "prev");
        private static final AtomicReferenceFieldUpdater<Node, Node> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "next");
        private final K key;
        private volatile V value;
        private volatile State state;
        private volatile boolean marked;
        private volatile Node<K, V> prev;
        private volatile Node<K, V> next;

        private Node(K key, V value, State state) {
            this.key = key;
            this.value = value;
            this.state = state;
        }

        public static <K, V> Node<K, V> newSentinel() {
            return new Node<Object, Object>(null, null, State.SENTINEL);
        }

        public static <K, V> Node<K, V> newElement(K key, V value) {
            return new Node<K, V>(key, value, State.UNLINKED);
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            valueUpdater.set(this, value);
        }

        public V getAndSetValue(V value) {
            return (V)valueUpdater.getAndSet(this, value);
        }

        public boolean casValue(V expect, V update) {
            return valueUpdater.compareAndSet(this, expect, update);
        }

        public Node<K, V> getPrev() {
            return this.prev;
        }

        public void setPrev(Node<K, V> node) {
            prevUpdater.set(this, node);
        }

        public boolean casPrev(Node<K, V> expect, Node<K, V> update) {
            return prevUpdater.compareAndSet(this, expect, update);
        }

        public Node<K, V> getNext() {
            return this.next;
        }

        public void setNext(Node<K, V> node) {
            nextUpdater.set(this, node);
        }

        public boolean casNext(Node<K, V> expect, Node<K, V> update) {
            return nextUpdater.compareAndSet(this, expect, update);
        }

        public boolean isMarked() {
            return this.marked;
        }

        public void setMarked(boolean marked) {
            this.marked = marked;
        }

        public State getState() {
            return this.state;
        }

        public void setState(State state) {
            stateUpdater.set(this, state);
        }

        public boolean casState(State expect, State update) {
            return stateUpdater.compareAndSet(this, expect, update);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Node)) {
                return false;
            }
            V value = this.getValue();
            Node node = (Node)obj;
            return value == null ? node.getValue() == null : value.equals(node.getValue());
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return String.format("Node[state=%s, marked=%b, key=%s, value=%s]", new Object[]{this.getState(), this.isMarked(), this.getKey(), this.getValue()});
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum State {
            SENTINEL,
            UNLINKED,
            UNLINKING,
            LINKING,
            LINKED;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EvictionPolicy {
        FIFO{

            @Override
            <K, V> void onGet(ConcurrentLinkedHashMap<K, V> map, Node<K, V> node) {
            }

            @Override
            <K, V> boolean onEvict(ConcurrentLinkedHashMap<K, V> map, Node<K, V> node) {
                return true;
            }
        }
        ,
        SECOND_CHANCE{

            @Override
            <K, V> void onGet(ConcurrentLinkedHashMap<K, V> map, Node<K, V> node) {
                node.setMarked(true);
            }

            @Override
            <K, V> void onRemove(ConcurrentLinkedHashMap<K, V> map, Node<K, V> node) {
                super.onRemove(map, node);
                node.setMarked(false);
            }

            @Override
            <K, V> boolean onEvict(ConcurrentLinkedHashMap<K, V> map, Node<K, V> node) {
                if (node.isMarked()) {
                    node.setMarked(false);
                    return false;
                }
                return true;
            }
        }
        ,
        LRU{

            @Override
            <K, V> void onGet(ConcurrentLinkedHashMap<K, V> map, Node<K, V> node) {
                Node<K, V> newNode = Node.newElement(node.getKey(), node.getValue());
                if (map.data.replace(node.getKey(), node, newNode)) {
                    map.length.incrementAndGet();
                    this.onRemove(map, node);
                    ((ConcurrentLinkedHashMap)map).offer(newNode);
                    ((ConcurrentLinkedHashMap)map).evict();
                }
            }

            @Override
            <K, V> boolean onEvict(ConcurrentLinkedHashMap<K, V> map, Node<K, V> node) {
                return true;
            }
        };


        abstract <K, V> void onGet(ConcurrentLinkedHashMap<K, V> var1, Node<K, V> var2);

        <K, V> void onRemove(ConcurrentLinkedHashMap<K, V> map, Node<K, V> node) {
            node.setValue(null);
        }

        abstract <K, V> boolean onEvict(ConcurrentLinkedHashMap<K, V> var1, Node<K, V> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EvictionListener<K, V> {
        public void onEviction(K var1, V var2);
    }
}

