/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.blocking;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.concurrent.Mutex;
import net.sf.ehcache.constructs.blocking.LockTimeoutException;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import net.sf.ehcache.constructs.blocking.UpdatingCacheEntryFactory;

public class UpdatingSelfPopulatingCache
extends SelfPopulatingCache {
    private static final Logger LOG = Logger.getLogger(UpdatingSelfPopulatingCache.class.getName());

    public UpdatingSelfPopulatingCache(Ehcache cache, UpdatingCacheEntryFactory factory) throws CacheException {
        super(cache, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element get(Object key) throws LockTimeoutException {
        try {
            Ehcache backingCache = this.getCache();
            Element element = backingCache.get(key);
            if (element == null) {
                element = super.get(key);
            } else {
                Mutex lock = this.stripedMutex.getMutexForKey(key);
                try {
                    lock.acquire();
                    this.update(key);
                }
                finally {
                    lock.release();
                }
            }
            return element;
        }
        catch (Throwable throwable) {
            this.put(new Element(key, null));
            throw new LockTimeoutException("Could not fetch object for cache entry with key \"" + key + "\".", throwable);
        }
    }

    protected void update(Object key) {
        try {
            Ehcache backingCache = this.getCache();
            Element element = backingCache.getQuiet(key);
            if (element == null) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest(this.getName() + ": entry with key " + key + " has been removed - skipping it");
                }
                return;
            }
            this.refreshElement(element, backingCache);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, this.getName() + "Could not refresh element " + key, e);
        }
    }

    public void refresh() throws CacheException {
        throw new CacheException("UpdatingSelfPopulatingCache objects should not be refreshed.");
    }
}

