/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.cache.ehcache;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.cache.CacheException;
import org.eclipse.higgins.cache.api.ICache;
import org.eclipse.higgins.cache.api.ICacheKey;

public class EHCache
implements ICache {
    private static final Log log = LogFactory.getLog(EHCache.class);
    private final Cache cache;

    public EHCache(Cache cache) {
        this.cache = cache;
    }

    public void clear() throws CacheException {
        log.debug((Object)"clear");
        this.cache.removeAll();
    }

    public Object get(ICacheKey key) throws CacheException {
        log.debug((Object)("get: key= " + key.toString()));
        if (key == null) {
            log.error((Object)"get: key is null");
            return null;
        }
        Element element = this.cache.get(key.getKey());
        if (element != null) {
            log.debug((Object)"get: successful");
            return element.getObjectValue();
        }
        log.debug((Object)"get: element is null");
        return null;
    }

    public void put(ICacheKey key, Object value) throws CacheException {
        log.debug((Object)"put");
        if (key == null) {
            log.error((Object)"put: key is null");
            throw new CacheException("Couldn't put element, key is null");
        }
        Element element = new Element((Object)key.getKey(), value);
        this.cache.put(element);
        log.debug((Object)"put: successful");
    }

    public void remove(ICacheKey key) throws CacheException {
        if (key != null) {
            this.cache.remove(key.getKey());
            log.debug((Object)"remove: successful");
        }
    }

    public void update(ICacheKey key, Object value) throws CacheException {
        this.put(key, value);
    }

    public final long calculateInMemorySize() throws IllegalStateException, net.sf.ehcache.CacheException {
        return this.cache.calculateInMemorySize();
    }

    public final long getMemoryStoreSize() throws IllegalStateException {
        return this.cache.getMemoryStoreSize();
    }

    public boolean isKeyInCache(ICacheKey key) {
        return null != this.cache.get((Serializable)key);
    }
}

