/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.cache.ehcache;

import java.util.Properties;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.cache.CacheException;
import org.eclipse.higgins.cache.api.ICache;
import org.eclipse.higgins.cache.api.ICacheProvider;
import org.eclipse.higgins.cache.ehcache.EHCache;

public class EHCacheProvider
implements ICacheProvider {
    private static final Log log = LogFactory.getLog(EHCacheProvider.class);
    private CacheManager cacheManager = null;

    public EHCacheProvider() {
        log.info((Object)("create new " + EHCacheProvider.class.getName()));
    }

    public ICache getCache(String name) {
        log.debug((Object)"getCache");
        try {
            Cache cache = this.cacheManager.getCache(name);
            if (cache == null) {
                log.debug((Object)("getCache: Cache configuration is absent for :" + name));
                this.cacheManager.addCache(name);
                cache = this.cacheManager.getCache(name);
                log.debug((Object)("getCache: Create default cache :" + name));
            }
            log.debug((Object)"getCache: Cache create sucsessful");
            return new EHCache(cache);
        }
        catch (Exception e) {
            log.error((Object)"getCache: Errors:", (Throwable)e);
            throw new CacheException(e);
        }
    }

    public void configure(Properties properties) {
        log.info((Object)"configure");
        if (this.cacheManager == null) {
            if (properties == null) {
                log.error((Object)"properties is null");
                throw new CacheException("properties is null");
            }
            if (properties.get("CacheProviderConfigurationURL") == null) {
                log.error((Object)"init: Couldn't get CacheProviderConfigurationURL property");
                throw new CacheException("Couldn't get CacheProviderConfigurationURL property");
            }
            try {
                this.cacheManager = CacheManager.create((String)properties.get("CacheProviderConfigurationURL").toString());
                log.info((Object)"CacheManager create sucsessful");
            }
            catch (Exception e) {
                log.error((Object)" Errors:", (Throwable)e);
                throw new CacheException(e);
            }
            log.info((Object)"configure successful");
        } else {
            log.debug((Object)"already was configured");
        }
    }
}

