/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Greg Byrd (IBM Corporation) 
 *    Rajalakshmi Iyer (IBM)
 *******************************************************************************/ 

package org.eclipse.higgins.configuration.common;

import java.util.Map;
import java.util.Properties;
import java.util.Enumeration;
import java.io.*;

import org.eclipse.higgins.configuration.api.IConfigurationHandler;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;

public class PropertyFileConfigurationHandler implements IConfigurationHandler {
	private java.util.Map mapGlobalSettings = null;
	
	private ISettingDescriptor _globalSettingDescriptor = null;

	private boolean bConfiguring = false;

	private boolean bConfigured = false;
	
	private final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog
		(PropertyFileConfigurationHandler.class.getName());
	
	private String strConfigurationBase;
	private String strFileName = "configuration.properties";
	
	public PropertyFileConfigurationHandler() {}
	public PropertyFileConfigurationHandler(String fileName) {
		setFileName(fileName);
	}
	public PropertyFileConfigurationHandler(String configDir, String fileName) {
		setFileName(fileName);
		setConfigurationBase(configDir);
	}
	
	public java.util.Map getSettings() throws Exception
	{
		return mapGlobalSettings;
	}

	public synchronized boolean configure(Map mapConfigurationSettings) 
				throws Exception {

		log.trace("PropertiesConfigurationHandler::configure");
		
		if (bConfigured)
		{
			log.trace("PropertiesConfigurationHandler::configure Already Configured.");
			return true;
		}

		if (bConfiguring)
		{
			log.trace("ConfigurationHandler::configure Already Configuring.");
			return true;
		}
		
		bConfiguring = true;

		log.trace("ConfigurationBase: " + strConfigurationBase);
		log.trace("ConfigurationFile: " + strFileName);

		Properties props = new Properties();
		String separator = File.separator;
		File propFile = new File(strConfigurationBase + separator + strFileName);
		if (propFile.exists()) {
		    try {
				FileInputStream fileInStream = new FileInputStream(propFile);
				InputStream inStream = new BufferedInputStream(fileInStream);
				props.load(inStream);
				inStream.close();
				
				Enumeration propNames = props.propertyNames();
				while (propNames.hasMoreElements()) {
					String name = (String) propNames.nextElement();
					String value = props.getProperty(name);
					mapGlobalSettings.put(name, value);
				}
		    } 
		    catch (IOException e) {}	   
		}
		bConfiguring = false;
		bConfigured = true;
		return true;
	}

	public void setConfigurationBase(String strBase) {
		strConfigurationBase = strBase;
	}
	
	public void setFileName(String strFile) {
		strFileName = strFile;
	}
	
	public void setGlobalSettings(Map settings) { 
		this.mapGlobalSettings = settings;
	}

	public void setGlobalSettingDescriptor(ISettingDescriptor settingDescriptor) { 
		this._globalSettingDescriptor = settingDescriptor;
	}
	
	public ISettingDescriptor getSettingDescriptor() {
		return this._globalSettingDescriptor;
	}
	
	public void applyUpdates() { 
		/* TODO: */
	}
}
