/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Greg Byrd (IBM Corporation) - initial API and implementation
 *    Rajalakshmi Iyer (IBM)
 *******************************************************************************/ 

package org.eclipse.higgins.configuration.common;

import org.eclipse.higgins.configuration.api.ISettingDescriptor;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.Iterator;

/**
 * Describes the properties of a setting used to configure a component.
 * (See IConfigurableComponent.)
 * @author gbyrd
 *
 */

// NOTE:  In this implementation, displayString, docString, and constraints are not supported.

public class SettingDescriptor implements ISettingDescriptor {
	private String _name;
	private String _type;
	private String _displayString;
	private String _docString;
	private Map _constraints;
	private Vector _subSettings;
	
	public SettingDescriptor(String name, String type)
	{
		_name = name;
		_type = type;
		_subSettings = null;		
		// NOTE:  In this implementation, displayString, docString, and constraints are not supported.
		_displayString = null;
		_docString = null;
		_constraints = null;

	}
	
	public SettingDescriptor() {
		_name = null; 
		_type = null; 
		_subSettings = null;
		// NOTE:  In this implementation, displayString, docString, and constraints are not supported.
		_displayString = null;
		_docString = null;
		_constraints = null;
	}
	
	public String getName() { return _name; }
	public String getType() { return _type; }
	
	// NOTE:  In this implementation, displayString, docString, and constraints are not supported.
	public String getDisplayString() { return _displayString; }
	public String getDocString() { return _docString; }
	public List getSubSettings() { return (List)_subSettings.clone(); }	
	public Object getConstraint(String key) { return null; }

	public void setName(String name) { _name = name; }
	public void setType(String type) { _type = type; }
	// NOTE:  In this implementation, displayString, docString, and constraints are not supported.	
	public void setDisplayString(String display) { }
	public void setDocString(String doc) { }	
	public void addConstraint(String name, Object value) { }
	public void removeConstraint(String name) { }

	public ISettingDescriptor getSubSetting(String settingName) { 
		if ( _subSettings == null || settingName == null ) {
			return null;
		}
		Iterator itr = _subSettings.iterator();
		while ( itr.hasNext() ) { 
			ISettingDescriptor settingDescriptor = (ISettingDescriptor)itr.next();
			if ( settingName.equals(settingDescriptor.getName()) ) { 
				return settingDescriptor;
			}
		}
		return null;
	}
	
	public ISettingDescriptor getSubSetting(int index) { 
		if ( _subSettings == null ) { 
			return null;
		}
		return (ISettingDescriptor)_subSettings.get(index);
	}
	
	public ISettingDescriptor addSubSetting(String name, String type) { 
		SettingDescriptor childDescriptor = new SettingDescriptor(name, type);
		this.addSubSetting(childDescriptor);
		return childDescriptor;
	}
	
	public void addSubSetting(ISettingDescriptor sub) {
		if ( _subSettings == null ) { 
			_subSettings = new Vector();
		}
		_subSettings.add(sub);
	}
	public void addSubSetting(int index, ISettingDescriptor sub) {
		if ( _subSettings == null ) { 
			_subSettings = new Vector();
		}
		_subSettings.add(index, sub);	
	}
	public boolean removeSubSetting(ISettingDescriptor sub) {
		if ( _subSettings == null ||
			 _subSettings.contains(sub) == false ) {
			return false;
		}
		return _subSettings.remove(sub);
	}
	public ISettingDescriptor removeSubSetting(int index) {
		if ( _subSettings == null || 
			 index > _subSettings.size() ) {
			return null;
		}
		return (ISettingDescriptor)_subSettings.remove(index);
	}
	
	// IGNORE constraint types -- may be used later.
	/**
	 * For integer/float settings, minimum allowable value.
	 */
	static final public String CONSTRAINT_MIN_VALUE_STRING = "minValue";
	/**
	 * For integer/float settings, maximum allowable value.
	 */
	static final public String CONSTRAINT_MAX_VALUE_STRING = "maxValue";
	/**
	 * For any setting, default value.
	 */
	static final public String CONSTRAINT_DEFAULT_VALUE_STRING = "defaultValue";
	/**
	 * For string-like settings, minimum width (characters).
	 */
	static final public String CONSTRAINT_MIN_WIDTH_STRING = "minWidth";
	/**
	 * For string-like settings, maximum width (characters).
	 */
	static final public String CONSTRAINT_MAX_WIDTH_STRING = "maxWidth";
	/**
	 * For any setting, set true if setting is required.
	 */
	static final public String CONSTRAINT_REQUIRED_STRING = "required";
	/**
	 * For list/map settings, minimum number of subsettings.
	 */
	static final public String CONSTRAINT_MIN_ELEMENTS_STRING = "minElements";
	/**
	 * For list/map settings, maximum number of subsettings.
	 */
	static final public String CONSTRAINT_MAX_ELEMENTS_STRING = "maxElements";
	/**
	 * For list/map settings, type of subsettings (if not explicitly listed).
	 */
	static final public String CONSTRAINT_ELEMENT_TYPE_STRING = "elementType";
	/**
	 * For object settings, set true if IConfigurableComponent.
	 */
	static final public String CONSTRAINT_CONFIGURABLE_STRING = "configurable";
	/**
	 * For component settings, set true if should be created as a singleton.
	 */
	static final public String CONSTRAINT_SINGLETON_STRING = "singleton";
	
}

