/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) 
 *    Greg Byrd (IBM)
 *    Rajalakshmi Iyer (IBM)
 *******************************************************************************/ 

package org.eclipse.higgins.configuration.xml;

import java.util.Map;
import java.util.List;
import java.util.Iterator;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.configuration.common.SettingDescriptor;
/**
 * Creates an instance of an IConfigurableComponent, using factory.
 * Gets component settings from mapSettings.  Configures component.
 * 
 * @author mikemci
 *
 */
public class ClassInstanceHandler implements ISettingHandler
{
	static private final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog
		(ClassInstanceHandler.class.getName());

	
	private Map getComponentMap(Map componentsMap, ISettingDescriptor componentsDescriptor, 
			String componentName) {
		if ( componentsDescriptor.getName().equals(componentName)) { 
			return componentsMap;
		}
		Iterator itr = componentsMap.keySet().iterator();
		while ( itr.hasNext() ) { 
			String key = itr.next().toString();
			ISettingDescriptor settingDescriptor = componentsDescriptor.getSubSetting(key);
			Object settingObject = componentsMap.get(key);
			if ( settingObject instanceof Map ) { 
				Map componentMap = getComponentMap((Map)settingObject, settingDescriptor, componentName);
				if ( componentMap != null ) {
					return componentMap;
				}
			} else if ( settingObject instanceof List ) { 
				List componentList = (List)settingObject;
				for ( int i = 0; i < componentList.size(); i++ ) {
					Object listObject = componentList.get(i);
					ISettingDescriptor listSettingDescriptor = settingDescriptor.getSubSetting(i);
					if ( listObject instanceof Map ) { 
						Map componentMap = getComponentMap((Map)listObject, listSettingDescriptor, componentName);
						if ( componentMap != null ) {
							return componentMap;
						}
					}
				}
			}
		}
		return null;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.configuration.xml.SettingHandler#getSetting(java.lang.String, java.util.Map, java.util.Map, org.w3c.dom.Element)
	 */
	public Object getSetting
		(String strName,
		String strConfigurationBase,
		Map mapSettingHandlers,
		Map mapSettingsGlobal,
		Object settingsParent,
		ISettingDescriptor globalDescriptor,
		ISettingDescriptor settingDescriptor,
		org.apache.axiom.om.OMElement omSetting)
		throws Exception
	{
		String strValue = omSetting.getText();
		log.trace("Setting Name: " + strName + " Value: " + strValue);
		
		org.eclipse.higgins.configuration.api.IConfigurableComponent component = org.eclipse.higgins.configuration.common.ConfigurableComponentFactoryHelper.getInstanceFromClassName
			(strValue);
		
//		 We used to get component settings from "ComponentSettings"
		// at the root level of the global map:
		// Map mapComponentSettings = (Map)mapSettingsGlobal.get("ComponentSettings");
		//
		// Now we get it from "ComponentSettings" in the parent map.
		// Must verify that the parent is a map, first.  If it isn't, we'll
		// fall back on the original method (global "ComponentSettings").
		
		boolean isMap = false;
		Map mapComponentSettings = null;
		Class interfaces[] = settingsParent.getClass().getInterfaces();
		for (int j=0; j<interfaces.length; j++) {
			if (interfaces[j] == Class.forName("java.util.Map")) {
				isMap = true; 
				break;  // no need to look further
			}
		}		
		if (isMap) {
			mapComponentSettings = (Map)((Map)settingsParent).get("ComponentSettings");
		}
		else {
			mapComponentSettings = (Map)mapSettingsGlobal.get("ComponentSettings");
		}
		
		ISettingDescriptor componentsDescriptor = globalDescriptor.getSubSetting("ComponentSettings");
		
		/* Recursive lookup */
		Map mapComponentSetting = this.getComponentMap(mapComponentSettings, componentsDescriptor, strName);
		
		if ( settingDescriptor == null ) { 
			settingDescriptor = new SettingDescriptor(strName, "htf:classinstance");
		}
		component.configure(mapSettingsGlobal, strName, mapComponentSetting, componentsDescriptor, globalDescriptor);

		return component;

	}
}
