/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial generation from WSDL using WSDL2Java
 *    Greg Byrd (IBM)
 *    Rajalakshmi Iyer (IBM)
 *******************************************************************************/ 

package org.eclipse.higgins.configuration.xml;

import org.eclipse.higgins.configuration.api.IConfigurationHandler;
import org.eclipse.higgins.configuration.api.IExtensionHelper;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.configuration.common.ConfigurableComponentFactoryHelper;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMNamespace;

import java.io.FileOutputStream;
import javax.xml.stream.XMLOutputFactory;

import javax.xml.stream.XMLStreamWriter;

import java.util.Map;
import java.util.List;
import java.util.Iterator;

/**
 * @author mikemci at us dot ibm dot com
 */
// TODO: Find out when ConfigurationHandler instances are instantiated (singleton? instance per request? other?)

public class ConfigurationHandler implements IConfigurationHandler
{
	private java.util.Map mapGlobalSettings = null;
	
	private ISettingDescriptor _globalSettingDescriptor = null;
	
	private OMElement _omSettingHandlers = null;

	private boolean bConfiguring = false;

	private boolean bConfigured = false;
	
	static private final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog
		(ConfigurationHandler.class.getName());
	
	private String strConfigurationBase;
	private String strFileName = "Configuration.xml";
	
	public java.util.Map getSettings() throws Exception
	{
		return mapGlobalSettings;
	}
	
	public ISettingDescriptor getSettingDescriptor() throws Exception { 
		return _globalSettingDescriptor;
	}
	
	public void setConfigurationBase(String strBase) {
		strConfigurationBase = strBase;
	}
	
	public void setFileName(String strFile) {
		strFileName = strFile;
	}
	
	private OMElement addSetting(OMElement parent, String settingName, String settingType) { 
		OMFactory factory = OMAbstractFactory.getOMFactory();
		OMElement child = factory.createOMElement("Setting", null);
		child.addAttribute("Name", settingName, null);
		child.addAttribute("Type", settingType, null);
		parent.addChild(child);
		return child;
	}
	
	private OMElement addSetting(OMElement parent, ISettingDescriptor settingDescriptor, Object settingValue ) { 
		String settingType = settingDescriptor.getType();
		String settingName = settingDescriptor.getName();
		
		OMElement child = this.addSetting(parent, settingName, settingType);

		if ( settingType.equalsIgnoreCase("htf:map")) { 
			Map settingMap = (Map)settingValue;
			Iterator itr = settingMap.keySet().iterator();
			while ( itr.hasNext() ) {
				String subSettingName = itr.next().toString();
				this.addSetting(child, settingDescriptor.getSubSetting(subSettingName),
						settingMap.get(subSettingName));
			}
		} else if ( settingType.equalsIgnoreCase("htf:list")) {
			List settingList = (List)settingValue;
			for ( int i = 0; i < settingList.size(); i++ ) {
				this.addSetting(child, settingDescriptor.getSubSetting(i),
						settingList.get(i));
			}
		} else if ( settingType.equalsIgnoreCase("htf:classinstance") || 
					settingType.equalsIgnoreCase("htf:classsingleton") || 
					settingType.equalsIgnoreCase("htf:instance") || 
					settingType.equalsIgnoreCase("htf:singleton")) { 
			child.setText(settingValue.getClass().getName());
		} else if ( settingType.equalsIgnoreCase("xsd:string")) { 
			child.setText(settingValue.toString());
		} else if ( settingType.equalsIgnoreCase("htf:jscriptexec")) { 
			OMFactory factory = OMAbstractFactory.getOMFactory();
			factory.createOMText(child, settingValue.toString(),
									org.apache.axiom.om.OMNode.CDATA_SECTION_NODE);
		}
		return child;
	}
	
	
	public void applyUpdates() throws Exception {
		OMFactory factory = OMAbstractFactory.getOMFactory();
		OMNamespace htfNamespace = factory.createOMNamespace("http://higgins.eclipse.org/sts/Configuration", "htf" );
		OMNamespace xsdNamespace = factory.createOMNamespace("http://www.w3.org/2001/XMLSchema", "xsd");
		
		OMElement omConfig = factory.createOMElement("Configuration", null);
		omConfig.declareNamespace(htfNamespace);
		omConfig.declareNamespace(xsdNamespace);
		omConfig.addAttribute("xsd:schemaLocation", "http://higgins.eclipse.org/sts/Configuration Configuration.xsd", null);
		
		omConfig.addChild(_omSettingHandlers);
		
		OMElement omDeployConfig = this.addSetting(omConfig, "DeploymentConfiguration", "htf:map");

		/* First flush component settings. Note: Order is important. */
		this.addSetting(omDeployConfig,  
				_globalSettingDescriptor.getSubSetting("ComponentSettings"),
				mapGlobalSettings.get("ComponentSettings")); 
		
		/* Flush other settings in the global map */
		Iterator itr = mapGlobalSettings.keySet().iterator();
		while ( itr.hasNext() ) { 
			String settingName = itr.next().toString();
			if ( settingName.equalsIgnoreCase("ComponentSettings") == false ) { 
				this.addSetting(omDeployConfig, _globalSettingDescriptor.getSubSetting(settingName), 
						mapGlobalSettings.get(settingName));
			}
		}
		
		omToFile(strConfigurationBase + "/" + strFileName, omConfig);
	}
	 
	public static org.apache.axiom.om.OMElement toOM
		(String strElement)
		throws Exception
	{
	    java.io.ByteArrayInputStream inputStream = new java.io.ByteArrayInputStream
			(strElement.getBytes());
	    javax.xml.stream.XMLInputFactory xif = javax.xml.stream.XMLInputFactory.newInstance();
	    xif.setProperty(javax.xml.stream.XMLInputFactory.IS_COALESCING, new Boolean(true));
	    javax.xml.stream.XMLStreamReader reader = xif.createXMLStreamReader
	    	(inputStream);
	    org.apache.axiom.om.impl.builder.StAXOMBuilder builder = new org.apache.axiom.om.impl.builder.StAXOMBuilder
	    	(reader);
	    return builder.getDocumentElement();
	}

	public static org.apache.axiom.om.OMElement omFromFile
		(String strFileName)
		throws java.io.FileNotFoundException,
			Exception
	{
	    java.io.FileInputStream inputStream = null;
	    try
	    {
	    	inputStream = new java.io.FileInputStream
	    		(strFileName);
	    }
	    catch (java.io.FileNotFoundException fnfe)
	    { 
			log.error(fnfe); 
			throw fnfe;
	    }
	    return omFromStream(inputStream);
	}
	
	public static void omToFile(String strFileName, OMElement omElement) 
		throws Exception {
		FileOutputStream outputStream = null;
		outputStream = new FileOutputStream(strFileName);
		omToStream(outputStream, omElement); 
	}
	
	public static void omToStream(FileOutputStream outputStream, 
			OMElement omElement) throws Exception { 
		XMLOutputFactory xof = XMLOutputFactory.newInstance();
		XMLStreamWriter writer = xof.createXMLStreamWriter(outputStream);
		omElement.serialize(writer);
	}

	public static org.apache.axiom.om.OMElement omFromStream
		(java.io.InputStream inputStream)
		throws java.io.FileNotFoundException,
			Exception
	{
	    javax.xml.stream.XMLInputFactory xif = javax.xml.stream.XMLInputFactory.newInstance();
	    xif.setProperty(javax.xml.stream.XMLInputFactory.IS_COALESCING, new Boolean(true));
	    javax.xml.stream.XMLStreamReader reader = xif.createXMLStreamReader
	    	(inputStream);
	    org.apache.axiom.om.impl.builder.StAXOMBuilder builder = new org.apache.axiom.om.impl.builder.StAXOMBuilder
	    	(reader);
	    return builder.getDocumentElement();
	}
	
	/**
	 * Constructor that initializes the class
	 */
	public ConfigurationHandler()
	{
		log.trace("ConfigurationHandler::ConfigurationHandler");
	}
	
	private java.util.Iterator getConfigurationElementIterator
		(org.apache.axiom.om.OMElement omParent,
		String strElementName) throws Exception
	{
		log.trace("ConfigurationHandler::getConfigurationElementIterator: " + strElementName);
		if (null == strElementName)
			throw new Exception
				("getConfigurationElementIterator ElementName is null");
		final javax.xml.namespace.QName qnameElement = new javax.xml.namespace.QName
			(null,
			strElementName);
		java.util.Iterator iterResult = omParent.getChildrenWithName
			(qnameElement);
		if (null == iterResult)
			throw new Exception
				("ConfigurationHandler::getConfigurationElementIterator ElementName " + strElementName + " Result is null");
		return iterResult;
	}

	private org.apache.axiom.om.OMElement getConfigurationElement
		(org.apache.axiom.om.OMElement omParent,
		String strElementName) throws Exception
	{
		log.trace("ConfigurationHandler::getConfigurationElement: " + strElementName);
		if (null == strElementName)
			throw new Exception
				("ConfigurationHandler::getConfigurationElement ElementName is null");
		org.apache.axiom.om.OMElement omElement = null;
		java.util.Iterator iterElement = getConfigurationElementIterator
			(omParent,
			strElementName);
		if (!iterElement.hasNext())
		{
			throw new Exception
				("ConfigurationHandler::getConfigurationElement " + strElementName + " Result is null");
		}
		omElement = (org.apache.axiom.om.OMElement)iterElement.next();
		if (iterElement.hasNext())
		{
			throw new Exception("ConfigurationHandler::getConfigurationElement " + strElementName + " found more than one element");
		}
		return omElement;
	}

	public synchronized boolean configure
		(java.util.Map mapConfigurationSettings)
		throws Exception
	{
		log.trace("ConfigurationHandler::configure");
	
		if (bConfigured)
		{
			log.trace("ConfigurationHandler::configure Already Configured.");
			return true;
		}
		
		log.trace("ConfigurationBase: " + strConfigurationBase);
		
		OMElement omConfiguration = null;
		try
		{
			omConfiguration = omFromFile
				(strConfigurationBase + "/" + strFileName);
		}
		catch (Exception e)
		{
			log.error(e.getLocalizedMessage());
			throw e;
		}
		return configure(omConfiguration, mapConfigurationSettings);
	}
	
	public synchronized boolean configure
		(String strConfiguration,
		java.util.Map mapConfigurationSettings)
		throws Exception
	{
		log.trace("ConfigurationHandler::configure");
		
		if (bConfigured)
		{
			log.trace("ConfigurationHandler::configure Already Configured.");
			return true;
		}
		
		log.trace("ConfigurationBase: " + strConfigurationBase);
		
		OMElement omConfiguration = null;
		try
		{
			omConfiguration = toOM
				(strConfiguration);
		}
		catch (Exception e)
		{
			log.error(e.getLocalizedMessage());
			throw e;
		}
		return configure(omConfiguration, mapConfigurationSettings);
	}
	
	public synchronized boolean configure
		(org.apache.axiom.om.OMElement omConfiguration,
		java.util.Map mapConfigurationSettings)
		throws Exception
	{	
		log.trace("ConfigurationHandler::configure");
		
		if (bConfigured)
		{
			log.trace("ConfigurationHandler::configure Already Configured.");
			return true;
		}

		if (bConfiguring)
		{
			log.trace("ConfigurationHandler::configure Already Configuring.");
			return true;
		}
		
		bConfiguring = true;
		
		log.trace("ConfigurationBase: " + strConfigurationBase);
	
		//constants = new org.eclipse.higgins.sts.impl.Constants();
		javax.xml.namespace.QName qnameType = new javax.xml.namespace.QName
			(null,
			"Type");
		javax.xml.namespace.QName qnameHandler = new javax.xml.namespace.QName
			(null,
			"Handler");
		java.util.Map mapSettingHandlers = new java.util.Hashtable();
		_omSettingHandlers = getConfigurationElement(omConfiguration,
			"SettingHandlers");
		if (null == _omSettingHandlers)
		{
			throw new Exception("SettingHandlers element not found in configuration file.");
		}
		java.util.Iterator iterSettingHandler = getConfigurationElementIterator
			(_omSettingHandlers,
			"SettingHandler");
		while (iterSettingHandler.hasNext())
		{
			org.apache.axiom.om.OMElement omSettingHandler = (org.apache.axiom.om.OMElement)iterSettingHandler.next();
			String strType = omSettingHandler.getAttributeValue(qnameType);
			String strHandler = omSettingHandler.getAttributeValue(qnameHandler);
			log.trace("Registering SettingHandler Type: " + strType + " Handler: " + strHandler);
			try
			{
				Class classHandler = Class.forName(strHandler);
				Object objectHandler = classHandler.newInstance();
				mapSettingHandlers.put(strType, objectHandler);
			}
			catch (Exception e)
			{	
				try
				{
					//Exclude Eclipse from required classpath elements
					Class extensionHelperClass = ConfigurableComponentFactoryHelper.getClassByName("org.eclipse.higgins.configuration.common.plugin.ExtensionHelper");
					final Object objectHandler = ((IExtensionHelper) extensionHelperClass.newInstance()).getInstanceByExtension("org.eclipse.higgins.configuration.xml.settingshandler",
							strHandler,
							"factoryclassname");
/*					org.eclipse.core.runtime.IExtensionRegistry extensionRegistry = org.eclipse.core.runtime.Platform.getExtensionRegistry();
					if (null == extensionRegistry)
					{
						log.error("Exception caught while loading SettingHandler Type: " + strType + " Handler: " + strHandler);
						log.error("Eclipse ExtensionRegistry not present");
						log.error("Java Class Error: ");
						log.error(e.getLocalizedMessage());
						throw e;
					}
					org.eclipse.core.runtime.IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint
						("org.eclipse.higgins.configuration.xml.settingshandler");
					org.eclipse.core.runtime.IExtension extension = extensionPoint.getExtension(strHandler);
					org.eclipse.core.runtime.IConfigurationElement [] configurationElements = extension.getConfigurationElements();
					org.eclipse.core.runtime.IConfigurationElement component = configurationElements[0];                                    
					Object objectHandler = component.createExecutableExtension("factoryclassname");
					*/
					mapSettingHandlers.put(strType, objectHandler);
				}
				catch (Exception e2)
				{
					log.error("Exception caught while loading SettingHandler Type: " + strType + " Handler: " + strHandler);
					log.error("Eclipse Plugin Error: ");
					log.error(e2.getLocalizedMessage());			
					log.error("Java Class Error: ");
					log.error(e.getLocalizedMessage());
					throw e;
				}
			}
		}
		org.apache.axiom.om.OMElement omSetting = getConfigurationElement
			(omConfiguration,
			"Setting");
		if (null == omSetting)
		{
			throw new Exception("Setting element not found in configuration file.");
		}
		
		org.eclipse.higgins.configuration.xml.MapHandler mapHandler = new org.eclipse.higgins.configuration.xml.MapHandler();
		mapGlobalSettings = new java.util.Hashtable();
		try
		{
			mapGlobalSettings = (java.util.Map)mapHandler.getSetting
				("Configuration",
				strConfigurationBase,
				mapSettingHandlers,
				null,
				null,
				null,
				null,
				omSetting);
			
			_globalSettingDescriptor = mapHandler.getGlobalDescriptor();
		}
		catch (Exception e)
		{
			log.error(e.getLocalizedMessage());
			throw e;
		}
		
		bConfigured = true;
		bConfiguring = false;
		
		log.trace("ConfigurationHandler::configure DONE");
		
		return true;
	}
	
	public void setGlobalSettings(java.util.Map settings) throws Exception { 
		this.mapGlobalSettings = settings;
	}
	
	public void setGlobalSettingDescriptor(ISettingDescriptor settingDescriptor) throws Exception { 
		this._globalSettingDescriptor = settingDescriptor;
	}
}