/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) 
 *    Greg Byrd (IBM)
 *    Rajalakshmi Iyer (IBM)
 *******************************************************************************/ 

package org.eclipse.higgins.configuration.xml;

import java.util.Map;

import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.configuration.common.SettingDescriptor;

/**
 * Keystore setting is a map that contains type, filename, and password.
 * Creates a keystore instance, loads the file, and returns keystore instance.
 * 
 * @author mikemci
 *
 */
public class KeyStoreHandler extends MapHandler
{
	static private final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog
		(KeyStoreHandler.class.getName());

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.configuration.xml.ISettingHandler#getSetting(java.lang.String, java.util.Map, java.util.Map, org.w3c.dom.Element)
	 */
	public Object getSetting
		(String strName,
		String strConfigurationBase,
		Map mapSettingHandlers,
		Map mapSettingsGlobal,
		Object settingsParent,
		ISettingDescriptor globalDescriptor,
		ISettingDescriptor settingDescriptor,
		org.apache.axiom.om.OMElement omSetting)
		throws Exception
	{	
		log.trace("Setting Name: " + strName + " *Begin KeyStore*");
		
		if ( settingDescriptor == null ) { 
			settingDescriptor = new SettingDescriptor(strName, "htf:keystore");
		}
		
		Map mapPrivateKeySettings = (Map)super.getSetting
			(strName, 
			strConfigurationBase, 
			mapSettingHandlers, 
			mapSettingsGlobal, 
			settingsParent,
			globalDescriptor,
			settingDescriptor,
			omSetting);
		
		String strType = (String)mapPrivateKeySettings.get
			("Type");
		java.io.FileInputStream fisFile = (java.io.FileInputStream)mapPrivateKeySettings.get
			("File");
		String strPassword = (String)mapPrivateKeySettings.get
			("Password");
		if (null == strType)
		{
			log.trace("Type: null");
		}
		else
		{
			log.trace("Type: " + strType);
		}
		java.security.KeyStore keyStore = java.security.KeyStore.getInstance
			(strType);
		keyStore.load
			(fisFile,
			strPassword.toCharArray());
		log.trace("Setting Name: " + strName + " *End KeyStore*");
		return keyStore;
	}
}
