/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) 
 *******************************************************************************/ 

package org.eclipse.higgins.configuration.xml;

import java.util.Map;


/**
 * Returns file stream that corresponds to named file 
 * (relative to strConfigurationBase).
 * 
 * @author mikemci
 *
 */
public class FileHandler implements ISettingHandler
{
	static private final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog
		(FileHandler.class.getName());

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.configuration.xml.ISettingHandler#getSetting(java.lang.String, java.util.Map, java.util.Map, org.w3c.dom.Element)
	 */
	public Object getSetting
		(String strName,
		String strConfigurationBase,
		Map mapSettingHandlers,
		Map mapSettingsGlobal,
		Object settingsParent,
		org.apache.axiom.om.OMElement omSetting)
		throws Exception
	{	
		String strFileName = omSetting.getText();
		if (null == strFileName)
		{
			log.trace("File: null");
		}
		else
		{
			log.trace("File: " + strFileName);
		}
		java.io.FileInputStream fis = new java.io.FileInputStream
			(strConfigurationBase + "/" + strFileName);
		return fis;
	}
}
