/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial definition
 *    Greg Byrd (IBM Corporation) -- added documentation, moved to .xml package
 *******************************************************************************/ 

package org.eclipse.higgins.configuration.xml;


/**
 * @author mikemci
 */
public interface ISettingHandler
{
	/**
	 * Method to convert XML element (omSetting) to an object 
	 * that will be placed into a configuration map.  The type 
	 * of the returned object is implicitly determined by the 
	 * class implementing the ISettingHandler interface.
	 * 
	 * @param strName Name of setting being processed.
	 * @param strConfigurationBase Configuration directory (used for file-oriented settings).
	 * @param mapSettingHandlers Map that associates types with ISettingHandler classes.
	 * @param mapSettingsGlobal Configuration map containing top-level settings that might be needed for this setting.
	 * (E.g., a certificate handler might need information about a previously-configured keystore component.)
	 * @param settingsParent Configuration map or list (if any) that will contain this setting.
	 * @param omSetting XML element that is being converted to Object.
	 * @return Object that will be put into a configuration Map, associated with given name.
	 * @throws Exception 
	 */
	public abstract Object getSetting
		(String strName,
		String strConfigurationBase,
		java.util.Map mapSettingHandlers,
		java.util.Map mapSettingsGlobal,
		Object settingsParent,
		org.apache.axiom.om.OMElement omSetting)
		throws Exception;
}
