/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Anthony Bussani (IBM Research) - initial API and implementation
 *    Michael McIntosh (IBM Corporation)
 *******************************************************************************/

package org.eclipse.higgins.crpps.ui.dialogs;

import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.crpps.util.UUIDHelper;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.provider.cardspace.common.io.RoamingStoreElementFormat;
import org.eclipse.higgins.icard.provider.securestorage.CardStorePersonalCard;
import org.eclipse.higgins.sts.utilities.XMLHelper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * @author bus at zurich dot ibm dot com
 *
 */
public class PersonalCardCreationDialog extends Dialog {

    private Log log = LogFactory.getLog(PersonalCardCreationDialog.class);

    // this should be replaced by data coming from the preferences window
    String[][] claims = {
	    { "First Name",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname" },
	    { "Last Name",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname" },
	    { "Street",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/streetaddress" },
	    { "Locality (City)",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/locality" },
	    { "State or Province",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/stateorprovince" },
	    { "Postal Code",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/postalcode" },
	    { "Country/Region",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/country" },
	    { "Phone Number",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/homephone" },
	    { "Other Phone",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/otherphone" },
	    { "Mobile Phone",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/mobilephone" },
	    { "Date of Birth",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/dateofbirth" },
	    { "Gender",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/gender" },
	    { "Web Page",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/webpage" },
	    { "Email",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress" } };

    private String exportedCardName;

    private Text cardNameText;

    private String imageFilename = null;

    Table internalData;

    TableViewer tableViewer;

    CardStorePersonalCard personalCard = null;

    private Composite imageComp;

    private Text name;
    
    final Point imageSize = new Point(100, 60);

    public static byte[] personalCardImage = null;

    public PersonalCardCreationDialog(Shell parentShell,
	    CardStorePersonalCard personalCard) {
	super(parentShell);
	this.personalCard = personalCard;
	if (personalCard != null) {
	    personalCardImage = personalCard.getImage();
	} else if (personalCardImage == null) {
	    InputStream personalCardImageIns = PersonalCardCreationDialog.class
		    .getResourceAsStream("personalCard.jpg");
	    int length;
	    try {
		length = personalCardImageIns.available();
		personalCardImage = new byte[length];
		personalCardImageIns.read(personalCardImage);
	    } catch (IOException e) {
		log.error("Error when loading default personbal image", e);
	    }
	}
    }

    protected void setShellStyle(int newShellStyle) {
	// super.setShellStyle(newShellStyle);
	super.setShellStyle(SWT.APPLICATION_MODAL|SWT.BORDER|SWT.RESIZE | SWT.CLOSE | SWT.TITLE);
    }

    /**
     * @param Number
     * @param value
     */
    void addProperties(Table table, String name, String value, Color color) {
	String sz[] = { name, value };
	TableItem tableItem;
	tableItem = new TableItem(table, SWT.NONE);
	if (color != null)
	    tableItem.setForeground(color);
	tableItem.setText(sz);
	// Create the cell editors

    }

    private void chooseImage() {
	FileDialog fileDialog = new FileDialog(super.getParentShell(), SWT.OPEN
		| SWT.SINGLE);
	fileDialog.setFilterExtensions(new String[] { "*.bmp", "*.gif",
		"*.jpg", "*.jpeg", "*.png", "*.tif", "*.tiff", "*.*" });
	String ret = fileDialog.open();
	if (ret != null) {
	    try {
		InputStream personalCardImageIns = new java.io.FileInputStream(
			ret);
		int length;
		length = personalCardImageIns.available();
		byte dataImage[] = new byte[length];
		personalCardImageIns.read(dataImage);
		updateImage(dataImage, ret);
	    } catch (IOException e) {
		MessageBox messageBox = new MessageBox(super.getParentShell(),
			SWT.ERROR_IO);
		messageBox.setMessage("Error when reading file:" + ret);
		messageBox.setText("Error while reading image");
		messageBox.open();
		return;
	    } catch (SWTException e) {
		MessageBox messageBox = new MessageBox(super.getParentShell(),
			SWT.ERROR_IO);
		messageBox.setMessage("Image format not supported for:" + ret);
		messageBox.setText("Error while reading image");
		messageBox.open();
		return;
	    }
	    imageFilename = ret;
	}
    }

    void createTable(Table table) {
	// REQUIRED DATA TABLES
	TableColumn tc1;

	tc1 = new TableColumn(table, SWT.NONE);
	tc1.setText("Property");
	tc1.setWidth(200);
	tc1 = new TableColumn(table, SWT.NONE);
	tc1.setText("Value");
	tc1.setWidth(350);
	table.setHeaderVisible(true);

	final Table tableP = table;
	final TableEditor editor = new TableEditor(table);
	// The editor must have the same size as the cell and must
	// not be any smaller than 50 pixels.
	editor.horizontalAlignment = SWT.LEFT;
	editor.grabHorizontal = true;
	editor.minimumWidth = 50;
	// editing the second column
	final int EDITABLECOLUMN = 1;

	table.addSelectionListener(new SelectionAdapter() {
	    Table table;

	    public void SelectionAdapter(Table tableP) {
		table = tableP;
	    }

	    public void widgetSelected(SelectionEvent e) {
		// Clean up any previous editor control
		Control oldEditor = editor.getEditor();
		if (oldEditor != null)
		    oldEditor.dispose();

		// Identify the selected row
		TableItem item = (TableItem) e.item;
		if (item == null)
		    return;

		// The control that will be the editor must be a child of the
		// Table
		Text newEditor = new Text(tableP, SWT.NONE);
		newEditor.setText(item.getText(EDITABLECOLUMN));
		newEditor.addModifyListener(new ModifyListener() {
		    public void modifyText(ModifyEvent me) {
			Text text = (Text) editor.getEditor();
			editor.getItem()
				.setText(EDITABLECOLUMN, text.getText());
		    }
		});
		newEditor.selectAll();
		newEditor.setFocus();
		editor.setEditor(newEditor, item, EDITABLECOLUMN);
	    }
	});
    }

    protected void updateImage(byte data[], String toolTipText)
	    throws SWTException {
	ByteArrayInputStream bis = new ByteArrayInputStream(data);
	Image image = new Image(Display.getCurrent(), bis);
	ImageData imd = image.getImageData().scaledTo(imageSize.x, imageSize.y);
	Image newimg = new Image(Display.getCurrent(), imd);
	imageComp.setBackgroundImage(newimg);
	imageComp.setToolTipText(toolTipText);
	imageComp.redraw();
	image.dispose();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
     */
    protected Control createDialogArea(Composite arg0) {
	Composite parent = (Composite) super.createDialogArea(arg0);
	Composite mainParent = new Composite(parent, SWT.BORDER);
	FormLayout formLayout = new FormLayout();
	formLayout.marginBottom = 10;
	formLayout.marginTop = 10;
	formLayout.marginLeft = 10;
	formLayout.marginRight = 10;
	mainParent.setLayout(formLayout);

	Label label_ = new Label(mainParent, SWT.NONE);
	label_.setText("Personalize this card");
	Font font = new Font(Display.getCurrent(),"Ariel", 8, SWT.BOLD);
	label_.setFont(font);
	FormData fd = new FormData();
	fd.top = new FormAttachment(0, 0);
	fd.left = new FormAttachment(0, 5);
	label_.setLayoutData(fd);

	// Separator
	Label label = new Label(mainParent, SWT.SEPARATOR | SWT.HORIZONTAL);
	fd = new FormData();
	fd.top = new FormAttachment(label_, 5);
	fd.left = new FormAttachment(0,0);
	fd.width = 600;
	label.setLayoutData(fd);

	imageComp = new Composite(mainParent, SWT.BORDER);
	updateImage(personalCardImage, personalCard == null ? "default"
		: "defined in card");
	fd = new FormData();
	fd.top = new FormAttachment(label, 10);
	fd.left = new FormAttachment(0, 5);
	fd.width = imageSize.x;
	fd.height = imageSize.y;
	imageComp.setLayoutData(fd);

	Button imageButton = new Button(mainParent, SWT.NONE);
	imageButton.setText("Choose a picture");
	imageButton.setEnabled(true);
	imageButton.addSelectionListener(new SelectionAdapter() {
	    public void widgetSelected(SelectionEvent e) {
		log.info("choose image");
		chooseImage();
	    }
	});
	fd = new FormData();
	fd.top = new FormAttachment(label, 25);
	fd.left = new FormAttachment(imageComp, 5);
	imageButton.setLayoutData(fd);

	// Separator
	Label sep = new Label(mainParent, SWT.SEPARATOR | SWT.HORIZONTAL);
	fd = new FormData();
	fd.top = new FormAttachment(imageComp, 5);
	fd.left = new FormAttachment(0,0);
	fd.width = 600;
	sep.setLayoutData(fd);

	// REQUIRED DATA
	// CardStore location
	Label labelName = new Label(mainParent, SWT.NONE);
	fd = new FormData();
	fd.top = new FormAttachment(sep, 15);
	fd.left = new FormAttachment(0, 5);
	labelName.setLayoutData(fd);
	labelName.setText("Card Name");

	String value = "Name";
	if (personalCard != null) {
	    value = personalCard.getName();
	}
	name = new Text(mainParent, SWT.BORDER);
	name.setText(value);
	fd = new FormData();
	fd.top = new FormAttachment(sep, 10);
	fd.left = new FormAttachment(labelName, 15);
	fd.width = 300;
	name.setLayoutData(fd);

	// Separator
	Label sep1 = new Label(mainParent, SWT.SEPARATOR | SWT.HORIZONTAL);
	fd = new FormData();
	fd.top = new FormAttachment(labelName, 15);
	fd.left = new FormAttachment(0,0);
	fd.width = 600;
	sep1.setLayoutData(fd);


	// INTERNAL DATA
	internalData = new Table(mainParent, SWT.BORDER | SWT.FULL_SELECTION);
	internalData.setLinesVisible(true);
	fd = new FormData();
	fd.top = new FormAttachment(sep1, 10);
	fd.left = new FormAttachment(0, 5);
	fd.width = 560;
	internalData.setLayoutData(fd);

	createTable(internalData);
	for (int i = 0; i < claims.length; i++) {
	    value = "";
	    if (this.personalCard != null) {
		try {
		    Iterator iter = this.personalCard.getClaims();
		    while (iter.hasNext()) {
			ClaimValue claimValue = (ClaimValue) iter.next();
			if (claims[i][1].equals(claimValue.getType().getType())) {
			    value = claimValue.getValue();
			}
		    }
		} catch (CardException e) {
		    log.error("Error when retrieving claims", e);
		}

	    }
	    addProperties(internalData, claims[i][0], value, null);
	}
	return super.createDialogArea(arg0);
    }

    protected void okPressed() {
	try {
	    updatePersonalCard();
	} catch (Exception e) {
	    e.printStackTrace();
	}
	super.okPressed();
    }

    private void updatePersonalCard() throws IOException, Exception {
	boolean newCard = false;
	if (personalCard == null) {
	    personalCard = new CardStorePersonalCard();
	    newCard = true;
	}

	// generate the random URN
	// example: urn:uuid:084b3ad6-9443-4ec2-be62
	if (newCard)
	    personalCard.setIId(new URI("urn:uuid:" + UUIDHelper.randomUUID()));

	if (newCard)
	    personalCard.setVersion("1");

	personalCard.setName( name.getText());

	// TODO use the selected file in the GUI
	if (imageFilename != null) {
	    InputStream personalCardImageIns = new java.io.FileInputStream(
		    imageFilename);
	    int length;
	    length = personalCardImageIns.available();
	    personalCardImage = new byte[length];
	    personalCardImageIns.read(personalCardImage);
	}

	log.info("image size: " + personalCardImage.length);
	personalCard.setImage(personalCardImage, "image/jpeg");

	// Time issued
	if (newCard)
	    personalCard.setTimeIssued(new Date());

	// Time Expired; 1000 Year ...
	if (newCard) {
	    Calendar rightNow = Calendar.getInstance();
	    rightNow.add(Calendar.YEAR, 1000);
	    Date inSomeyear = rightNow.getTime();
	    personalCard.setTimeExpires(inSomeyear);
	}
	// supported Token Type list
	ArrayList supportedTokenTypes = new ArrayList();
	supportedTokenTypes.add(URI
		.create("urn:oasis:names:tc:SAML:1.0:assertion"));
	supportedTokenTypes
		.add(URI
			.create("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1"));
	personalCard.setSupportedTokenTypeList(supportedTokenTypes);

	// claim types
	ArrayList claimTypes = new ArrayList();
	for (int i = 0; i < claims.length; i++) {
	    String displayTag = claims[i][0];
	    String uri = claims[i][1];
	    String description = claims[i][0];
	    log.info("Set Claims type [" + displayTag + "]");
	    claimTypes.add(new ClaimType(uri, displayTag, description));
	}
	personalCard.setClaimsTypeList(claimTypes);

	// claim List
	TableItem[] tableItems = internalData.getItems();
	List claimList = new ArrayList();
	List claimsT = new ArrayList();
	for (int i = 0; i < tableItems.length; i++) {
	    log.info("Set Claims Value" + tableItems[i].getText(0) + ":"
		    + tableItems[i].getText(1));
	    ISimpleClaimType simpleClaimType = new ClaimType(claims[i][1],
		    claims[i][0], claims[i][1]);
	    claimsT.add(simpleClaimType);
	    ClaimValue claim = null;
	    if (!tableItems[i].getText(1).equals(""))
		claim = new ClaimValue(simpleClaimType, tableItems[i]
			.getText(1), personalCard);
	    else
		claim = new ClaimValue(simpleClaimType, (String) null,
			personalCard);
	    if (claim != null)
		claimList.add(claim);
	    // }
	}
	personalCard.setClaimList(claimList);

	if (log.isDebugEnabled()) {
//	    DocumentBuilderFactory factory = DocumentBuilderFactory
//		    .newInstance();
//	    DocumentBuilder documentBuilder = factory.newDocumentBuilder();
//	    Document doc = documentBuilder.newDocument();
//	    Element domCard = personalCard.toElement(doc);
//	    String xml = XMLHelper.toString(domCard);
//	    log.trace("Created personal card:\n" + xml);

	    IElement e = personalCard.toElement(RoamingStoreElementFormat.getInstance());
	    log.trace("Created personal card:\n" + e.getAs(String.class));
	    
//	    FileWriter fileWriter = new FileWriter("/tmp/todel.xml");
//	    fileWriter.write(xml);
//	    fileWriter.close();
	}
    }

    protected void configureShell(Shell arg0) {
	super.configureShell(arg0);
	arg0.setText("Create a personalize card");
	// arg0.setSize(400, 700);
    }

    public ICard getPersonalCard() {
	return this.personalCard;
    }

}
