/*******************************************************************************
 * Copyright (c) 20062007 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Anthony Bussani (IBM Research) - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.crpps.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SaveProperties {

	protected static final Log log = LogFactory.getLog(SaveProperties.class);

	File file = null;

	Field[] fields = null;

	Object object = null;

	String prefix;

	private boolean isAccessible(Field field) {
		boolean ret = (field.getName().startsWith(prefix) && !Modifier
				.isPrivate(field.getModifiers()));
		ret &= (field.getType() == String.class
				|| field.getType() == boolean.class
				|| field.getType() == String[].class
				|| field.getType() == ArrayList.class || field.getType() == int.class);
		if (log.isTraceEnabled()) {
			String banner = "";
			if (ret) banner = "***";
			if (ret)log.trace(banner + "field[" + field.getName() + "] accessible? " + ret);
		}
		return ret;
	}

	public SaveProperties(Object object, String prefix, File file)
			throws IOException, IllegalArgumentException,
			IllegalAccessException {
		this.object = object;
		this.prefix = prefix;
		Properties properties = new Properties();
		Class clazz = object.getClass();
		fields = clazz.getDeclaredFields();
		this.file = file;
		if (file.canRead()) {
			InputStream inStream = new java.io.FileInputStream(file);
			properties.load(inStream);
			for (int i = 0; i < fields.length; i++) {
				if (!isAccessible(fields[i]))
					continue;
				String fieldName = fields[i].getName();
				log.trace("fieldname=" + fieldName);
				if (properties.containsKey(fieldName)) {
					if (fields[i].getType() == String.class) {
						fields[i].set(object, properties.get(fieldName));
					} else if (fields[i].getType() == boolean.class) {
						fields[i].setBoolean(object, properties.get(fieldName)
								.equals("true"));
					} else if (fields[i].getType() == int.class) {
						try {
							int value = Integer.valueOf(
									properties.get(fieldName).toString())
									.intValue();
							fields[i].setInt(object, value);
						} catch (Exception e) {
							log.error("Can not convert back Integer. field:"
									+ fields[i], e);
						}
					}
				} else if (properties.containsKey(fieldName + ".0")) {
					if (fields[i].getType() == String[].class) {
						int index = 0;
						ArrayList arrayList = new ArrayList();
						String value = null;
						do {
							value = (String) properties.get(fieldName + "."
									+ index);
							if (value != null) {
								arrayList.add(value);
								log.trace("Detected table value[" + fieldName
										+ "." + index + "] = [" + value + "]");
							}
							index++;
						} while (value != null);
						String[] strings = (String[]) arrayList
								.toArray(new String[0]);
						fields[i].set(object, strings);
					} else if (fields[i].getType() == ArrayList.class) {
						int index = 0;
						ArrayList arrayList = new ArrayList();
						String value = null;
						do {
							value = (String) properties.get(fieldName + "."
									+ index);
							if (value != null) {
								arrayList.add(index, value);
								log.trace("Detected ArrayList value["
										+ fieldName + "." + index + "] = ["
										+ value + "]");
							}
							index++;
						} while (value != null);
						fields[i].set(object, arrayList);
					}

				}
			}
		}
	}

	public void save(String comments) throws Exception {
		Properties properties = new Properties();
		for (int i = 0; i < fields.length; i++) {
			if (!isAccessible(fields[i]))
				continue;
			String fieldName = fields[i].getName();
			log
					.trace("fieldname=" + fieldName + " type="
							+ fields[i].getType());
			if (fields[i].get(object) == null) continue;
			if (fields[i].getType() == String.class) {
				properties.put(fields[i].getName(), fields[i].get(object));
			} else if (fields[i].getType() == boolean.class) {
				properties.put(fields[i].getName(), fields[i]
						.getBoolean(object) ? "true" : "false");
			} else if (fields[i].getType() == int.class) {
				properties.put(fields[i].getName(), ""
						+ fields[i].getInt(object));
			} else if (fields[i].getType() == String[].class) {
				String[] values = (String[]) fields[i].get(object);
				for (int index = 0; index < values.length; index++) {
					properties.put(fieldName + "." + index, values[index]);
				}
			} else if (fields[i].getType() == ArrayList.class) {
				ArrayList values = (ArrayList) fields[i].get(object);
				int index = 0;
				Iterator iter = values.iterator();
				while (iter.hasNext()) {
					properties.put(fieldName + "." + index, iter.next());
					index++;
				}
			}
		}
		OutputStream out = new FileOutputStream(file);
		properties.store(out, comments);
	}

}
