/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Tie Li (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.crpps.app;

import java.util.ArrayList;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.crpps.ui.CardListView;
import org.eclipse.higgins.crpps.ui.dialogs.HigginsProvidersDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

/**
 * An action bar advisor is responsible for creating, adding, and disposing of
 * the actions added to a workbench window. Each window will be populated with
 * new actions.
 */
public class ApplicationActionBarAdvisor extends ActionBarAdvisor {

    private Log log = LogFactory.getLog(ApplicationActionBarAdvisor.class);

    // Actions - important to allocate these only in makeActions, and then use
    // them
    // in the fill methods. This ensures that the actions aren't recreated
    // when fillActionBars is called with FILL_PROXY.
    private IWorkbenchAction exitAction;

    private IWorkbenchAction preferencesAction;

    private IWorkbenchAction aboutAction;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
	super(configurer);
    }

    protected void makeActions(final IWorkbenchWindow window) {
	// Creates the actions and registers them.
	// Registering is needed to ensure that key bindings work.
	// The corresponding commands keybindings are defined in the plugin.xml
	// file.
	// Registering also provides automatic disposal of the actions when
	// the window is closed.

	exitAction = ActionFactory.QUIT.create(window);
	register(exitAction);
	preferencesAction = ActionFactory.PREFERENCES.create(window);
	register(preferencesAction);
	aboutAction = ActionFactory.ABOUT.create(window);
	register(aboutAction);
    }

    Shell getShell() {
	return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

//    private Action resetSurveyDir() {
//	return new Action() {
//	    public String getText() {
//		return "Reset Survey Directory";
//	    }
//
//	    public void run() {
//		CardListView.getInstance().resetSurveyDir();
//	    }
//	};	
//    }
    
    private Action createHigginsProvidersDialog() {
	return new Action() {
	    public String getText() {
		return "Higgins Providers";
	    }

	    public void run() {
		HigginsProvidersDialog higginsProvidersDialog = new HigginsProvidersDialog(
			getShell());
		higginsProvidersDialog.open();
	    }
	};
    }

    private Action newRepository() {
	return new Action() {
	    public String getText() {
		return "&Create Store";
	    }

	    public void run() {
		CardListView.getInstance().newRepository();
	    }
	};
    }

    private Action chgRepository() {
	return new Action() {
	    public String getText() {
		return "&Change Store";
	    }

	    public void run() {
		CardListView.getInstance().changeRepository(null);
	    }
	};
    }

    private Action chgPassword() {
	return new Action() {
	    public String getText() {
		return "&Change Password";
	    }

	    public void run() {
		CardListView.getInstance().changePwdRepository();
	    }
	};
    }

    private Action createCard() {
	return new Action() {
	    public String getText() {
		return "&Create New Card";
	    }

	    public void run() {
		CardListView.getInstance().createNewCard();
	    }
	};
    }

    private Action importCard() {
	return new Action() {
	    public String getText() {
		return "&Import Card";
	    }

	    public void run() {
		CardListView.getInstance().importCard();
	    }
	};
    }

    private Action importCardStore() {
	return new Action() {
	    public String getText() {
		return "&Import CardStore";
	    }

	    public void run() {
		CardListView.getInstance().importCardStore("noname.crds");
	    }
	};
    }


    private Action chgCard() {
	return new Action() {
	    public String getText() {
		return "&Modify Card";
	    }

	    public void run() {
		CardListView.getInstance().modifyCard();
	    }
	};
    }

    private Action deleteCard() {
	return new Action() {
	    public String getText() {
		return "&Delete Card";
	    }

	    public void run() {
		CardListView.getInstance().deleteCard();
	    }
	};
    }

    private Action history(final String filename) {
	return new Action() {
	    public String getText() {
		return filename;
	    }

	    public void run() {
		CardListView.getInstance().changeRepository(filename);
	    }
	    
	};
    }
    
    protected void fillStatusLine(IStatusLineManager statusLine) {
	super.fillStatusLine(statusLine);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
	MenuManager fileMenu = new MenuManager("&File",
		IWorkbenchActionConstants.M_FILE);
	menuBar.add(fileMenu);
//	fileMenu.add(newRepository());
//	fileMenu.add(chgRepository());
//	fileMenu.add(chgPassword());
//	fileMenu.add(new Separator());
//	fileMenu.add(importCard());
//	fileMenu.add(importCardStore());
//	ArrayList historyRepository = Application.savedHistoryRepository;
//	if (historyRepository.size()>0) {
//	    fileMenu.add(new Separator());
//	    Iterator iter = historyRepository.iterator();
//	    while( iter.hasNext()) {
//		fileMenu.add( history((String)iter.next()));
//	    }
//	}
//	fileMenu.add(new Separator());
	fileMenu.add(exitAction);

	MenuManager cardMenu = new MenuManager("&Cards",
		IWorkbenchActionConstants.M_WINDOW);
	menuBar.add(cardMenu);
	cardMenu.add(createCard());
	cardMenu.add(chgCard());
	cardMenu.add(deleteCard());
	cardMenu.add(importCard());

	MenuManager storeMenu = new MenuManager("&Store",
			IWorkbenchActionConstants.M_WINDOW);
		menuBar.add(storeMenu);
		storeMenu.add(newRepository());
		storeMenu.add(chgRepository());
		storeMenu.add(chgPassword());
		storeMenu.add(importCardStore());
//	MenuManager surveyDirMenu = new MenuManager("&Survey Directory",
//		IWorkbenchActionConstants.M_WINDOW);
//	menuBar.add(surveyDirMenu);
//	surveyDirMenu.add(resetSurveyDir());

	MenuManager windowMenu = new MenuManager("&Window",
		IWorkbenchActionConstants.M_WINDOW);
	menuBar.add(windowMenu);
	windowMenu.add(preferencesAction);

	MenuManager helpMenu = new MenuManager("&Help", "help");
	menuBar.add(helpMenu);
	helpMenu.add(aboutAction);
	helpMenu.add(createHigginsProvidersDialog());
    }
}
