/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.extensions;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class Rating
extends ExtensionPoint {
    protected String rel;
    protected Integer rating;
    protected Integer min;
    protected Integer max;
    protected Integer numRaters;
    protected Float average;

    public Rating() {
        this((Integer)null);
    }

    public Rating(Integer rating) {
        this.rating = rating;
    }

    public String getRel() {
        return this.rel;
    }

    public void setRel(String v) {
        this.rel = v;
    }

    public Integer getValue() {
        return this.rating;
    }

    public void setValue(Integer r) {
        this.rating = r;
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer r) {
        this.min = r;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer r) {
        this.max = r;
    }

    public Integer getNumRaters() {
        return this.numRaters;
    }

    public void setNumRaters(Integer r) {
        this.numRaters = r;
    }

    public Float getAverage() {
        return this.average;
    }

    public void setAverage(Float r) {
        this.average = r;
    }

    public static ExtensionDescription getDefaultDescription(boolean repeatable) {
        ExtensionDescription desc = new ExtensionDescription();
        desc.setExtensionClass(Rating.class);
        desc.setNamespace(Namespaces.gNs);
        desc.setLocalName("rating");
        desc.setRepeatable(repeatable);
        return desc;
    }

    public static ExtensionDescription getDefaultDescription() {
        return Rating.getDefaultDescription(true);
    }

    public void generate(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>();
        if (this.rel != null) {
            attrs.add(new XmlWriter.Attribute("rel", this.rel));
        }
        if (this.rating != null) {
            attrs.add(new XmlWriter.Attribute("value", this.rating.toString()));
        }
        if (this.min != null) {
            attrs.add(new XmlWriter.Attribute("min", this.min.toString()));
        }
        if (this.max != null) {
            attrs.add(new XmlWriter.Attribute("max", this.max.toString()));
        }
        if (this.numRaters != null) {
            attrs.add(new XmlWriter.Attribute("numRaters", this.numRaters.toString()));
        }
        if (this.average != null) {
            attrs.add(new XmlWriter.Attribute("average", String.format("%2.2f", this.average)));
        }
        this.generateStartElement(w, Namespaces.gNs, "rating", attrs, null);
        this.generateExtensions(w, extProfile);
        w.endElement(Namespaces.gNs, "rating");
    }

    public XmlParser.ElementHandler getHandler(ExtensionProfile extProfile, String namespace, String localName, Attributes attrs) {
        return new Handler(extProfile);
    }

    private class Handler
    extends ExtensionPoint.ExtensionHandler {
        public Handler(ExtensionProfile extProfile) {
            super(Rating.this, extProfile, Rating.class);
        }

        public void processAttribute(String namespace, String localName, String value) throws NumberFormatException {
            if (namespace.equals("")) {
                if (localName.equals("value")) {
                    Rating.this.rating = Integer.parseInt(value);
                } else if (localName.equals("max")) {
                    Rating.this.max = Integer.parseInt(value);
                } else if (localName.equals("min")) {
                    Rating.this.min = Integer.parseInt(value);
                } else if (localName.equals("rel")) {
                    Rating.this.rel = value;
                } else if (localName.equals("numRaters")) {
                    Rating.this.numRaters = Integer.parseInt(value);
                } else if (localName.equals("average")) {
                    Rating.this.average = Float.valueOf(value);
                }
            }
        }

        public void processEndElement() throws ParseException {
            if (Rating.this.rating == null && Rating.this.average == null) {
                throw new ParseException(CoreErrorDomain.ERR.valueOrAverageRequired);
            }
            if (Rating.this.rating != null && (Rating.this.min != null && Rating.this.rating < Rating.this.min || Rating.this.max != null && Rating.this.rating > Rating.this.max)) {
                throw new ParseException(CoreErrorDomain.ERR.invalidValueRatingAttribute);
            }
            if (Rating.this.average != null && (Rating.this.min != null && Rating.this.average.floatValue() < (float)Rating.this.min.intValue() || Rating.this.max != null && Rating.this.average.floatValue() > (float)Rating.this.max.intValue())) {
                throw new ParseException(CoreErrorDomain.ERR.invalidAverageRatingAttribute);
            }
        }
    }

    public static final class Rel {
        public static final String OVERALL = null;
        public static final String QUALITY = "http://schemas.google.com/g/2005#quality";
        public static final String PRICE = "http://schemas.google.com/g/2005#price";
    }
}

