/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.media;

import com.google.gdata.client.AuthTokenFactory;
import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.client.GoogleService;
import com.google.gdata.client.Service;
import com.google.gdata.client.http.HttpGDataRequest;
import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.MediaContent;
import com.google.gdata.data.ParseSource;
import com.google.gdata.data.media.MediaEntry;
import com.google.gdata.data.media.MediaMultipart;
import com.google.gdata.data.media.MediaSource;
import com.google.gdata.data.media.MediaStreamSource;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.ErrorContent;
import com.google.gdata.util.RedirectRequiredException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.common.base.PercentEscaper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.mail.MessagingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaService
extends GoogleService {
    public static final int DEFAULT_CHUNKED_BUFFER_SIZE = 0;
    public static final int NO_CHUNKED_MEDIA_REQUEST = -1;
    private int chunkedBufferSize = 0;
    private static final PercentEscaper SLUG_ESCAPER = new PercentEscaper(" !\"#$&'()*+,-./:;<=>?@[\\]^_`{|}~", false);

    public MediaService(String serviceName, String applicationName) {
        super(serviceName, applicationName);
    }

    public MediaService(String applicationName, Service.GDataRequestFactory requestFactory, AuthTokenFactory authTokenFactory) {
        super(applicationName, requestFactory, authTokenFactory);
    }

    public MediaService(String serviceName, String applicationName, String protocol, String domainName) {
        super(serviceName, applicationName, protocol, domainName);
    }

    public void setChunkedMediaUpload(int chunkSizeInBytes) {
        this.chunkedBufferSize = chunkSizeInBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaSource getMediaResource(URL mediaUrl, ContentType contentType, DateTime ifModifiedSince) throws IOException, ServiceException {
        MediaStreamSource mediaSource;
        try {
            String etag;
            this.startVersionScope();
            Service.GDataRequest request = this.createRequest(Service.GDataRequest.RequestType.QUERY, mediaUrl, contentType);
            request.setIfModifiedSince(ifModifiedSince);
            request.execute();
            InputStream resultStream = request.getResponseStream();
            mediaSource = new MediaStreamSource(resultStream, request.getResponseContentType().toString());
            DateTime lastModified = request.getResponseDateHeader("Last-Modified");
            if (lastModified != null) {
                mediaSource.setLastModified(lastModified);
            }
            if ((etag = request.getResponseHeader("ETag")) != null) {
                mediaSource.setEtag(etag);
            }
        }
        finally {
            this.endVersionScope();
        }
        return mediaSource;
    }

    public MediaSource getMedia(MediaContent mediaContent, DateTime ifModifiedSince) throws IOException, ServiceException {
        URL mediaUrl = null;
        try {
            mediaUrl = new URL(mediaContent.getUri());
            return this.getMediaResource(mediaUrl, mediaContent.getMimeType(), ifModifiedSince);
        }
        catch (MalformedURLException mue) {
            throw new ServiceException((ErrorContent)CoreErrorDomain.ERR.invalidMediaSourceUri, (Throwable)mue);
        }
        catch (RedirectRequiredException e) {
            mediaUrl = this.handleRedirectException(e);
        }
        catch (GoogleService.SessionExpiredException e) {
            this.handleSessionExpiredException(e);
        }
        return this.getMediaResource(mediaUrl, mediaContent.getMimeType(), ifModifiedSince);
    }

    public MediaSource getMedia(MediaContent mediaContent) throws IOException, ServiceException {
        return this.getMedia(mediaContent, null);
    }

    private void initMediaRequest(MediaSource media, Service.GDataRequest request) {
        String name = media.getName();
        if (name != null) {
            request.setHeader("Slug", MediaService.escapeSlug(name));
        }
        if (this.chunkedBufferSize != -1 && request instanceof HttpGDataRequest) {
            HttpGDataRequest httpRequest = (HttpGDataRequest)request;
            httpRequest.getConnection().setChunkedStreamingMode(this.chunkedBufferSize);
        }
    }

    static String escapeSlug(String slug) {
        return SLUG_ESCAPER.escape(slug);
    }

    public <E extends BaseEntry<?>> E insert(URL feedUrl, E entry) throws IOException, ServiceException {
        BaseEntry baseEntry;
        MediaSource media;
        if (entry == null) {
            throw new NullPointerException("Must supply entry");
        }
        MediaSource mediaSource = media = entry instanceof MediaEntry ? ((MediaEntry)entry).getMediaSource() : null;
        if (media == null) {
            return (E)super.insert(feedUrl, entry);
        }
        ParseSource resultEntrySource = null;
        try {
            this.startVersionScope();
            MediaMultipart mediaMultipart = new MediaMultipart((IEntry)entry, media);
            Service.GDataRequest request = this.createRequest(Service.GDataRequest.RequestType.INSERT, feedUrl, new ContentType(mediaMultipart.getContentType()));
            this.initMediaRequest(media, request);
            OutputStream outputStream = request.getRequestStream();
            mediaMultipart.writeTo(outputStream);
            request.execute();
            resultEntrySource = request.getParseSource();
            baseEntry = this.parseEntry(entry.getClass(), resultEntrySource);
        }
        catch (MessagingException e) {
            try {
                throw new ServiceException((ErrorContent)CoreErrorDomain.ERR.cantWriteMimeMultipart, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.endVersionScope();
                this.closeSource(resultEntrySource);
                throw throwable;
            }
        }
        this.endVersionScope();
        this.closeSource(resultEntrySource);
        return (E)baseEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntry> E insert(URL feedUrl, Class<E> entryClass, MediaSource media) throws IOException, ServiceException {
        BaseEntry baseEntry;
        if (media == null) {
            throw new NullPointerException("Must supply media source");
        }
        ParseSource resultEntrySource = null;
        try {
            this.startVersionScope();
            Service.GDataRequest request = this.createRequest(Service.GDataRequest.RequestType.INSERT, feedUrl, new ContentType(media.getContentType()));
            this.initMediaRequest(media, request);
            MediaSource.Output.writeTo(media, request.getRequestStream());
            request.execute();
            resultEntrySource = request.getParseSource();
            baseEntry = this.parseEntry(entryClass, resultEntrySource);
        }
        catch (Throwable throwable) {
            this.endVersionScope();
            this.closeSource(resultEntrySource);
            throw throwable;
        }
        this.endVersionScope();
        this.closeSource(resultEntrySource);
        return (E)baseEntry;
    }

    public <E extends BaseEntry> E updateMedia(URL mediaUrl, E entry) throws IOException, ServiceException {
        BaseEntry baseEntry;
        MediaSource media;
        if (entry == null) {
            throw new NullPointerException("Must supply entry");
        }
        MediaSource mediaSource = media = entry instanceof MediaEntry ? ((MediaEntry)entry).getMediaSource() : null;
        if (media == null) {
            throw new NullPointerException("Must supply media source");
        }
        ParseSource resultEntrySource = null;
        try {
            this.startVersionScope();
            MediaMultipart mediaMultipart = new MediaMultipart((IEntry)entry, media);
            Service.GDataRequest request = this.createRequest(Service.GDataRequest.RequestType.UPDATE, mediaUrl, new ContentType(mediaMultipart.getContentType()));
            OutputStream outputStream = request.getRequestStream();
            mediaMultipart.writeTo(outputStream);
            request.execute();
            resultEntrySource = request.getParseSource();
            baseEntry = this.parseEntry(entry.getClass(), resultEntrySource);
        }
        catch (MessagingException e) {
            try {
                throw new ServiceException((ErrorContent)CoreErrorDomain.ERR.cantWriteMimeMultipart, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.endVersionScope();
                this.closeSource(resultEntrySource);
                throw throwable;
            }
        }
        this.endVersionScope();
        this.closeSource(resultEntrySource);
        return (E)baseEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntry> E updateMedia(URL mediaUrl, Class<E> entryClass, MediaSource media) throws IOException, ServiceException {
        BaseEntry baseEntry;
        if (media == null) {
            throw new NullPointerException("Must supply media source");
        }
        ParseSource resultEntrySource = null;
        try {
            this.startVersionScope();
            Service.GDataRequest request = this.createRequest(Service.GDataRequest.RequestType.UPDATE, mediaUrl, new ContentType(media.getContentType()));
            MediaSource.Output.writeTo(media, request.getRequestStream());
            request.execute();
            resultEntrySource = request.getParseSource();
            baseEntry = this.parseEntry(entryClass, resultEntrySource);
        }
        catch (Throwable throwable) {
            this.endVersionScope();
            this.closeSource(resultEntrySource);
            throw throwable;
        }
        this.endVersionScope();
        this.closeSource(resultEntrySource);
        return (E)baseEntry;
    }
}

