/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit.client;

import com.google.gwt.junit.client.Operator;
import com.google.gwt.junit.client.Range;
import com.google.gwt.junit.client.RangeIterator;
import java.util.Iterator;

public class IntRange
implements Range {
    int end;
    Operator operator;
    int start;
    int step;

    public IntRange(int start, int end, Operator operator, int step) {
        this.start = start;
        this.end = end;
        this.operator = operator;
        this.step = step;
        if (step <= 0) {
            throw new IllegalArgumentException("step must be > 0");
        }
    }

    public Iterator iterator() {
        return new IntRangeIterator(this);
    }

    private static class IntRangeIterator
    extends RangeIterator {
        int end;
        Operator operator;
        int start;
        int step;
        int value;

        IntRangeIterator(IntRange r) {
            this.value = this.start = r.start;
            this.end = r.end;
            this.operator = r.operator;
            if (this.operator == null) {
                throw new IllegalArgumentException("operator must be \"*\" or \"+\"");
            }
            this.step = r.step;
        }

        public boolean hasNext() {
            return this.value <= this.end;
        }

        public Object next() {
            int currentValue = this.value;
            this.value = this.step();
            return new Integer(currentValue);
        }

        public int step() {
            if (this.operator == Operator.MULTIPLY) {
                return this.value * this.step;
            }
            return this.value + this.step;
        }
    }
}

