/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.HasFocus;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeImages;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

public class TreeItem
extends UIObject
implements HasHTML {
    private ArrayList children = new ArrayList();
    private Element itemTable;
    private Element contentElem;
    private Element childSpanElem;
    private final Image statusImage = new Image();
    private boolean open;
    private TreeItem parent;
    private boolean selected;
    private Object userObject;
    private Tree tree;
    private Widget widget;

    public TreeItem() {
        this.setElement(DOM.createDiv());
        this.itemTable = DOM.createTable();
        this.contentElem = DOM.createSpan();
        this.childSpanElem = DOM.createSpan();
        Element tbody = DOM.createTBody();
        Element tr = DOM.createTR();
        Element tdImg = DOM.createTD();
        Element tdContent = DOM.createTD();
        DOM.appendChild(this.itemTable, tbody);
        DOM.appendChild(tbody, tr);
        DOM.appendChild(tr, tdImg);
        DOM.appendChild(tr, tdContent);
        DOM.setStyleAttribute(tdImg, "verticalAlign", "middle");
        DOM.setStyleAttribute(tdContent, "verticalAlign", "middle");
        DOM.appendChild(this.getElement(), this.itemTable);
        DOM.appendChild(this.getElement(), this.childSpanElem);
        DOM.appendChild(tdImg, this.statusImage.getElement());
        DOM.appendChild(tdContent, this.contentElem);
        DOM.setStyleAttribute(this.contentElem, "display", "inline");
        DOM.setStyleAttribute(this.getElement(), "whiteSpace", "nowrap");
        DOM.setStyleAttribute(this.childSpanElem, "whiteSpace", "nowrap");
        TreeItem.setStyleName(this.contentElem, "gwt-TreeItem", true);
    }

    public TreeItem(String html) {
        this();
        this.setHTML(html);
    }

    public TreeItem(Widget widget) {
        this();
        this.setWidget(widget);
    }

    public TreeItem addItem(String itemText) {
        TreeItem ret = new TreeItem(itemText);
        this.addItem(ret);
        return ret;
    }

    public void addItem(TreeItem item) {
        if (item.getParentItem() != null || item.getTree() != null) {
            item.remove();
        }
        item.setParentItem(this);
        this.children.add(item);
        DOM.setStyleAttribute(item.getElement(), "marginLeft", "16px");
        DOM.appendChild(this.childSpanElem, item.getElement());
        item.setTree(this.tree);
        if (this.children.size() == 1) {
            this.updateState();
        }
    }

    public TreeItem addItem(Widget widget) {
        TreeItem ret = new TreeItem(widget);
        this.addItem(ret);
        return ret;
    }

    public TreeItem getChild(int index) {
        if (index < 0 || index >= this.children.size()) {
            return null;
        }
        return (TreeItem)this.children.get(index);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getChildIndex(TreeItem child) {
        return this.children.indexOf(child);
    }

    public String getHTML() {
        return DOM.getInnerHTML(this.contentElem);
    }

    public TreeItem getParentItem() {
        return this.parent;
    }

    public boolean getState() {
        return this.open;
    }

    public String getText() {
        return DOM.getInnerText(this.contentElem);
    }

    public final Tree getTree() {
        return this.tree;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public Widget getWidget() {
        return this.widget;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void remove() {
        if (this.parent != null) {
            this.parent.removeItem(this);
        } else if (this.tree != null) {
            this.tree.removeItem(this);
        }
    }

    public void removeItem(TreeItem item) {
        if (!this.children.contains(item)) {
            return;
        }
        item.setTree(null);
        DOM.removeChild(this.childSpanElem, item.getElement());
        item.setParentItem(null);
        this.children.remove(item);
        if (this.children.size() == 0) {
            this.updateState();
        }
    }

    public void removeItems() {
        while (this.getChildCount() > 0) {
            this.removeItem(this.getChild(0));
        }
    }

    public void setHTML(String html) {
        this.setWidget(null);
        DOM.setInnerHTML(this.contentElem, html);
    }

    public void setSelected(boolean selected) {
        if (this.selected == selected) {
            return;
        }
        this.selected = selected;
        TreeItem.setStyleName(this.contentElem, "gwt-TreeItem-selected", selected);
    }

    public void setState(boolean open) {
        this.setState(open, true);
    }

    public void setState(boolean open, boolean fireEvents) {
        if (open && this.children.size() == 0) {
            return;
        }
        this.open = open;
        this.updateState();
        if (fireEvents && this.tree != null) {
            this.tree.fireStateChanged(this);
        }
    }

    public void setText(String text) {
        this.setWidget(null);
        DOM.setInnerText(this.contentElem, text);
    }

    public void setUserObject(Object userObj) {
        this.userObject = userObj;
    }

    public void setWidget(Widget newWidget) {
        if (newWidget != null) {
            newWidget.removeFromParent();
        }
        if (this.widget != null && this.tree != null) {
            this.tree.orphan(this.widget);
        }
        DOM.setInnerHTML(this.contentElem, "");
        this.widget = newWidget;
        if (newWidget != null) {
            DOM.appendChild(this.contentElem, newWidget.getElement());
            if (this.tree != null) {
                this.tree.adopt(this.widget, this);
            }
        }
    }

    protected HasFocus getFocusableWidget() {
        Widget w = this.getWidget();
        if (w instanceof HasFocus) {
            return (HasFocus)((Object)w);
        }
        return null;
    }

    void addTreeItems(List accum) {
        for (int i = 0; i < this.children.size(); ++i) {
            TreeItem item = (TreeItem)this.children.get(i);
            accum.add(item);
            item.addTreeItems(accum);
        }
    }

    ArrayList getChildren() {
        return this.children;
    }

    Element getContentElem() {
        return this.contentElem;
    }

    int getContentHeight() {
        return DOM.getElementPropertyInt(this.itemTable, "offsetHeight");
    }

    Element getImageElement() {
        return this.statusImage.getElement();
    }

    int getTreeTop() {
        int ret = 0;
        for (TreeItem item = this; item != null; item = item.getParentItem()) {
            ret += DOM.getElementPropertyInt(item.getElement(), "offsetTop");
        }
        return ret;
    }

    void setParentItem(TreeItem parent) {
        this.parent = parent;
    }

    void setTree(Tree newTree) {
        if (this.tree == newTree) {
            return;
        }
        if (this.tree != null) {
            if (this.tree.getSelectedItem() == this) {
                this.tree.setSelectedItem(null);
            }
            if (this.widget != null) {
                this.tree.orphan(this.widget);
            }
        }
        this.tree = newTree;
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            ((TreeItem)this.children.get(i)).setTree(newTree);
        }
        this.updateState();
        if (newTree != null && this.widget != null) {
            newTree.adopt(this.widget, this);
        }
    }

    void updateState() {
        if (this.tree == null) {
            return;
        }
        TreeImages images = this.tree.getImages();
        if (this.children.size() == 0) {
            UIObject.setVisible(this.childSpanElem, false);
            images.treeLeaf().applyTo(this.statusImage);
            return;
        }
        if (this.open) {
            UIObject.setVisible(this.childSpanElem, true);
            images.treeOpen().applyTo(this.statusImage);
        } else {
            UIObject.setVisible(this.childSpanElem, false);
            images.treeClosed().applyTo(this.statusImage);
        }
    }

    void updateStateRecursive() {
        this.updateState();
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            ((TreeItem)this.children.get(i)).updateStateRecursive();
        }
    }
}

