/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;

public class WaitableInt
extends SynchronizedInt {
    public WaitableInt(int initialValue) {
        super(initialValue);
    }

    public WaitableInt(int initialValue, Object lock) {
        super(initialValue, lock);
    }

    public int set(int newValue) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            int n = super.set(newValue);
            return n;
        }
    }

    public boolean commit(int assumedValue, int newValue) {
        Object object = this.lock_;
        synchronized (object) {
            boolean success = super.commit(assumedValue, newValue);
            if (success) {
                this.lock_.notifyAll();
            }
            boolean bl = success;
            return bl;
        }
    }

    public int increment() {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            int n = super.increment();
            return n;
        }
    }

    public int decrement() {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            int n = super.decrement();
            return n;
        }
    }

    public int add(int amount) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            int n = super.add(amount);
            return n;
        }
    }

    public int subtract(int amount) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            int n = super.subtract(amount);
            return n;
        }
    }

    public int multiply(int factor) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            int n = super.multiply(factor);
            return n;
        }
    }

    public int divide(int factor) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            int n = super.divide(factor);
            return n;
        }
    }

    public void whenEqual(int c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ != c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenNotEqual(int c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ == c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenLessEqual(int c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ > c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenLess(int c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ >= c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenGreaterEqual(int c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ < c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenGreater(int c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ <= c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }
}

