/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;

public final class WaiterPreferenceSemaphore
extends Semaphore {
    protected long waits_ = 0L;

    public WaiterPreferenceSemaphore(long initial) {
        super(initial);
    }

    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        WaiterPreferenceSemaphore waiterPreferenceSemaphore = this;
        synchronized (waiterPreferenceSemaphore) {
            if (this.permits_ > this.waits_) {
                --this.permits_;
                return;
            }
            ++this.waits_;
            try {
                do {
                    this.wait();
                } while (this.permits_ <= 0L);
                --this.waits_;
                --this.permits_;
                return;
            }
            catch (InterruptedException ex) {
                --this.waits_;
                this.notify();
                throw ex;
            }
        }
    }

    public boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        WaiterPreferenceSemaphore waiterPreferenceSemaphore = this;
        synchronized (waiterPreferenceSemaphore) {
            if (this.permits_ > this.waits_) {
                --this.permits_;
                boolean bl = true;
                return bl;
            }
            if (msecs <= 0L) {
                boolean bl = false;
                return bl;
            }
            ++this.waits_;
            long startTime = System.currentTimeMillis();
            long waitTime = msecs;
            try {
                do {
                    this.wait(waitTime);
                    if (this.permits_ <= 0L) continue;
                    --this.waits_;
                    --this.permits_;
                    boolean bl = true;
                    return bl;
                } while ((waitTime = msecs - (System.currentTimeMillis() - startTime)) > 0L);
                --this.waits_;
                boolean bl = false;
                return bl;
            }
            catch (InterruptedException ex) {
                --this.waits_;
                this.notify();
                throw ex;
            }
        }
    }

    public synchronized void release() {
        ++this.permits_;
        this.notify();
    }

    public synchronized void release(long n) {
        this.permits_ += n;
        long i = 0L;
        while (i < n) {
            this.notify();
            ++i;
        }
    }
}

