/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.http;

import com.google.gdata.client.GoogleService;
import com.google.gdata.client.Query;
import com.google.gdata.client.Service;
import com.google.gdata.client.http.HttpAuthToken;
import com.google.gdata.client.http.HttpGDataRequest;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.RedirectRequiredException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.Version;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleGDataRequest
extends HttpGDataRequest {
    private static final Logger logger = Logger.getLogger(GoogleGDataRequest.class.getName());
    public static final String DISABLE_COOKIE_HANDLER_PROPERTY = "com.google.gdata.DisableCookieHandler";
    private static final ThreadLocal<GoogleService> activeService = new ThreadLocal();
    private static final GoogleCookieHandler googleCookieHandler = !Boolean.getBoolean("com.google.gdata.DisableCookieHandler") ? new GoogleCookieHandler() : null;
    private GoogleService service;
    private Version responseVersion;

    protected GoogleGDataRequest(Service.GDataRequest.RequestType type, URL requestUrl, ContentType contentType, HttpAuthToken authToken, Map<String, String> headerMap, Map<String, String> privateHeaderMap) throws IOException {
        super(type, requestUrl, contentType, authToken, headerMap, privateHeaderMap);
    }

    public Version getRequestVersion() {
        return this.service.getProtocolVersion();
    }

    public Version getResponseVersion() {
        if (!this.executed) {
            throw new IllegalStateException("Request has not been executed");
        }
        return this.responseVersion;
    }

    public void setService(GoogleService service) {
        this.service = service;
        if (Boolean.getBoolean("GoogleGDataRequest.disableVersionHeader")) {
            return;
        }
        try {
            Version requestVersion = service.getProtocolVersion();
            if (requestVersion != null) {
                this.setHeader("GData-Version", requestVersion.getVersionString());
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws IOException, ServiceException {
        try {
            GoogleService service;
            activeService.set(this.service);
            this.httpConn.setInstanceFollowRedirects(false);
            super.execute();
            String versionHeader = this.httpConn.getHeaderField("GData-Version");
            if (versionHeader != null && (service = activeService.get()) != null) {
                this.responseVersion = new Version(service.getClass(), versionHeader, new Version[0]);
            }
        }
        finally {
            activeService.set(null);
        }
    }

    @Override
    protected void handleErrorResponse() throws IOException, ServiceException {
        try {
            switch (this.httpConn.getResponseCode()) {
                case 301: 
                case 302: {
                    throw new RedirectRequiredException(this.httpConn);
                }
            }
            super.handleErrorResponse();
        }
        catch (AuthenticationException e) {
            String msg = e.getMessage();
            if (msg != null && msg.contains("Token expired")) {
                GoogleService.SessionExpiredException se = new GoogleService.SessionExpiredException(e.getMessage());
                se.setResponse(e.getResponseContentType(), e.getResponseBody());
                throw se;
            }
            throw e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GoogleCookieHandler
    extends CookieHandler {
        private CookieHandler nextHandler;

        private GoogleCookieHandler() {
            if (!Boolean.getBoolean(GoogleGDataRequest.DISABLE_COOKIE_HANDLER_PROPERTY)) {
                logger.fine("Installing GoogleCookieHandler");
                this.nextHandler = CookieHandler.getDefault();
                CookieHandler.setDefault(this);
            }
        }

        @Override
        public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
            HashMap<String, List<String>> cookieHeaders = new HashMap<String, List<String>>();
            GoogleService service = (GoogleService)activeService.get();
            if (service != null && service.handlesCookies()) {
                Set<GoogleCookie> cookies = service.getCookies();
                StringBuilder cookieBuf = new StringBuilder();
                for (GoogleCookie cookie : cookies) {
                    if (!cookie.matches(uri)) continue;
                    if (cookieBuf.length() > 0) {
                        cookieBuf.append("; ");
                    }
                    cookieBuf.append(cookie.getHeaderValue());
                    logger.fine("Setting cookie: " + cookie);
                }
                if (cookieBuf.length() != 0) {
                    cookieHeaders.put("Cookie", Collections.singletonList(cookieBuf.toString()));
                }
            } else if (this.nextHandler != null) {
                return this.nextHandler.get(uri, requestHeaders);
            }
            return Collections.unmodifiableMap(cookieHeaders);
        }

        @Override
        public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
            GoogleService service = (GoogleService)activeService.get();
            if (service != null && service.handlesCookies()) {
                List<String> setCookieList = responseHeaders.get("Set-Cookie");
                if (setCookieList != null && setCookieList.size() > 0) {
                    for (String cookieValue : setCookieList) {
                        GoogleCookie cookie = new GoogleCookie(uri, cookieValue);
                        service.addCookie(cookie);
                        logger.fine("Adding cookie:" + cookie);
                    }
                }
            } else if (this.nextHandler != null) {
                this.nextHandler.get(uri, responseHeaders);
            }
        }
    }

    public static class GoogleCookie {
        private String domain;
        private String path;
        private String name;
        private String value;
        private Date expires;

        public String getDomain() {
            return this.domain;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        String getValue() {
            return this.value;
        }

        public Date getExpires() {
            return this.expires != null ? (Date)this.expires.clone() : null;
        }

        public GoogleCookie(URI uri, String cookieHeader) {
            String[] attributes = cookieHeader.split(";");
            String nameValue = attributes[0].trim();
            int equals = nameValue.indexOf(61);
            if (equals < 0) {
                throw new IllegalArgumentException("Cookie is not a name/value pair");
            }
            this.name = nameValue.substring(0, equals);
            this.value = nameValue.substring(equals + 1);
            this.path = "/";
            this.domain = uri.getHost();
            for (int i = 1; i < attributes.length; ++i) {
                nameValue = attributes[i].trim();
                equals = nameValue.indexOf(61);
                if (equals == -1) continue;
                String name = nameValue.substring(0, equals);
                String value = nameValue.substring(equals + 1);
                if (name.equalsIgnoreCase("domain")) {
                    String uriDomain;
                    int colon;
                    if (uri.getPort() > 0 && (colon = value.lastIndexOf(58)) > 0) {
                        value = value.substring(0, colon);
                    }
                    if ((uriDomain = uri.getHost()).equals(value)) {
                        this.domain = value;
                    } else if (!this.matchDomain(uriDomain, value)) {
                        throw new IllegalArgumentException("Trying to set foreign cookie");
                    }
                    this.domain = value;
                    continue;
                }
                if (name.equalsIgnoreCase("path")) {
                    this.path = value;
                    continue;
                }
                if (!name.equalsIgnoreCase("expires")) continue;
                try {
                    this.expires = new SimpleDateFormat("E, dd-MMM-yyyy k:m:s 'GMT'", Locale.US).parse(value);
                    continue;
                }
                catch (ParseException e) {
                    try {
                        this.expires = new SimpleDateFormat("E, dd MMM yyyy k:m:s 'GMT'", Locale.US).parse(value);
                        continue;
                    }
                    catch (ParseException e2) {
                        throw new IllegalArgumentException("Bad date format in header: " + value);
                    }
                }
            }
        }

        private boolean matchDomain(String testDomain, String tailDomain) {
            if (!testDomain.endsWith(tailDomain)) {
                return false;
            }
            if (testDomain.length() == tailDomain.length()) {
                return true;
            }
            if (tailDomain.charAt(0) == '.') {
                return true;
            }
            return testDomain.charAt(testDomain.length() - tailDomain.length() - 1) == '.';
        }

        public boolean hasExpired() {
            if (this.expires == null) {
                return false;
            }
            Date now = new Date();
            return now.after(this.expires);
        }

        public boolean matches(URI uri) {
            if (this.hasExpired()) {
                return false;
            }
            String uriDomain = uri.getHost();
            if (!this.matchDomain(uriDomain, this.domain)) {
                return false;
            }
            String path = uri.getPath();
            if (path == null) {
                path = "/";
            }
            return path.startsWith(this.path);
        }

        String getHeaderValue() {
            StringBuilder result = new StringBuilder(this.name);
            result.append("=");
            result.append(this.value);
            return result.toString();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof GoogleCookie)) {
                return false;
            }
            GoogleCookie cookie = (GoogleCookie)o;
            if (!this.name.equals(cookie.name) || !this.domain.equals(cookie.domain)) {
                return false;
            }
            if (this.path == null) {
                return cookie.path == null;
            }
            return this.path.equals(cookie.path);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.name.hashCode();
            result = 37 * result + this.domain.hashCode();
            result = 37 * result + (this.path != null ? this.path.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("GoogleCookie(");
            buf.append(this.domain);
            buf.append(this.path);
            buf.append("[");
            buf.append(this.name);
            buf.append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class Factory
    extends HttpGDataRequest.Factory {
        public Service.GDataRequest getRequest(Service.GDataRequest.RequestType type, URL requestUrl, ContentType contentType) throws IOException, ServiceException {
            return new GoogleGDataRequest(type, requestUrl, contentType, this.authToken, this.headerMap, this.privateHeaderMap);
        }

        public Service.GDataRequest getRequest(Query query, ContentType contentType) throws IOException, ServiceException {
            return new GoogleGDataRequest(Service.GDataRequest.RequestType.QUERY, query.getUrl(), contentType, this.authToken, this.headerMap, this.privateHeaderMap);
        }
    }
}

