/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.http;

import com.google.gdata.client.AuthTokenFactory;
import com.google.gdata.client.Query;
import com.google.gdata.client.Service;
import com.google.gdata.client.http.HttpAuthToken;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.ParseSource;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.EntityTooLargeException;
import com.google.gdata.util.InvalidEntryException;
import com.google.gdata.util.LoggableInputStream;
import com.google.gdata.util.LoggableOutputStream;
import com.google.gdata.util.NoLongerAvailableException;
import com.google.gdata.util.NotAcceptableException;
import com.google.gdata.util.NotImplementedException;
import com.google.gdata.util.NotModifiedException;
import com.google.gdata.util.PreconditionFailedException;
import com.google.gdata.util.ResourceNotFoundException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.ServiceForbiddenException;
import com.google.gdata.util.VersionConflictException;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpGDataRequest
implements Service.GDataRequest {
    static final Logger logger = Logger.getLogger(HttpGDataRequest.class.getName());
    public static final String METHOD_OVERRIDE_PROPERTY = "com.google.gdata.UseMethodOverride";
    public static final String METHOD_OVERRIDE_HEADER = "X-HTTP-Method-Override";
    protected HttpURLConnection httpConn;
    protected URL requestUrl;
    protected Service.GDataRequest.RequestType type;
    protected boolean executed = false;
    protected boolean expectsInput;
    protected boolean hasOutput;
    protected int connectTimeout = -1;
    protected int readTimeout = -1;

    protected HttpGDataRequest(Service.GDataRequest.RequestType type, URL requestUrl, ContentType contentType, HttpAuthToken authToken, Map<String, String> headerMap, Map<String, String> privateHeaderMap) throws IOException {
        this.type = type;
        this.requestUrl = requestUrl;
        this.httpConn = this.getRequestConnection(requestUrl);
        switch (type) {
            case QUERY: {
                this.hasOutput = true;
                break;
            }
            case INSERT: 
            case BATCH: {
                this.expectsInput = true;
                this.hasOutput = true;
                this.setMethod("POST");
                this.setHeader("Content-Type", contentType.toString());
                break;
            }
            case UPDATE: {
                this.expectsInput = true;
                this.hasOutput = true;
                if (Boolean.getBoolean(METHOD_OVERRIDE_PROPERTY)) {
                    this.setMethod("POST");
                    this.setHeader(METHOD_OVERRIDE_HEADER, "PUT");
                } else {
                    this.setMethod("PUT");
                }
                this.setHeader("Content-Type", contentType.toString());
                break;
            }
            case DELETE: {
                if (Boolean.getBoolean(METHOD_OVERRIDE_PROPERTY)) {
                    this.setMethod("POST");
                    this.setHeader(METHOD_OVERRIDE_HEADER, "DELETE");
                } else {
                    this.setMethod("DELETE");
                }
                this.setHeader("Content-Length", "0");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown request type:" + (Object)((Object)type));
            }
        }
        if (authToken != null) {
            String authHeader = authToken.getAuthorizationHeader(requestUrl, this.httpConn.getRequestMethod());
            this.setPrivateHeader("Authorization", authHeader);
        }
        if (headerMap != null) {
            for (Map.Entry<String, String> e : headerMap.entrySet()) {
                this.setHeader(e.getKey(), e.getValue());
            }
        }
        if (privateHeaderMap != null) {
            for (Map.Entry<String, String> e : privateHeaderMap.entrySet()) {
                this.setPrivateHeader(e.getKey(), e.getValue());
            }
        }
        this.setHeader("Accept-Encoding", "gzip");
        this.httpConn.setDoOutput(this.expectsInput);
    }

    protected HttpGDataRequest() {
    }

    protected HttpURLConnection getRequestConnection(URL requestUrl) throws IOException {
        if (!requestUrl.getProtocol().startsWith("http")) {
            throw new UnsupportedOperationException("Unsupported scheme:" + requestUrl.getProtocol());
        }
        HttpURLConnection uc = (HttpURLConnection)requestUrl.openConnection();
        uc.setUseCaches(false);
        uc.setInstanceFollowRedirects(true);
        return uc;
    }

    @Override
    public void setConnectTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout cannot be negative");
        }
        this.connectTimeout = timeout;
    }

    @Override
    public void setReadTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout cannot be negative");
        }
        this.readTimeout = timeout;
    }

    @Override
    public void setIfModifiedSince(DateTime conditionDate) {
        if (conditionDate == null) {
            return;
        }
        if (this.type != Service.GDataRequest.RequestType.QUERY) {
            throw new IllegalStateException("Date conditions not supported for this request type");
        }
        this.setHeader("If-Modified-Since", conditionDate.toStringRfc822());
    }

    @Override
    public void setEtag(String etag) {
        if (etag == null) {
            return;
        }
        switch (this.type) {
            case QUERY: {
                if (etag == null) break;
                this.setHeader("If-None-Match", etag);
                break;
            }
            case UPDATE: 
            case DELETE: {
                if (etag == null) break;
                this.setHeader("If-Match", etag);
                break;
            }
            default: {
                throw new IllegalStateException("Etag conditions not supported for this request type");
            }
        }
    }

    @Override
    public OutputStream getRequestStream() throws IOException {
        if (!this.expectsInput) {
            throw new IllegalStateException("Request doesn't accept input");
        }
        if (logger.isLoggable(Level.FINEST)) {
            return new LoggableOutputStream(logger, this.httpConn.getOutputStream());
        }
        return this.httpConn.getOutputStream();
    }

    @Override
    public XmlWriter getRequestWriter() throws IOException {
        OutputStream requestStream = this.getRequestStream();
        OutputStreamWriter writer = new OutputStreamWriter(requestStream, "utf-8");
        return new XmlWriter(writer);
    }

    public void setMethod(String method) throws ProtocolException {
        this.httpConn.setRequestMethod(method);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(method + " " + this.httpConn.getURL().toExternalForm());
        }
    }

    @Override
    public void setHeader(String name, String value) {
        this.httpConn.setRequestProperty(name, value);
        logger.finer(name + ": " + value);
    }

    @Override
    public void setPrivateHeader(String name, String value) {
        this.httpConn.setRequestProperty(name, value);
        logger.finer(name + ": <Not Logged>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws IOException, ServiceException {
        if (this.connectTimeout >= 0) {
            this.httpConn.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout >= 0) {
            this.httpConn.setReadTimeout(this.readTimeout);
        }
        String httpStrictPostRedirect = System.getProperty("http.strictPostRedirect");
        try {
            System.setProperty("http.strictPostRedirect", "true");
            this.httpConn.connect();
            if (logger.isLoggable(Level.FINE)) {
                if (this.httpConn.getURL() != this.requestUrl && !this.httpConn.getURL().toExternalForm().equals(this.requestUrl.toExternalForm())) {
                    logger.fine("Redirected to:" + this.httpConn.getURL().toExternalForm());
                }
                logger.fine(this.httpConn.getResponseCode() + " " + this.httpConn.getResponseMessage());
                if (logger.isLoggable(Level.FINER)) {
                    for (Map.Entry<String, List<String>> headerField : this.httpConn.getHeaderFields().entrySet()) {
                        for (String value : headerField.getValue()) {
                            logger.finer(headerField.getKey() + ": " + value);
                        }
                    }
                }
            }
            this.checkResponse();
        }
        finally {
            if (httpStrictPostRedirect == null) {
                System.clearProperty("http.strictPostRedirect");
            } else {
                System.setProperty("http.strictPostRedirect", httpStrictPostRedirect);
            }
        }
        this.executed = true;
    }

    protected void checkResponse() throws IOException, ServiceException {
        if (this.httpConn.getResponseCode() >= 300) {
            this.handleErrorResponse();
        }
    }

    protected void handleErrorResponse() throws ServiceException, IOException {
        switch (this.httpConn.getResponseCode()) {
            case 404: {
                throw new ResourceNotFoundException(this.httpConn);
            }
            case 400: {
                throw new InvalidEntryException(this.httpConn);
            }
            case 403: {
                throw new ServiceForbiddenException(this.httpConn);
            }
            case 401: {
                throw new AuthenticationException(this.httpConn);
            }
            case 304: {
                throw new NotModifiedException(this.httpConn);
            }
            case 412: {
                throw new PreconditionFailedException(this.httpConn);
            }
            case 501: {
                throw new NotImplementedException(this.httpConn);
            }
            case 409: {
                throw new VersionConflictException(this.httpConn);
            }
            case 413: {
                throw new EntityTooLargeException(this.httpConn);
            }
            case 406: {
                throw new NotAcceptableException(this.httpConn);
            }
            case 410: {
                throw new NoLongerAvailableException(this.httpConn);
            }
        }
        throw new ServiceException(this.httpConn);
    }

    @Override
    public ContentType getResponseContentType() {
        if (!this.executed) {
            throw new IllegalStateException("Must call execute() before attempting to read response");
        }
        String value = this.httpConn.getHeaderField("Content-Type");
        if (value == null) {
            return null;
        }
        return new ContentType(value);
    }

    @Override
    public String getResponseHeader(String headerName) {
        return this.httpConn.getHeaderField(headerName);
    }

    @Override
    public DateTime getResponseDateHeader(String headerName) {
        long dateValue = this.httpConn.getHeaderFieldDate(headerName, -1L);
        return dateValue >= 0L ? new DateTime(dateValue) : null;
    }

    @Override
    public InputStream getResponseStream() throws IOException {
        if (!this.executed) {
            throw new IllegalStateException("Must call execute() before attempting to read response");
        }
        if (!this.hasOutput) {
            throw new IllegalStateException("Request doesn't have response data");
        }
        InputStream responseStream = this.httpConn.getInputStream();
        if ("gzip".equalsIgnoreCase(this.httpConn.getContentEncoding())) {
            responseStream = new GZIPInputStream(responseStream);
        }
        if (logger.isLoggable(Level.FINEST)) {
            return new LoggableInputStream(logger, responseStream);
        }
        return responseStream;
    }

    @Override
    public ParseSource getParseSource() throws IOException {
        return new ParseSource(this.getResponseStream());
    }

    public HttpURLConnection getConnection() {
        return this.httpConn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements Service.GDataRequestFactory {
        protected HttpAuthToken authToken;
        protected Map<String, String> headerMap = new LinkedHashMap<String, String>();
        protected Map<String, String> privateHeaderMap = new LinkedHashMap<String, String>();
        protected boolean useSsl = false;

        @Override
        public void setAuthToken(AuthTokenFactory.AuthToken authToken) {
            if (authToken != null && !(authToken instanceof HttpAuthToken)) {
                throw new IllegalArgumentException("Invalid token type");
            }
            this.setAuthToken((HttpAuthToken)authToken);
        }

        public void setAuthToken(HttpAuthToken authToken) {
            this.authToken = authToken;
        }

        public void useSsl() {
            this.useSsl = true;
        }

        private void extendHeaderMap(Map<String, String> headerMap, String header, String value) {
            if (value == null) {
                headerMap.remove(header);
            } else {
                headerMap.put(header, value);
            }
        }

        @Override
        public void setHeader(String header, String value) {
            this.extendHeaderMap(this.headerMap, header, value);
        }

        @Override
        public void setPrivateHeader(String header, String value) {
            this.extendHeaderMap(this.privateHeaderMap, header, value);
        }

        @Override
        public Service.GDataRequest getRequest(Service.GDataRequest.RequestType type, URL requestUrl, ContentType contentType) throws IOException, ServiceException {
            if (this.useSsl && !requestUrl.getProtocol().startsWith("https")) {
                requestUrl = new URL(requestUrl.toString().replaceFirst("http", "https"));
            }
            return new HttpGDataRequest(type, requestUrl, contentType, this.authToken, this.headerMap, this.privateHeaderMap);
        }

        @Override
        public Service.GDataRequest getRequest(Query query, ContentType contentType) throws IOException, ServiceException {
            return this.getRequest(Service.GDataRequest.RequestType.QUERY, query.getUrl(), contentType);
        }
    }
}

