/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.Content;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ILink;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class Link
extends ExtensionPoint
implements ILink {
    protected String rel;
    protected String type;
    protected String href;
    protected String hrefLang;
    protected String title;
    protected String titleLang;
    protected long length = -1L;
    protected Content content = null;
    protected String etag = null;

    public Link() {
    }

    public Link(String rel, String type, String href) {
        this.rel = rel;
        this.type = type;
        this.setHref(href);
    }

    public String getRel() {
        return this.rel != null ? this.rel : "alternate";
    }

    public void setRel(String v) {
        this.rel = v;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String v) {
        this.type = v;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String v) {
        this.href = v;
    }

    public String getHrefLang() {
        return this.hrefLang;
    }

    public void setHrefLang(String v) {
        this.hrefLang = v;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String v) {
        this.title = v;
    }

    public String getTitleLang() {
        return this.titleLang;
    }

    public void setTitleLang(String v) {
        this.titleLang = v;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long v) {
        this.length = v;
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content c) {
        this.content = c;
    }

    public String getEtag() {
        return this.etag;
    }

    public void setEtag(String v) {
        this.etag = v;
    }

    public boolean matches(String relToMatch, String typeToMatch) {
        return !(relToMatch != null && !relToMatch.equals(this.getRel()) || typeToMatch != null && !typeToMatch.equals(this.type));
    }

    public XmlParser.ElementHandler getHandler(ExtensionProfile p, String namespace, String localName, Attributes attrs) {
        return new AtomHandler(p);
    }

    public void generate(XmlWriter w, ExtensionProfile p) throws IOException {
        this.generateAtom(w, p);
    }

    public void generateAtom(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>(3);
        ArrayList<XmlNamespace> nsDecls = new ArrayList<XmlNamespace>();
        if (this.rel != null) {
            attrs.add(new XmlWriter.Attribute("rel", this.rel));
        }
        if (this.type != null) {
            attrs.add(new XmlWriter.Attribute("type", this.type));
        }
        if (this.href != null) {
            attrs.add(new XmlWriter.Attribute("href", this.href));
        }
        if (this.hrefLang != null) {
            attrs.add(new XmlWriter.Attribute("hreflang", this.hrefLang));
        }
        if (this.title != null) {
            attrs.add(new XmlWriter.Attribute("title", this.title));
        }
        if (this.titleLang != null) {
            attrs.add(new XmlWriter.Attribute("xml:lang", this.titleLang));
        }
        if (this.length != -1L) {
            attrs.add(new XmlWriter.Attribute("length", String.valueOf(this.length)));
        }
        if (this.etag != null) {
            nsDecls.add(Namespaces.gNs);
            attrs.add(new XmlWriter.Attribute("gd", "etag", this.etag));
        }
        this.generateStartElement(w, Namespaces.atomNs, "link", attrs, nsDecls);
        if (this.content != null) {
            this.content.generateAtom(w, extProfile);
        }
        this.generateExtensions(w, extProfile);
        w.endElement(Namespaces.atomNs, "link");
    }

    public void generateRss(XmlWriter w) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>(3);
        if (this.rel != null && this.rel.equals("enclosure")) {
            if (this.type != null) {
                attrs.add(new XmlWriter.Attribute("type", this.type));
            }
            if (this.href != null) {
                attrs.add(new XmlWriter.Attribute("url", this.href));
            }
            if (this.length != -1L) {
                attrs.add(new XmlWriter.Attribute("length", String.valueOf(this.length)));
            }
            w.simpleElement(Namespaces.rssNs, "enclosure", attrs, null);
        } else if ("comments".equals(this.rel)) {
            w.simpleElement(Namespaces.rssNs, "comments", null, this.href);
        } else if ("alternate".equals(this.rel)) {
            w.simpleElement(Namespaces.rssNs, "link", null, this.href);
        } else if ("via".equals(this.rel) && this.href != null) {
            attrs.add(new XmlWriter.Attribute("url", this.href));
            w.simpleElement(Namespaces.rssNs, "source", attrs, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AtomHandler
    extends ExtensionPoint.ExtensionHandler {
        private final boolean linkRequired;

        public AtomHandler(ExtensionProfile extProfile) {
            super(extProfile, Link.class);
            this.linkRequired = true;
        }

        protected AtomHandler(ExtensionProfile extProfile, Class<? extends Link> extendedClass) {
            super(extProfile, extendedClass);
            this.linkRequired = false;
        }

        @Override
        public void processAttribute(String namespace, String localName, String value) throws ParseException {
            if (namespace.equals("")) {
                if (localName.equals("rel")) {
                    Link.this.rel = value;
                } else if (localName.equals("type")) {
                    Link.this.type = value;
                } else if (localName.equals("href")) {
                    Link.this.href = this.getAbsoluteUri(value);
                } else if (localName.equals("hreflang")) {
                    Link.this.hrefLang = value;
                } else if (localName.equals("title")) {
                    Link.this.title = value;
                } else if (localName.equals("length")) {
                    try {
                        Link.this.length = Integer.valueOf(value).longValue();
                    }
                    catch (NumberFormatException e) {
                        throw new ParseException(CoreErrorDomain.ERR.lengthNotInteger);
                    }
                }
            } else if (namespace.equals("http://schemas.google.com/g/2005") && localName.equals("etag")) {
                Link.this.etag = value;
            }
        }

        @Override
        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
            if (namespace.equals("http://www.w3.org/2005/Atom") && localName.equals("content")) {
                if (Link.this.content != null) {
                    throw new ParseException(CoreErrorDomain.ERR.duplicateContent);
                }
                Content.ChildHandlerInfo chi = Content.getChildHandler(this.extProfile, attrs);
                Link.this.content = chi.content;
                return chi.handler;
            }
            return super.getChildHandler(namespace, localName, attrs);
        }

        @Override
        public void processEndElement() throws ParseException {
            if (this.linkRequired && Link.this.href == null) {
                throw new ParseException(CoreErrorDomain.ERR.missingHrefAttribute);
            }
            Link.this.titleLang = this.xmlLang;
        }
    }

    public static final class Type {
        public static final String ATOM = ContentType.ATOM.getMediaType();
        public static final String HTML = ContentType.TEXT_HTML.getMediaType();
    }

    public static final class Rel {
        public static final String SELF = "self";
        public static final String PREVIOUS = "previous";
        public static final String NEXT = "next";
        public static final String ALTERNATE = "alternate";
        public static final String RELATED = "related";
        public static final String FEED = "http://schemas.google.com/g/2005#feed";
        public static final String ENTRY_POST = "http://schemas.google.com/g/2005#post";
        public static final String ENTRY_EDIT = "edit";
        public static final String MEDIA_EDIT = "edit-media";
        @Deprecated
        public static final String MEDIA_EDIT_BACKCOMPAT = "media-edit";
        public static final String FEED_BATCH = "http://schemas.google.com/g/2005#batch";
        public static final String VIA = "via";
        public static final String ENCLOSURE = "enclosure";
    }
}

