/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.LDAPSearchResult;
import com.novell.ldap.LDAPSearchResultReference;
import com.novell.ldap.MessageAgent;
import com.novell.ldap.client.ExtResponseFactory;
import com.novell.ldap.client.IntermediateResponseFactory;
import com.novell.ldap.rfc2251.RfcLDAPMessage;

public abstract class LDAPMessageQueue {
    MessageAgent agent;
    String name = "";
    static Object nameLock = new Object();
    static int queueNum = 0;

    LDAPMessageQueue(String string, MessageAgent messageAgent) {
        this.agent = messageAgent;
    }

    String getDebugName() {
        return this.name;
    }

    MessageAgent getMessageAgent() {
        return this.agent;
    }

    public int[] getMessageIDs() {
        return this.agent.getMessageIDs();
    }

    public LDAPMessage getResponse() throws LDAPException {
        return this.getResponse(null);
    }

    public LDAPMessage getResponse(int n) throws LDAPException {
        return this.getResponse(new Integer(n));
    }

    private LDAPMessage getResponse(Integer n) throws LDAPException {
        LDAPMessage lDAPMessage;
        Object object = this.agent.getLDAPMessage(n);
        if (object == null) {
            return null;
        }
        if (object instanceof LDAPResponse) {
            return (LDAPMessage)object;
        }
        RfcLDAPMessage rfcLDAPMessage = (RfcLDAPMessage)object;
        switch (rfcLDAPMessage.getType()) {
            case 4: {
                lDAPMessage = new LDAPSearchResult(rfcLDAPMessage);
                break;
            }
            case 19: {
                lDAPMessage = new LDAPSearchResultReference(rfcLDAPMessage);
                break;
            }
            case 25: {
                lDAPMessage = IntermediateResponseFactory.convertToIntermediateResponse(rfcLDAPMessage);
                break;
            }
            case 24: {
                ExtResponseFactory extResponseFactory = new ExtResponseFactory();
                lDAPMessage = ExtResponseFactory.convertToExtendedResponse(rfcLDAPMessage);
                break;
            }
            default: {
                lDAPMessage = new LDAPResponse(rfcLDAPMessage);
            }
        }
        return lDAPMessage;
    }

    public boolean isResponseReceived() {
        return this.agent.isResponseReceived();
    }

    public boolean isResponseReceived(int n) {
        return this.agent.isResponseReceived(n);
    }

    public boolean isComplete(int n) {
        return this.agent.isComplete(n);
    }
}

