/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir.eventdata;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.events.edir.EventResponseData;
import com.novell.ldap.events.edir.eventdata.DSETimeStamp;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ValueEventData
implements EventResponseData {
    private final String attribute;
    private final String classid;
    private final String data;
    private final String entry;
    private final String prepetratorDN;
    private final String syntax;
    private final DSETimeStamp timeStamp;
    private final int verb;

    public ValueEventData(ASN1Object aSN1Object) throws IOException {
        byte[] byArray = ((ASN1OctetString)aSN1Object).byteValue();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        LBERDecoder lBERDecoder = new LBERDecoder();
        int[] nArray = new int[1];
        this.prepetratorDN = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
        this.entry = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
        this.attribute = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
        this.syntax = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
        this.classid = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
        this.timeStamp = new DSETimeStamp((ASN1Sequence)lBERDecoder.decode(byteArrayInputStream, nArray));
        this.data = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
        this.verb = ((ASN1Integer)lBERDecoder.decode(byteArrayInputStream, nArray)).intValue();
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String getClassid() {
        return this.classid;
    }

    public String getData() {
        return this.data;
    }

    public String getEntry() {
        return this.entry;
    }

    public String getPrepetratorDN() {
        return this.prepetratorDN;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public DSETimeStamp getTimeStamp() {
        return this.timeStamp;
    }

    public int getVerb() {
        return this.verb;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ValueEventData");
        stringBuffer.append("(Attribute =" + this.getAttribute() + ")");
        stringBuffer.append("(Classid =" + this.getClassid() + ")");
        stringBuffer.append("(Data=" + this.getData() + ")");
        stringBuffer.append("(Entry =" + this.getEntry() + ")");
        stringBuffer.append("(Perpetrator =" + this.getPrepetratorDN() + ")");
        stringBuffer.append("(Syntax =" + this.getSyntax() + ")");
        stringBuffer.append("(TimeStamp =" + this.getTimeStamp() + ")");
        stringBuffer.append("(Verb =" + this.getVerb() + ")");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

