/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.rfc2251;

import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.asn1.ASN1Boolean;
import com.novell.ldap.asn1.ASN1Choice;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1SequenceOf;
import com.novell.ldap.asn1.ASN1Set;
import com.novell.ldap.asn1.ASN1SetOf;
import com.novell.ldap.asn1.ASN1Tagged;
import com.novell.ldap.rfc2251.RfcAssertionValue;
import com.novell.ldap.rfc2251.RfcAttributeDescription;
import com.novell.ldap.rfc2251.RfcAttributeValueAssertion;
import com.novell.ldap.rfc2251.RfcLDAPString;
import com.novell.ldap.rfc2251.RfcMatchingRuleAssertion;
import com.novell.ldap.rfc2251.RfcMatchingRuleId;
import com.novell.ldap.rfc2251.RfcSubstringFilter;
import com.novell.ldap.util.Base64;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;

public class RfcFilter
extends ASN1Choice {
    public static final int AND = 0;
    public static final int OR = 1;
    public static final int NOT = 2;
    public static final int EQUALITY_MATCH = 3;
    public static final int SUBSTRINGS = 4;
    public static final int GREATER_OR_EQUAL = 5;
    public static final int LESS_OR_EQUAL = 6;
    public static final int PRESENT = 7;
    public static final int APPROX_MATCH = 8;
    public static final int EXTENSIBLE_MATCH = 9;
    public static final int INITIAL = 0;
    public static final int ANY = 1;
    public static final int FINAL = 2;
    private FilterTokenizer ft;
    private Stack filterStack;
    private boolean finalFound;

    public RfcFilter(String string) throws LDAPException {
        super((ASN1Object)null);
        this.setChoiceValue(this.parse(string));
    }

    public RfcFilter() {
        super((ASN1Object)null);
        this.filterStack = new Stack();
    }

    private final ASN1Tagged parse(String string) throws LDAPException {
        int n;
        int n2;
        int n3;
        if (string == null || string.equals("")) {
            string = new String("(objectclass=*)");
        }
        if ((n3 = string.indexOf(92)) != -1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            n2 = n3;
            while (n2 < stringBuffer.length() - 1) {
                if ((n = stringBuffer.charAt(n2++)) != 92 || (n = stringBuffer.charAt(n2)) != 42 && n != 40 && n != 41 && n != 92) continue;
                stringBuffer.delete(n2, n2 + 1);
                stringBuffer.insert(n2, Integer.toHexString(n));
                n2 += 2;
            }
            string = stringBuffer.toString();
        }
        if (string.charAt(0) != '(' && string.charAt(string.length() - 1) != ')') {
            string = "(" + string + ")";
        }
        char c = string.charAt(0);
        n2 = string.length();
        if (c != '(') {
            throw new LDAPLocalException("MISSING_LEFT_PAREN", 87);
        }
        if (string.charAt(n2 - 1) != ')') {
            throw new LDAPLocalException("MISSING_RIGHT_PAREN", 87);
        }
        n = 0;
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) == '(') {
                ++n;
            }
            if (string.charAt(i) != ')') continue;
            --n;
        }
        if (n > 0) {
            throw new LDAPLocalException("MISSING_RIGHT_PAREN", 87);
        }
        if (n < 0) {
            throw new LDAPLocalException("MISSING_LEFT_PAREN", 87);
        }
        this.ft = new FilterTokenizer(string);
        return this.parseFilter();
    }

    private final ASN1Tagged parseFilter() throws LDAPException {
        this.ft.getLeftParen();
        ASN1Tagged aSN1Tagged = this.parseFilterComp();
        this.ft.getRightParen();
        return aSN1Tagged;
    }

    private final ASN1Tagged parseFilterComp() throws LDAPException {
        ASN1Tagged aSN1Tagged = null;
        int n = this.ft.getOpOrAttr();
        block0 : switch (n) {
            case 0: 
            case 1: {
                aSN1Tagged = new ASN1Tagged(new ASN1Identifier(2, true, n), this.parseFilterList(), false);
                break;
            }
            case 2: {
                aSN1Tagged = new ASN1Tagged(new ASN1Identifier(2, true, n), this.parseFilter(), true);
                break;
            }
            default: {
                int n2 = this.ft.getFilterType();
                String string = this.ft.getValue();
                switch (n2) {
                    case 5: 
                    case 6: 
                    case 8: {
                        aSN1Tagged = new ASN1Tagged(new ASN1Identifier(2, true, n2), new RfcAttributeValueAssertion(new RfcAttributeDescription(this.ft.getAttr()), new RfcAssertionValue(this.unescapeString(string))), false);
                        break block0;
                    }
                    case 3: {
                        if (string.equals("*")) {
                            aSN1Tagged = new ASN1Tagged(new ASN1Identifier(2, false, 7), new RfcAttributeDescription(this.ft.getAttr()), false);
                            break block0;
                        }
                        if (string.indexOf(42) != -1) {
                            StringTokenizer stringTokenizer = new StringTokenizer(string, "*", true);
                            ASN1SequenceOf aSN1SequenceOf = new ASN1SequenceOf(5);
                            int n3 = stringTokenizer.countTokens();
                            int n4 = 0;
                            String string2 = new String("");
                            while (stringTokenizer.hasMoreTokens()) {
                                String string3 = stringTokenizer.nextToken();
                                ++n4;
                                if (string3.equals("*")) {
                                    if (string2.equals(string3)) {
                                        aSN1SequenceOf.add(new ASN1Tagged(new ASN1Identifier(2, false, 1), new RfcLDAPString(this.unescapeString("")), false));
                                    }
                                } else if (n4 == 1) {
                                    aSN1SequenceOf.add(new ASN1Tagged(new ASN1Identifier(2, false, 0), new RfcLDAPString(this.unescapeString(string3)), false));
                                } else if (n4 < n3) {
                                    aSN1SequenceOf.add(new ASN1Tagged(new ASN1Identifier(2, false, 1), new RfcLDAPString(this.unescapeString(string3)), false));
                                } else {
                                    aSN1SequenceOf.add(new ASN1Tagged(new ASN1Identifier(2, false, 2), new RfcLDAPString(this.unescapeString(string3)), false));
                                }
                                string2 = string3;
                            }
                            aSN1Tagged = new ASN1Tagged(new ASN1Identifier(2, true, 4), new RfcSubstringFilter(new RfcAttributeDescription(this.ft.getAttr()), aSN1SequenceOf), false);
                            break block0;
                        }
                        aSN1Tagged = new ASN1Tagged(new ASN1Identifier(2, true, 3), new RfcAttributeValueAssertion(new RfcAttributeDescription(this.ft.getAttr()), new RfcAssertionValue(this.unescapeString(string))), false);
                        break block0;
                    }
                    case 9: {
                        String string4 = null;
                        String string5 = null;
                        boolean bl = false;
                        StringTokenizer stringTokenizer = new StringTokenizer(this.ft.getAttr(), ":", true);
                        boolean bl2 = true;
                        while (stringTokenizer.hasMoreTokens()) {
                            String string6 = stringTokenizer.nextToken().trim();
                            if (bl2 && !string6.equals(":")) {
                                string4 = string6;
                            } else if (string6.equals("dn")) {
                                bl = true;
                            } else if (!string6.equals(":")) {
                                string5 = string6;
                            }
                            bl2 = false;
                        }
                        aSN1Tagged = new ASN1Tagged(new ASN1Identifier(2, true, 9), new RfcMatchingRuleAssertion(string5 == null ? null : new RfcMatchingRuleId(string5), string4 == null ? null : new RfcAttributeDescription(string4), new RfcAssertionValue(this.unescapeString(string)), !bl ? null : new ASN1Boolean(true)), false);
                    }
                }
            }
        }
        return aSN1Tagged;
    }

    private final ASN1SetOf parseFilterList() throws LDAPException {
        ASN1SetOf aSN1SetOf = new ASN1SetOf();
        aSN1SetOf.add(this.parseFilter());
        while (this.ft.peekChar() == '(') {
            aSN1SetOf.add(this.parseFilter());
        }
        return aSN1SetOf;
    }

    static final int hex2int(char c) {
        return c >= '0' && c <= '9' ? c - 48 : (c >= 'A' && c <= 'F' ? c - 65 + 10 : (c >= 'a' && c <= 'f' ? c - 97 + 10 : -1));
    }

    private final byte[] unescapeString(String string) throws LDAPException {
        byte[] byArray = new byte[string.length() * 3];
        boolean bl = false;
        boolean bl2 = false;
        int n = string.length();
        char[] cArray = new char[1];
        char c = '\u0000';
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (bl) {
                int n3 = RfcFilter.hex2int(c2);
                if (n3 < 0) {
                    throw new LDAPLocalException("INVALID_ESCAPE", new Object[]{new Character(c2)}, 87);
                }
                if (bl2) {
                    c = (char)(n3 << 4);
                    bl2 = false;
                    continue;
                }
                c = (char)(c | (char)n3);
                byArray[n2++] = (byte)c;
                bl = false;
                bl2 = false;
                continue;
            }
            if (c2 == '\\') {
                bl = true;
                bl2 = true;
                continue;
            }
            try {
                byte[] byArray2;
                if (c2 >= '\u0001' && c2 <= '\'' || c2 >= '+' && c2 <= '[' || c2 >= ']') {
                    if (c2 <= '\u007f') {
                        byArray[n2++] = (byte)c2;
                    } else {
                        cArray[0] = c2;
                        byArray2 = new String(cArray).getBytes("UTF-8");
                        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
                        n2 += byArray2.length;
                    }
                } else {
                    String string2 = "";
                    cArray[0] = c2;
                    byArray2 = new String(cArray).getBytes("UTF-8");
                    for (int j = 0; j < byArray2.length; ++j) {
                        byte by = byArray2[j];
                        string2 = by >= 0 && by < 16 ? string2 + "\\0" + Integer.toHexString(by & 0xFF) : string2 + "\\" + Integer.toHexString(by & 0xFF);
                    }
                    throw new LDAPLocalException("INVALID_CHAR_IN_FILTER", new Object[]{new Character(c2), string2}, 87);
                }
                bl = false;
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("UTF-8 String encoding not supported by JVM");
            }
        }
        if (bl2 || bl) {
            throw new LDAPLocalException("SHORT_ESCAPE", 87);
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        byArray = null;
        return byArray3;
    }

    private void addObject(ASN1Object aSN1Object) throws LDAPLocalException {
        if (this.filterStack == null) {
            this.filterStack = new Stack();
        }
        if (this.choiceValue() == null) {
            this.setChoiceValue(aSN1Object);
        } else {
            ASN1Tagged aSN1Tagged = (ASN1Tagged)this.filterStack.peek();
            ASN1Object aSN1Object2 = aSN1Tagged.taggedValue();
            if (aSN1Object2 == null) {
                aSN1Tagged.setTaggedValue(aSN1Object);
                this.filterStack.add(aSN1Object);
            } else if (aSN1Object2 instanceof ASN1SetOf) {
                ((ASN1SetOf)aSN1Object2).add(aSN1Object);
            } else if (aSN1Object2 instanceof ASN1Set) {
                ((ASN1Set)aSN1Object2).add(aSN1Object);
            } else if (aSN1Object2.getIdentifier().getTag() == 2) {
                throw new LDAPLocalException("Attemp to create more than one 'not' sub-filter", 87);
            }
        }
        int n = aSN1Object.getIdentifier().getTag();
        if (n == 0 || n == 1 || n == 2) {
            this.filterStack.add(aSN1Object);
        }
    }

    public void startSubstrings(String string) throws LDAPLocalException {
        this.finalFound = false;
        ASN1SequenceOf aSN1SequenceOf = new ASN1SequenceOf(5);
        ASN1Tagged aSN1Tagged = new ASN1Tagged(new ASN1Identifier(2, true, 4), new RfcSubstringFilter(new RfcAttributeDescription(string), aSN1SequenceOf), false);
        this.addObject(aSN1Tagged);
        this.filterStack.push(aSN1SequenceOf);
    }

    public void addSubstring(int n, byte[] byArray) throws LDAPLocalException {
        try {
            ASN1SequenceOf aSN1SequenceOf = (ASN1SequenceOf)this.filterStack.peek();
            if (n != 0 && n != 1 && n != 2) {
                throw new LDAPLocalException("Attempt to add an invalid substring type", 87);
            }
            if (n == 0 && aSN1SequenceOf.size() != 0) {
                throw new LDAPLocalException("Attempt to add an initial substring match after the first substring", 87);
            }
            if (this.finalFound) {
                throw new LDAPLocalException("Attempt to add a substring match after a final substring match", 87);
            }
            if (n == 2) {
                this.finalFound = true;
            }
            aSN1SequenceOf.add(new ASN1Tagged(new ASN1Identifier(2, false, n), new RfcLDAPString(byArray), false));
        }
        catch (ClassCastException classCastException) {
            throw new LDAPLocalException("A call to addSubstring occured without calling startSubstring", 87);
        }
    }

    public void endSubstrings() throws LDAPLocalException {
        try {
            this.finalFound = false;
            ASN1SequenceOf aSN1SequenceOf = (ASN1SequenceOf)this.filterStack.peek();
            if (aSN1SequenceOf.size() == 0) {
                throw new LDAPLocalException("Empty substring filter", 87);
            }
        }
        catch (ClassCastException classCastException) {
            throw new LDAPLocalException("Missmatched ending of substrings", 87);
        }
        this.filterStack.pop();
    }

    public void addAttributeValueAssertion(int n, String string, byte[] byArray) throws LDAPLocalException {
        if (this.filterStack != null && !this.filterStack.empty() && this.filterStack.peek() instanceof ASN1SequenceOf) {
            throw new LDAPLocalException("Cannot insert an attribute assertion in a substring", 87);
        }
        if (n != 3 && n != 5 && n != 6 && n != 8) {
            throw new LDAPLocalException("Invalid filter type for AttributeValueAssertion", 87);
        }
        ASN1Tagged aSN1Tagged = new ASN1Tagged(new ASN1Identifier(2, true, n), new RfcAttributeValueAssertion(new RfcAttributeDescription(string), new RfcAssertionValue(byArray)), false);
        this.addObject(aSN1Tagged);
    }

    public void addPresent(String string) throws LDAPLocalException {
        ASN1Tagged aSN1Tagged = new ASN1Tagged(new ASN1Identifier(2, false, 7), new RfcAttributeDescription(string), false);
        this.addObject(aSN1Tagged);
    }

    public void addExtensibleMatch(String string, String string2, byte[] byArray, boolean bl) throws LDAPLocalException {
        ASN1Tagged aSN1Tagged = new ASN1Tagged(new ASN1Identifier(2, true, 9), new RfcMatchingRuleAssertion(string == null ? null : new RfcMatchingRuleId(string), string2 == null ? null : new RfcAttributeDescription(string2), new RfcAssertionValue(byArray), !bl ? null : new ASN1Boolean(true)), false);
        this.addObject(aSN1Tagged);
    }

    public void startNestedFilter(int n) throws LDAPLocalException {
        ASN1Tagged aSN1Tagged;
        if (n == 0 || n == 1) {
            aSN1Tagged = new ASN1Tagged(new ASN1Identifier(2, true, n), new ASN1SetOf(), false);
        } else if (n == 2) {
            aSN1Tagged = new ASN1Tagged(new ASN1Identifier(2, true, n), null, true);
        } else {
            throw new LDAPLocalException("Attempt to create a nested filter other than AND, OR or NOT", 87);
        }
        this.addObject(aSN1Tagged);
    }

    public void endNestedFilter(int n) throws LDAPLocalException {
        int n2;
        if (n == 2) {
            this.filterStack.pop();
        }
        if ((n2 = ((ASN1Object)this.filterStack.peek()).getIdentifier().getTag()) != n) {
            throw new LDAPLocalException("Missmatched ending of nested filter", 87);
        }
        this.filterStack.pop();
    }

    public Iterator getFilterIterator() {
        return new FilterIterator((ASN1Tagged)this.choiceValue());
    }

    public String filterToString() {
        StringBuffer stringBuffer = new StringBuffer();
        RfcFilter.stringFilter(this.getFilterIterator(), stringBuffer);
        return stringBuffer.toString();
    }

    private static void stringFilter(Iterator iterator, StringBuffer stringBuffer) {
        int n = -1;
        stringBuffer.append('(');
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Integer) {
                n = (Integer)e;
                switch (n) {
                    case 0: {
                        stringBuffer.append('&');
                        break;
                    }
                    case 1: {
                        stringBuffer.append('|');
                        break;
                    }
                    case 2: {
                        stringBuffer.append('!');
                        break;
                    }
                    case 3: {
                        stringBuffer.append((String)iterator.next());
                        stringBuffer.append('=');
                        byte[] byArray = (byte[])iterator.next();
                        stringBuffer.append(RfcFilter.byteString(byArray));
                        break;
                    }
                    case 5: {
                        stringBuffer.append((String)iterator.next());
                        stringBuffer.append(">=");
                        byte[] byArray = (byte[])iterator.next();
                        stringBuffer.append(RfcFilter.byteString(byArray));
                        break;
                    }
                    case 6: {
                        stringBuffer.append((String)iterator.next());
                        stringBuffer.append("<=");
                        byte[] byArray = (byte[])iterator.next();
                        stringBuffer.append(RfcFilter.byteString(byArray));
                        break;
                    }
                    case 7: {
                        stringBuffer.append((String)iterator.next());
                        stringBuffer.append("=*");
                        break;
                    }
                    case 8: {
                        stringBuffer.append((String)iterator.next());
                        stringBuffer.append("~=");
                        byte[] byArray = (byte[])iterator.next();
                        stringBuffer.append(RfcFilter.byteString(byArray));
                        break;
                    }
                    case 9: {
                        String string = (String)iterator.next();
                        stringBuffer.append((String)iterator.next());
                        stringBuffer.append(':');
                        stringBuffer.append(string);
                        stringBuffer.append(":=");
                        stringBuffer.append((String)iterator.next());
                        break;
                    }
                    case 4: {
                        stringBuffer.append((String)iterator.next());
                        stringBuffer.append('=');
                        boolean bl = false;
                        while (iterator.hasNext()) {
                            n = (Integer)iterator.next();
                            switch (n) {
                                case 0: {
                                    stringBuffer.append((String)iterator.next());
                                    stringBuffer.append('*');
                                    bl = false;
                                    break;
                                }
                                case 1: {
                                    if (bl) {
                                        stringBuffer.append('*');
                                    }
                                    stringBuffer.append((String)iterator.next());
                                    stringBuffer.append('*');
                                    bl = false;
                                    break;
                                }
                                case 2: {
                                    if (bl) {
                                        stringBuffer.append('*');
                                    }
                                    stringBuffer.append((String)iterator.next());
                                }
                            }
                        }
                        break;
                    }
                }
                continue;
            }
            if (!(e instanceof Iterator)) continue;
            RfcFilter.stringFilter((Iterator)e, stringBuffer);
        }
        stringBuffer.append(')');
    }

    private static String byteString(byte[] byArray) {
        String string = null;
        if (Base64.isValidUTF8(byArray, true)) {
            try {
                string = new String(byArray, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("Default JVM does not support UTF-8 encoding" + unsupportedEncodingException);
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] >= 0) {
                    stringBuffer.append("\\0");
                    stringBuffer.append(Integer.toHexString(byArray[i]));
                    continue;
                }
                stringBuffer.append("\\" + Integer.toHexString(byArray[i]).substring(6));
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    class FilterTokenizer
    implements Serializable {
        private String filter;
        private String attr;
        private int offset;
        private int filterLength;

        public FilterTokenizer(String string) {
            this.filter = string;
            this.offset = 0;
            this.filterLength = string.length();
        }

        public final void getLeftParen() throws LDAPException {
            if (this.offset >= this.filterLength) {
                throw new LDAPLocalException("UNEXPECTED_END", 87);
            }
            if (this.filter.charAt(this.offset++) != '(') {
                throw new LDAPLocalException("EXPECTING_LEFT_PAREN", new Object[]{new Character(this.filter.charAt(--this.offset))}, 87);
            }
        }

        public final void getRightParen() throws LDAPException {
            if (this.offset >= this.filterLength) {
                throw new LDAPLocalException("UNEXPECTED_END", 87);
            }
            if (this.filter.charAt(this.offset++) != ')') {
                throw new LDAPLocalException("EXPECTING_RIGHT_PAREN", new Object[]{new Character(this.filter.charAt(this.offset - 1))}, 87);
            }
        }

        public final int getOpOrAttr() throws LDAPException {
            int n;
            if (this.offset >= this.filterLength) {
                throw new LDAPLocalException("UNEXPECTED_END", 87);
            }
            char c = this.filter.charAt(this.offset);
            if (c == '&') {
                ++this.offset;
                n = 0;
            } else if (c == '|') {
                ++this.offset;
                n = 1;
            } else if (c == '!') {
                ++this.offset;
                n = 2;
            } else {
                int n2;
                if (this.filter.startsWith(":=", this.offset)) {
                    throw new LDAPLocalException("NO_MATCHING_RULE", 87);
                }
                if (this.filter.startsWith("::=", this.offset) || this.filter.startsWith(":::=", this.offset)) {
                    throw new LDAPLocalException("NO_DN_NOR_MATCHING_RULE", 87);
                }
                String string = "=~<>()";
                StringBuffer stringBuffer = new StringBuffer();
                while (string.indexOf(this.filter.charAt(this.offset)) == -1 && !this.filter.startsWith(":=", this.offset)) {
                    stringBuffer.append(this.filter.charAt(this.offset++));
                }
                this.attr = stringBuffer.toString().trim();
                if (this.attr.length() == 0 || this.attr.charAt(0) == ';') {
                    throw new LDAPLocalException("NO_ATTRIBUTE_NAME", 87);
                }
                for (n2 = 0; n2 < this.attr.length(); ++n2) {
                    char c2 = this.attr.charAt(n2);
                    if (Character.isLetterOrDigit(c2) || c2 == '-' || c2 == '.' || c2 == ';' || c2 == ':') continue;
                    if (c2 == '\\') {
                        throw new LDAPLocalException("INVALID_ESC_IN_DESCR", 87);
                    }
                    throw new LDAPLocalException("INVALID_CHAR_IN_DESCR", new Object[]{new Character(c2)}, 87);
                }
                n2 = this.attr.indexOf(59);
                if (n2 != -1 && n2 == this.attr.length() - 1) {
                    throw new LDAPLocalException("NO_OPTION", 87);
                }
                n = -1;
            }
            return n;
        }

        public final int getFilterType() throws LDAPException {
            int n;
            if (this.offset >= this.filterLength) {
                throw new LDAPLocalException("UNEXPECTED_END", 87);
            }
            if (this.filter.startsWith(">=", this.offset)) {
                this.offset += 2;
                n = 5;
            } else if (this.filter.startsWith("<=", this.offset)) {
                this.offset += 2;
                n = 6;
            } else if (this.filter.startsWith("~=", this.offset)) {
                this.offset += 2;
                n = 8;
            } else if (this.filter.startsWith(":=", this.offset)) {
                this.offset += 2;
                n = 9;
            } else if (this.filter.charAt(this.offset) == '=') {
                ++this.offset;
                n = 3;
            } else {
                throw new LDAPLocalException("INVALID_FILTER_COMPARISON", 87);
            }
            return n;
        }

        public final String getValue() throws LDAPException {
            if (this.offset >= this.filterLength) {
                throw new LDAPLocalException("UNEXPECTED_END", 87);
            }
            int n = this.filter.indexOf(41, this.offset);
            if (n == -1) {
                n = this.filterLength;
            }
            String string = this.filter.substring(this.offset, n);
            this.offset = n;
            return string;
        }

        public final String getAttr() {
            return this.attr;
        }

        public final char peekChar() throws LDAPException {
            if (this.offset >= this.filterLength) {
                throw new LDAPLocalException("UNEXPECTED_END", 87);
            }
            return this.filter.charAt(this.offset);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
        }
    }

    private class FilterIterator
    implements Iterator {
        ASN1Tagged root;
        boolean tagReturned = false;
        int index = -1;
        private boolean hasMore = true;

        public FilterIterator(ASN1Tagged aSN1Tagged) {
            this.root = aSN1Tagged;
        }

        public boolean hasNext() {
            return this.hasMore;
        }

        public Object next() {
            Object object = null;
            if (!this.tagReturned) {
                this.tagReturned = true;
                object = new Integer(this.root.getIdentifier().getTag());
            } else {
                ASN1Object aSN1Object = this.root.taggedValue();
                if (aSN1Object instanceof RfcLDAPString) {
                    this.hasMore = false;
                    object = ((RfcLDAPString)aSN1Object).stringValue();
                } else if (aSN1Object instanceof RfcSubstringFilter) {
                    RfcSubstringFilter rfcSubstringFilter = (RfcSubstringFilter)aSN1Object;
                    if (this.index == -1) {
                        this.index = 0;
                        RfcAttributeDescription rfcAttributeDescription = (RfcAttributeDescription)rfcSubstringFilter.get(0);
                        object = rfcAttributeDescription.stringValue();
                    } else if (this.index % 2 == 0) {
                        ASN1SequenceOf aSN1SequenceOf = (ASN1SequenceOf)rfcSubstringFilter.get(1);
                        object = new Integer(((ASN1Tagged)aSN1SequenceOf.get(this.index / 2)).getIdentifier().getTag());
                        ++this.index;
                    } else {
                        ASN1SequenceOf aSN1SequenceOf = (ASN1SequenceOf)rfcSubstringFilter.get(1);
                        ASN1Tagged aSN1Tagged = (ASN1Tagged)aSN1SequenceOf.get(this.index / 2);
                        RfcLDAPString rfcLDAPString = (RfcLDAPString)aSN1Tagged.taggedValue();
                        object = rfcLDAPString.stringValue();
                        ++this.index;
                    }
                    if (this.index / 2 >= ((ASN1SequenceOf)rfcSubstringFilter.get(1)).size()) {
                        this.hasMore = false;
                    }
                } else if (aSN1Object instanceof RfcAttributeValueAssertion) {
                    RfcAttributeValueAssertion rfcAttributeValueAssertion = (RfcAttributeValueAssertion)aSN1Object;
                    if (this.index == -1) {
                        object = rfcAttributeValueAssertion.getAttributeDescription();
                        this.index = 1;
                    } else if (this.index == 1) {
                        object = rfcAttributeValueAssertion.getAssertionValue();
                        this.index = 2;
                        this.hasMore = false;
                    }
                } else if (aSN1Object instanceof RfcMatchingRuleAssertion) {
                    RfcMatchingRuleAssertion rfcMatchingRuleAssertion = (RfcMatchingRuleAssertion)aSN1Object;
                    if (this.index == -1) {
                        this.index = 0;
                    }
                    object = ((ASN1OctetString)((ASN1Tagged)rfcMatchingRuleAssertion.get(this.index++)).taggedValue()).stringValue();
                    if (this.index > 2) {
                        this.hasMore = false;
                    }
                } else if (aSN1Object instanceof ASN1SetOf) {
                    ASN1SetOf aSN1SetOf = (ASN1SetOf)aSN1Object;
                    if (this.index == -1) {
                        this.index = 0;
                    }
                    object = new FilterIterator((ASN1Tagged)aSN1SetOf.get(this.index++));
                    if (this.index >= aSN1SetOf.size()) {
                        this.hasMore = false;
                    }
                } else if (aSN1Object instanceof ASN1Tagged) {
                    object = new FilterIterator((ASN1Tagged)aSN1Object);
                    this.hasMore = false;
                }
            }
            return object;
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported on a filter iterator");
        }
    }
}

