/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.contacts;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.contacts.GroupMembershipInfo;
import com.google.gdata.data.extensions.Deleted;
import com.google.gdata.data.extensions.Email;
import com.google.gdata.data.extensions.ExtendedProperty;
import com.google.gdata.data.extensions.Im;
import com.google.gdata.data.extensions.Organization;
import com.google.gdata.data.extensions.PhoneNumber;
import com.google.gdata.data.extensions.PostalAddress;
import com.google.gdata.util.common.xml.XmlNamespace;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Kind.Term(value="http://schemas.google.com/contact/2008#contact")
public class ContactEntry
extends BaseEntry<ContactEntry> {
    public static final String KIND = "http://schemas.google.com/contact/2008#contact";
    public static final Category CATEGORY = new Category("http://schemas.google.com/g/2005#kind", "http://schemas.google.com/contact/2008#contact");

    public ContactEntry() {
        this.getCategories().add(CATEGORY);
    }

    public ContactEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(ContactEntry.class)) {
            return;
        }
        super.declareExtensions(extProfile);
        extProfile.declare(ContactEntry.class, new ExtensionDescription(Deleted.class, new XmlNamespace("gd", "http://schemas.google.com/g/2005"), "deleted", false, false, false));
        extProfile.declare(ContactEntry.class, new ExtensionDescription(Email.class, new XmlNamespace("gd", "http://schemas.google.com/g/2005"), "email", false, true, false));
        extProfile.declare(ContactEntry.class, new ExtensionDescription(ExtendedProperty.class, new XmlNamespace("gd", "http://schemas.google.com/g/2005"), "extendedProperty", false, true, false));
        extProfile.declare(ContactEntry.class, GroupMembershipInfo.getDefaultDescription(false, true));
        extProfile.declare(ContactEntry.class, Im.getDefaultDescription(false, true));
        extProfile.declare(ContactEntry.class, Organization.getDefaultDescription(false, true));
        new Organization().declareExtensions(extProfile);
        extProfile.declare(ContactEntry.class, new ExtensionDescription(PhoneNumber.class, new XmlNamespace("gd", "http://schemas.google.com/g/2005"), "phoneNumber", false, true, false));
        extProfile.declare(ContactEntry.class, new ExtensionDescription(PostalAddress.class, new XmlNamespace("gd", "http://schemas.google.com/g/2005"), "postalAddress", false, true, false));
    }

    public Deleted getDeleted() {
        return (Deleted)this.getExtension(Deleted.class);
    }

    public void setDeleted(Deleted deleted) {
        if (deleted == null) {
            this.removeExtension(Deleted.class);
        } else {
            this.setExtension((Extension)deleted);
        }
    }

    public boolean hasDeleted() {
        return this.hasExtension(Deleted.class);
    }

    public List<Email> getEmailAddresses() {
        return this.getRepeatingExtension(Email.class);
    }

    public void addEmailAddress(Email emailAddress) {
        this.getEmailAddresses().add(emailAddress);
    }

    public boolean hasEmailAddresses() {
        return this.hasRepeatingExtension(Email.class);
    }

    public List<ExtendedProperty> getExtendedProperties() {
        return this.getRepeatingExtension(ExtendedProperty.class);
    }

    public void addExtendedProperty(ExtendedProperty extendedProperty) {
        this.getExtendedProperties().add(extendedProperty);
    }

    public boolean hasExtendedProperties() {
        return this.hasRepeatingExtension(ExtendedProperty.class);
    }

    public List<GroupMembershipInfo> getGroupMembershipInfos() {
        return this.getRepeatingExtension(GroupMembershipInfo.class);
    }

    public void addGroupMembershipInfo(GroupMembershipInfo groupMembershipInfo) {
        this.getGroupMembershipInfos().add(groupMembershipInfo);
    }

    public boolean hasGroupMembershipInfos() {
        return this.hasRepeatingExtension(GroupMembershipInfo.class);
    }

    public List<Im> getImAddresses() {
        return this.getRepeatingExtension(Im.class);
    }

    public void addImAddress(Im imAddress) {
        this.getImAddresses().add(imAddress);
    }

    public boolean hasImAddresses() {
        return this.hasRepeatingExtension(Im.class);
    }

    public List<Organization> getOrganizations() {
        return this.getRepeatingExtension(Organization.class);
    }

    public void addOrganization(Organization organization) {
        this.getOrganizations().add(organization);
    }

    public boolean hasOrganizations() {
        return this.hasRepeatingExtension(Organization.class);
    }

    public List<PhoneNumber> getPhoneNumbers() {
        return this.getRepeatingExtension(PhoneNumber.class);
    }

    public void addPhoneNumber(PhoneNumber phoneNumber) {
        this.getPhoneNumbers().add(phoneNumber);
    }

    public boolean hasPhoneNumbers() {
        return this.hasRepeatingExtension(PhoneNumber.class);
    }

    public List<PostalAddress> getPostalAddresses() {
        return this.getRepeatingExtension(PostalAddress.class);
    }

    public void addPostalAddress(PostalAddress postalAddress) {
        this.getPostalAddresses().add(postalAddress);
    }

    public boolean hasPostalAddresses() {
        return this.hasRepeatingExtension(PostalAddress.class);
    }

    public Link getContactEditPhotoLink() {
        return this.getLink("http://schemas.google.com/contacts/2008/rel#edit-photo", "image/*");
    }

    public Link getContactPhotoLink() {
        return this.getLink("http://schemas.google.com/contacts/2008/rel#photo", "image/*");
    }

    protected void validate() {
    }

    public String toString() {
        return "{ContactEntry " + super.toString() + "}";
    }
}

