/*
 * Decompiled with CFR 0.152.
 */
package openxdas;

import java.io.IOException;
import java.util.Date;
import openxdas.XDasException;
import openxdas.XDasSession;

public class XDasRecord {
    private static final int XDASD_REQ_EVENT = 0;
    private static final int XDASD_REQ_FILTER = 1;
    private static final int XDASD_EVT_SRQ_CHECK = 0;
    private static final int XDASD_EVT_SRQ_SUBMIT = 1;
    private static final int XDASD_EVT_SRQ_CHECK_AND_SUBMIT = 2;
    private static final String OPENXDAS_VERSION = "OX1";
    private static final int iInitiatorAuthAuthorityField = 0;
    private static final int iInitiatorDomainSpecificNameField = 1;
    private static final int iInitiatorDomainSpecificIdField = 2;
    private static final int iInitiatorInfoFields = 3;
    private static final int iTargetLocationNameField = 0;
    private static final int iTargetLocationAddressField = 1;
    private static final int iTargetServiceTypeField = 2;
    private static final int iTargetAuthAuthorityField = 3;
    private static final int iTargetPrincipalNameField = 4;
    private static final int iTargetPrincipalIdentityField = 5;
    private static final int iTargetInfoFields = 6;
    private XDasSession m_session;
    private int m_iEventNumber;
    private int m_iOutcome;
    private int m_iTimeOffset;
    private String[] m_sInitiatorInfoFields;
    private String[] m_sTargetInfoFields;
    private String m_sSrcDomain;
    private String m_sEventInfo;
    private long m_lTimeStamp;

    XDasRecord(XDasSession xDasSession, int n, int n2, String string, String string2, String string3) throws XDasException {
        this.m_session = xDasSession;
        this.clearRecord();
        this.putEventInfo(n, n2, string, string2, string3);
    }

    private void clearRecord() {
        this.m_lTimeStamp = 0L;
        this.m_iEventNumber = 0;
        this.m_iOutcome = -1;
        this.m_sInitiatorInfoFields = null;
        this.m_sTargetInfoFields = null;
        this.m_sSrcDomain = null;
        this.m_sEventInfo = null;
    }

    public void putEventInfo(int n, int n2, String string, String string2, String string3) throws XDasException {
        if (!this.m_session.hasRights(3)) {
            throw new XDasException(1);
        }
        if (n != 0) {
            this.m_iEventNumber = n;
        }
        if (n2 != -1) {
            if (!this.validOutcome(n2)) {
                throw new XDasException(17);
            }
            this.m_iOutcome = n2;
        }
        if (string != null) {
            this.m_sInitiatorInfoFields = XDasSession.parseSubStrings(string, 3, 15);
        }
        if (string2 != null) {
            this.m_sTargetInfoFields = XDasSession.parseSubStrings(string2, 6, 21);
        }
        if (string3 != null) {
            this.m_sEventInfo = XDasSession.formatString(string3);
        }
    }

    public void setEventNumber(int n) throws XDasException {
        if (!this.m_session.hasRights(3)) {
            throw new XDasException(1);
        }
        if (n == 0) {
            throw new XDasException(10);
        }
        this.m_iEventNumber = n;
    }

    public void setOutcome(int n) throws XDasException {
        if (!this.m_session.hasRights(3)) {
            throw new XDasException(1);
        }
        if (n == -1 || !this.validOutcome(n)) {
            throw new XDasException(17);
        }
        this.m_iOutcome = n;
    }

    public void setInitiatorInfo(String string) throws XDasException {
        if (!this.m_session.hasRights(3)) {
            throw new XDasException(1);
        }
        if (string == null) {
            throw new XDasException(15);
        }
        this.m_sInitiatorInfoFields = XDasSession.parseSubStrings(string, 3, 15);
    }

    public void setInitiatorInfo(String string, String string2, String string3) throws XDasException {
        if (!this.m_session.hasRights(3)) {
            throw new XDasException(1);
        }
        if (this.m_sInitiatorInfoFields == null) {
            this.m_sInitiatorInfoFields = new String[3];
        }
        this.m_sInitiatorInfoFields[0] = XDasSession.formatString(string);
        this.m_sInitiatorInfoFields[1] = XDasSession.formatString(string2);
        this.m_sInitiatorInfoFields[2] = XDasSession.formatString(string3);
    }

    public void setTargetInfo(String string) throws XDasException {
        if (!this.m_session.hasRights(3)) {
            throw new XDasException(1);
        }
        if (string == null) {
            throw new XDasException(21);
        }
        this.m_sTargetInfoFields = XDasSession.parseSubStrings(string, 6, 21);
    }

    public void setTargetInfo(String string, String string2, String string3, String string4, String string5, String string6) throws XDasException {
        if (!this.m_session.hasRights(3)) {
            throw new XDasException(1);
        }
        if (this.m_sTargetInfoFields == null) {
            this.m_sTargetInfoFields = new String[6];
        }
        this.m_sTargetInfoFields[0] = XDasSession.formatString(string);
        this.m_sTargetInfoFields[1] = XDasSession.formatString(string2);
        this.m_sTargetInfoFields[2] = XDasSession.formatString(string3);
        this.m_sTargetInfoFields[3] = XDasSession.formatString(string4);
        this.m_sTargetInfoFields[4] = XDasSession.formatString(string5);
        this.m_sTargetInfoFields[5] = XDasSession.formatString(string6);
    }

    public void setEventInfo(String string) throws XDasException {
        if (!this.m_session.hasRights(3)) {
            throw new XDasException(1);
        }
        if (string == null) {
            throw new XDasException(9);
        }
        this.m_sEventInfo = XDasSession.formatString(string);
    }

    public void commit() throws XDasException, IOException {
        if (this.m_iEventNumber == 0 || this.m_iOutcome == -1 || this.m_sInitiatorInfoFields == null || this.m_sTargetInfoFields == null || this.m_sEventInfo == null) {
            throw new XDasException(5);
        }
        if (this.m_lTimeStamp == 0L) {
            this.setTimeStamp();
        }
        this.sendRecord();
        this.clearRecord();
    }

    public void discard() {
        this.clearRecord();
    }

    public void setTimeStamp() {
        Date date = new Date();
        this.m_lTimeStamp = date.getTime() / 1000L;
    }

    private boolean validOutcome(int n) {
        switch (n & 0xFF) {
            case 0: {
                return (n & 0xFFFFC000) == 0;
            }
            case 1: {
                return (n & 0xFFF00000) == 0;
            }
            case 2: {
                return (n & 0xFFFFF800) == 0;
            }
        }
        return false;
    }

    private void putInt(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 24 & 0xFF);
        byArray[n2 + 1] = (byte)(n >>> 16 & 0xFF);
        byArray[n2 + 2] = (byte)(n >>> 8 & 0xFF);
        byArray[n2 + 3] = (byte)(n & 0xFF);
    }

    private int getInt(byte[] byArray, int n) {
        return (byArray[n] << 24) + (byArray[n + 1] << 16) + (byArray[n + 2] << 8) + byArray[n + 3];
    }

    private void sendRecord() throws XDasException, IOException {
        String string = this.formatRecord();
        int n = string.length();
        byte[] byArray = new byte[n + 20];
        this.putInt(n + 20, byArray, 0);
        this.putInt(0, byArray, 4);
        this.putInt(2, byArray, 8);
        this.putInt(0, byArray, 12);
        this.putInt(n, byArray, 16);
        for (int i = 0; i < n; ++i) {
            byArray[i + 20] = (byte)string.charAt(i);
        }
        this.m_session.m_outputStream.write(byArray);
        this.m_session.m_outputStream.flush();
        this.m_session.m_inputStream.read(byArray, 0, 4);
        int n2 = this.getInt(byArray, 0) - 4;
        if (byArray.length < n2) {
            byArray = new byte[n2];
        }
        this.m_session.m_inputStream.read(byArray, 0, n2);
        int n3 = this.getInt(byArray, 0);
        int n4 = this.getInt(byArray, 4);
        if (n3 != 0) {
            if (n4 != 0) {
                throw new XDasException(n3, n4);
            }
            throw new XDasException(n3);
        }
    }

    private int calcRecordLen() {
        int n;
        int n2 = 9 + OPENXDAS_VERSION.length() + 9 + 9 + 9 + this.m_session.getTimeSource().length() + 1 + this.m_session.getTimeZone().length() + 1 + 9 + 9;
        n2 += 4;
        String[] stringArray = this.m_session.getOriginatorFields();
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] != null) {
                n2 += stringArray[n].length() + 1;
                continue;
            }
            ++n2;
        }
        n2 += 4;
        stringArray = this.m_sInitiatorInfoFields;
        for (n = 0; n < this.m_sInitiatorInfoFields.length; ++n) {
            if (this.m_sInitiatorInfoFields[n] != null) {
                n2 += this.m_sInitiatorInfoFields[n].length() + 1;
                continue;
            }
            ++n2;
        }
        n2 += 4;
        for (n = 0; n < this.m_sTargetInfoFields.length; ++n) {
            if (this.m_sTargetInfoFields[n] != null) {
                n2 += this.m_sTargetInfoFields[n].length() + 1;
                continue;
            }
            ++n2;
        }
        n2 += 4;
        n2 = this.m_sSrcDomain != null ? (n2 += this.m_sSrcDomain.length() + 1) : ++n2;
        n2 += 4;
        n2 = this.m_sEventInfo != null ? (n2 += this.m_sEventInfo.length() + 1) : ++n2;
        return n2 += 3;
    }

    private String formatRecord() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(this.calcRecordLen());
        stringBuffer.append("HDR:0000:");
        stringBuffer.append(OPENXDAS_VERSION);
        stringBuffer.append(":");
        stringBuffer.append(Long.toHexString(this.m_lTimeStamp));
        stringBuffer.append(":");
        stringBuffer.append(Integer.toHexString(this.m_session.getUncertInterval()));
        stringBuffer.append(":");
        stringBuffer.append(Integer.toHexString(this.m_session.getUncertIndicator()));
        stringBuffer.append(":");
        stringBuffer.append(this.m_session.getTimeSource());
        stringBuffer.append(":");
        stringBuffer.append(this.m_session.getTimeZone());
        stringBuffer.append(":");
        stringBuffer.append(Integer.toHexString(this.m_iEventNumber));
        stringBuffer.append(":");
        stringBuffer.append(Integer.toHexString(this.m_iOutcome));
        stringBuffer.append(":");
        stringBuffer.append("ORG:");
        String[] stringArray = this.m_session.getOriginatorFields();
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] != null) {
                stringBuffer.append(stringArray[n]);
            }
            stringBuffer.append(":");
        }
        stringBuffer.append("INT:");
        for (n = 0; n < this.m_sInitiatorInfoFields.length; ++n) {
            if (this.m_sInitiatorInfoFields[n] != null) {
                stringBuffer.append(this.m_sInitiatorInfoFields[n]);
            }
            stringBuffer.append(":");
        }
        stringBuffer.append("TGT:");
        for (n = 0; n < this.m_sTargetInfoFields.length; ++n) {
            if (this.m_sTargetInfoFields[n] != null) {
                stringBuffer.append(this.m_sTargetInfoFields[n]);
            }
            stringBuffer.append(":");
        }
        stringBuffer.append("SRC:");
        if (this.m_sSrcDomain != null) {
            stringBuffer.append(this.m_sSrcDomain);
        }
        stringBuffer.append(":");
        stringBuffer.append("EVT:");
        if (this.m_sEventInfo != null) {
            stringBuffer.append(this.m_sEventInfo);
        }
        stringBuffer.append(":");
        stringBuffer.append("END");
        int n2 = stringBuffer.length();
        String string = Integer.toHexString(n2);
        int n3 = 4 - string.length() + 4;
        for (n = 0; n < string.length(); ++n) {
            stringBuffer.setCharAt(n3 + n, string.charAt(n));
        }
        return stringBuffer.toString();
    }
}

