/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.deployment.idas.basic;

import java.io.File;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.configuration.xml.ConfigurationHandler;
import org.eclipse.higgins.idas.api.ContextOpenException;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAuthNMaterials;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.idas.registry.discovery.FileDiscovery;
import org.eclipse.higgins.idas.registry.discovery.IDiscovery;

public class BasicIdAS {
    private Log log = LogFactory.getLog((String)BasicIdAS.class.getName());

    public static void main(String[] args) {
        BasicIdAS basicIdAS = new BasicIdAS();
        basicIdAS.readEntity();
    }

    private void readEntity() {
        try {
            IContext context = this.contextFromXRDS("./conf/Higgins-LDAP-Server.xrds");
            String entityID = context.open((IAuthNMaterials)new AuthNNamePasswordMaterials(context, "cn=admin,o=bandit", "admin"));
            IEntity entity = context.getEntity(entityID);
            this.displayEntityInfo(entity);
        }
        catch (ContextOpenException e) {
            e.printStackTrace();
        }
        catch (IdASException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void displayEntityInfo(IEntity entity) throws IdASException {
        Iterator attrIter = entity.getAttributes();
        this.log.info((Object)("printing " + entity.getEntityID()));
        System.out.println("entity ID = " + entity.getEntityID());
        System.out.println("entity's type = " + entity.getModel().getType());
        System.out.println("entity's attributes:");
        while (attrIter.hasNext()) {
            IAttribute attr = (IAttribute)attrIter.next();
            Iterator propValueIter = attr.getValues();
            System.out.println(attr.getType());
            while (propValueIter.hasNext()) {
                IValue propVal = (IValue)propValueIter.next();
                if (propVal.isSimple()) {
                    Object val = ((ISimpleValue)propVal).getData();
                    if (val instanceof String) {
                        System.out.println(val);
                        continue;
                    }
                    System.out.println("Unknown: " + val.toString());
                    continue;
                }
                System.out.println("Unknown Complex : ");
            }
        }
    }

    private IContext contextFromXRDS(String contextIDName) throws IdASException {
        IdASRegistry registry = IdASRegistry.getInstance();
        registry.setDiscovery((IDiscovery)new FileDiscovery(new File("./conf/contextfactories.xrds")));
        return registry.createContext(contextIDName);
    }

    private IContext contextFromConfig(String contextIDName) throws Exception {
        ConfigurationHandler handler = new ConfigurationHandler();
        handler.setConfigurationBase(".");
        handler.setFileName("./conf/IdASConfiguration1.xml");
        handler.configure(null);
        IdASRegistry registry = (IdASRegistry)handler.getSettings().get("IdentityAttributeService");
        return registry.createContext(contextIDName);
    }
}

